/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.tracker;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.util.TMUtils;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public class JPanelFeaturePenalty
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JComboBox<String> cmbboxFeature;
    private final JFormattedTextField txtfldFeatureWeight;
    private final List<String> features;

    public JPanelFeaturePenalty(List<String> features, Map<String, String> featureNames, int index) {
        this.features = features;
        this.setPreferredSize(new Dimension(280, 40));
        this.setSize(280, 40);
        this.setLayout(null);
        DefaultComboBoxModel<String> jComboBoxFeatureModel = new DefaultComboBoxModel<String>(TMUtils.getArrayFromMaping(features, featureNames).toArray(new String[0]));
        this.cmbboxFeature = new JComboBox();
        this.add(this.cmbboxFeature);
        this.cmbboxFeature.setModel(jComboBoxFeatureModel);
        this.cmbboxFeature.setBounds(2, 4, 205, 22);
        this.cmbboxFeature.setFont(Fonts.SMALL_FONT);
        this.txtfldFeatureWeight = new JFormattedTextField(new DecimalFormat("0.0"));
        this.txtfldFeatureWeight.setHorizontalAlignment(0);
        this.txtfldFeatureWeight.setValue(1.0);
        this.add(this.txtfldFeatureWeight);
        this.txtfldFeatureWeight.setBounds(220, 4, 30, 22);
        this.txtfldFeatureWeight.setSize(Fonts.TEXTFIELD_DIMENSION);
        this.txtfldFeatureWeight.setFont(Fonts.SMALL_FONT);
        GuiUtils.selectAllOnFocus(this.txtfldFeatureWeight);
        this.cmbboxFeature.setSelectedIndex(index);
    }

    public void setSelectedFeature(String feature, double weight) {
        int index = this.features.indexOf(feature);
        if (index < 0) {
            return;
        }
        this.cmbboxFeature.setSelectedIndex(index);
        this.txtfldFeatureWeight.setValue(weight);
    }

    public String getSelectedFeature() {
        return this.features.get(this.cmbboxFeature.getSelectedIndex());
    }

    public double getPenaltyWeight() {
        return ((Number)this.txtfldFeatureWeight.getValue()).doubleValue();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.cmbboxFeature.setEnabled(enabled);
        this.txtfldFeatureWeight.setEnabled(enabled);
    }
}

