/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import com.mxgraph.model.mxICell;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.mxGraphOutline;
import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.TrackNavigator;
import fiji.plugin.trackmate.visualization.trackscheme.InfoPane;
import fiji.plugin.trackmate.visualization.trackscheme.JGraphXAdapter;
import fiji.plugin.trackmate.visualization.trackscheme.TrackScheme;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeGraphComponent;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeKeyboardHandler;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemePopupMenu;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeToolbar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class TrackSchemeFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private InfoPane infoPane;
    private JGraphXAdapter graph;
    private final TrackScheme trackScheme;
    TrackSchemeGraphComponent graphComponent;
    protected final Logger logger = Logger.IJTOOLBAR_LOGGER;
    private final DisplaySettings displaySettings;

    public TrackSchemeFrame(TrackScheme trackScheme, DisplaySettings displaySettings) {
        this.trackScheme = trackScheme;
        this.displaySettings = displaySettings;
        this.graph = trackScheme.getGraph();
        this.setIconImage(Icons.TRACK_SCHEME_ICON.getImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createToolBar(), "North");
    }

    public void init(JGraphXAdapter lGraph) {
        this.graph = lGraph;
        this.graphComponent = this.createGraphComponent();
        this.infoPane = new InfoPane(this.trackScheme.getModel(), this.trackScheme.getSelectionModel());
        mxGraphOutline graphOutline = new mxGraphOutline((mxGraphComponent)this.graphComponent);
        JSplitPane inner = new JSplitPane(0, (Component)graphOutline, this.infoPane);
        inner.setDividerLocation(120);
        inner.setMinimumSize(new Dimension(0, 0));
        JSplitPane splitPane = new JSplitPane(1, inner, (Component)((Object)this.graphComponent));
        splitPane.setDividerLocation(170);
        this.getContentPane().add((Component)splitPane, "Center");
        TrackSchemeKeyboardHandler keyboardHandler = new TrackSchemeKeyboardHandler(this.graphComponent, new TrackNavigator(this.trackScheme.getModel(), this.trackScheme.getSelectionModel()));
        keyboardHandler.installKeyboardActions((JComponent)((Object)this.graphComponent));
        keyboardHandler.installKeyboardActions(this.infoPane);
    }

    public void centerViewOn(mxICell cell) {
        this.graphComponent.scrollCellToVisible(cell, true);
    }

    private TrackSchemeGraphComponent createGraphComponent() {
        final TrackSchemeGraphComponent gc = new TrackSchemeGraphComponent(this.graph, this.trackScheme, this.displaySettings);
        gc.getVerticalScrollBar().setUnitIncrement(16);
        gc.getHorizontalScrollBar().setUnitIncrement(16);
        gc.getConnectionHandler().setEnabled(false);
        new mxRubberband((mxGraphComponent)gc);
        gc.getGraphControl().addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ TrackSchemeFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.this$0.displayPopupMenu(gc.getCellAt(e.getX(), e.getY(), false), e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.this$0.displayPopupMenu(gc.getCellAt(e.getX(), e.getY(), false), e.getPoint());
                }
            }
        });
        gc.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (gc.isPanningEvent(e)) {
                    boolean in;
                    boolean bl = in = e.getWheelRotation() < 0;
                    if (in) {
                        gc.zoomIn();
                    } else {
                        gc.zoomOut();
                    }
                }
            }
        });
        gc.setKeepSelectionVisibleOnZoom(true);
        gc.setPanning(true);
        return gc;
    }

    private JToolBar createToolBar() {
        return new TrackSchemeToolbar(this.trackScheme);
    }

    private void displayPopupMenu(Object cell, Point point) {
        TrackSchemePopupMenu menu = new TrackSchemePopupMenu(this.trackScheme, cell, point);
        menu.show(this.graphComponent.getViewport().getView(), (int)point.getX(), (int)point.getY());
    }
}

