/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.interestpointdetection;

import ij.gui.GenericDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.generic.sequence.ImgLoaderHints;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.MultiResolutionImgLoader;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import spim.fiji.plugin.interestpointdetection.InterestPointDetection;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.fiji.spimdata.interestpoints.InterestPointValue;
import spim.process.interestpointdetection.Downsample;

public abstract class DifferenceOf
extends InterestPointDetection {
    protected static final int[] ds = new int[]{1, 2, 4, 8};
    public static String[] downsampleChoiceXY = new String[]{ds[0] + "x", ds[1] + "x", ds[2] + "x", ds[3] + "x", "Match Z Resolution (less downsampling)", "Match Z Resolution (more downsampling)"};
    public static String[] downsampleChoiceZ = new String[]{ds[0] + "x", ds[1] + "x", ds[2] + "x", ds[3] + "x"};
    public static String[] localizationChoice = new String[]{"None", "3-dimensional quadratic fit", "Gaussian mask localization fit"};
    public static String[] brightnessChoice = new String[]{"Very weak & small (beads)", "Weak & small (beads)", "Comparable to Sample & small (beads)", "Strong & small (beads)", "Advanced ...", "Interactive ..."};
    public static String[] limitDetectionChoice = new String[]{"Brightest", "Around median (of those above threshold)", "Weakest (above threshold)"};
    public static int defaultDownsampleXYIndex = 4;
    public static int defaultDownsampleZIndex = 0;
    public static int defaultLocalization = 1;
    public static int[] defaultBrightness = null;
    public static double defaultImageSigmaX = 0.5;
    public static double defaultImageSigmaY = 0.5;
    public static double defaultImageSigmaZ = 0.5;
    public static int defaultViewChoice = 0;
    public static double defaultAdditionalSigmaX = 0.0;
    public static double defaultAdditionalSigmaY = 0.0;
    public static double defaultAdditionalSigmaZ = 0.0;
    public static double defaultMinIntensity = 0.0;
    public static double defaultMaxIntensity = 65535.0;
    public static int defaultMaxDetections = 3000;
    public static int defaultMaxDetectionsTypeIndex = 0;
    protected boolean limitDetections = false;
    protected double imageSigmaX;
    protected double imageSigmaY;
    protected double imageSigmaZ;
    protected double additionalSigmaX;
    protected double additionalSigmaY;
    protected double additionalSigmaZ;
    protected double minIntensity;
    protected double maxIntensity;
    protected int maxDetections;
    protected int maxDetectionsTypeIndex;
    protected int localization;
    protected int downsampleXY;
    protected int downsampleZ;
    final ArrayList<Channel> channelsToProcess;

    public DifferenceOf(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        super(spimData, viewIdsToProcess);
        this.channelsToProcess = viewIdsToProcess != null ? SpimData2.getAllChannelsSorted(spimData, viewIdsToProcess) : null;
    }

    protected abstract void addAddtionalParameters(GenericDialog var1);

    protected abstract boolean queryAdditionalParameters(GenericDialog var1);

    @Override
    public boolean queryParameters(boolean downsample, boolean defineAnisotropy, boolean additionalSmoothing, boolean setMinMax, boolean limitDetections) {
        int c;
        List channels = ((SequenceDescription)this.spimData.getSequenceDescription()).getAllChannelsOrdered();
        this.init(channels.size());
        GenericDialog gd = new GenericDialog(this.getDescription());
        gd.addChoice("Subpixel_localization", localizationChoice, localizationChoice[defaultLocalization]);
        if (defaultBrightness == null || defaultBrightness.length != channels.size()) {
            defaultBrightness = new int[channels.size()];
            for (int i = 0; i < channels.size(); ++i) {
                DifferenceOf.defaultBrightness[i] = 1;
            }
        }
        for (int c2 = 0; c2 < this.channelsToProcess.size(); ++c2) {
            if (this.channelsToProcess.size() == 1) {
                gd.addChoice("Interest_point_specification (channel_" + this.channelsToProcess.get(c2).getName() + ")", brightnessChoice, brightnessChoice[defaultBrightness[this.channelsToProcess.get(c2).getId()]]);
                continue;
            }
            gd.addChoice("Interest_point_specification_(channel_" + this.channelsToProcess.get(c2).getName().replace(" ", "_") + ")", brightnessChoice, brightnessChoice[defaultBrightness[this.channelsToProcess.get(c2).getId()]]);
        }
        if (downsample) {
            gd.addChoice("Downsample_XY", downsampleChoiceXY, downsampleChoiceXY[defaultDownsampleXYIndex]);
            gd.addChoice("Downsample_Z", downsampleChoiceZ, downsampleChoiceZ[defaultDownsampleZIndex]);
        }
        if (additionalSmoothing) {
            gd.addNumericField("Presmooth_Sigma_X", defaultAdditionalSigmaX, 5);
            gd.addNumericField("Presmooth_Sigma_Y", defaultAdditionalSigmaY, 5);
            gd.addNumericField("Presmooth_Sigma_Z", defaultAdditionalSigmaZ, 5);
            gd.addMessage("Note: a sigma of 0.0 means no additional smoothing.", GUIHelper.mediumstatusfont);
        }
        if (setMinMax) {
            gd.addNumericField("Minimal_intensity", defaultMinIntensity, 1);
            gd.addNumericField("Maximal_intensity", defaultMaxIntensity, 1);
        }
        if (defineAnisotropy) {
            gd.addNumericField("Image_Sigma_X", defaultImageSigmaX, 5);
            gd.addNumericField("Image_Sigma_Y", defaultImageSigmaY, 5);
            gd.addNumericField("Image_Sigma_Z", defaultImageSigmaZ, 5);
            gd.addMessage("Please consider that usually the lower resolution in z is compensated by a lower sampling rate in z.\nOnly adjust the initial sigma's if this is not the case.", GUIHelper.mediumstatusfont);
        }
        this.limitDetections = limitDetections;
        if (limitDetections) {
            gd.addNumericField("Maximum_number of detections (highest n)", (double)defaultMaxDetections, 0);
            gd.addChoice("Type_of_detections_to_use", limitDetectionChoice, limitDetectionChoice[defaultMaxDetectionsTypeIndex]);
        }
        this.addAddtionalParameters(gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.localization = defaultLocalization = gd.getNextChoiceIndex();
        int[] brightness = new int[this.channelsToProcess.size()];
        for (c = 0; c < this.channelsToProcess.size(); ++c) {
            Channel channel = this.channelsToProcess.get(c);
            int n = gd.getNextChoiceIndex();
            DifferenceOf.defaultBrightness[channel.getId()] = n;
            brightness[c] = n;
        }
        if (downsample) {
            int dsxy = defaultDownsampleXYIndex = gd.getNextChoiceIndex();
            defaultDownsampleZIndex = gd.getNextChoiceIndex();
            int dsz = defaultDownsampleZIndex;
            this.downsampleZ = dsz == 0 ? 1 : (dsz == 1 ? 2 : (dsz == 2 ? 4 : 8));
            this.downsampleXY = dsxy == 0 ? 1 : (dsxy == 1 ? 2 : (dsxy == 2 ? 4 : (dsxy == 3 ? 8 : (dsxy == 4 ? 0 : -1))));
        } else {
            this.downsampleZ = 1;
            this.downsampleXY = 1;
        }
        if (additionalSmoothing) {
            this.additionalSigmaX = defaultAdditionalSigmaX = gd.getNextNumber();
            this.additionalSigmaY = defaultAdditionalSigmaY = gd.getNextNumber();
            this.additionalSigmaZ = defaultAdditionalSigmaZ = gd.getNextNumber();
        } else {
            this.additionalSigmaZ = 0.0;
            this.additionalSigmaY = 0.0;
            this.additionalSigmaX = 0.0;
        }
        if (setMinMax) {
            this.minIntensity = defaultMinIntensity = gd.getNextNumber();
            this.maxIntensity = defaultMaxIntensity = gd.getNextNumber();
        } else {
            this.maxIntensity = Double.NaN;
            this.minIntensity = Double.NaN;
        }
        for (c = 0; c < this.channelsToProcess.size(); ++c) {
            Channel channel = this.channelsToProcess.get(c);
            if (!(brightness[c] <= 3 ? !this.setDefaultValues(channel, brightness[c]) : (brightness[c] == 4 ? !this.setAdvancedValues(channel) : !this.setInteractiveValues(channel)))) continue;
            return false;
        }
        if (defineAnisotropy) {
            this.imageSigmaX = defaultImageSigmaX = gd.getNextNumber();
            this.imageSigmaY = defaultImageSigmaY = gd.getNextNumber();
            this.imageSigmaZ = defaultImageSigmaZ = gd.getNextNumber();
        } else {
            this.imageSigmaZ = 0.5;
            this.imageSigmaY = 0.5;
            this.imageSigmaX = 0.5;
        }
        if (limitDetections) {
            this.maxDetections = defaultMaxDetections = (int)Math.round(gd.getNextNumber());
            this.maxDetectionsTypeIndex = defaultMaxDetectionsTypeIndex = gd.getNextChoiceIndex();
        }
        return this.queryAdditionalParameters(gd);
    }

    protected <T extends RealType<T>> void preSmooth(RandomAccessibleInterval<T> img) {
        if (this.additionalSigmaX > 0.0 || this.additionalSigmaY > 0.0 || this.additionalSigmaZ > 0.0) {
            IOFunctions.println("presmoothing image with sigma=[" + this.additionalSigmaX + "," + this.additionalSigmaY + "," + this.additionalSigmaZ + "]");
            try {
                Gauss3.gauss((double[])new double[]{this.additionalSigmaX, this.additionalSigmaY, this.additionalSigmaZ}, (RandomAccessible)Views.extendMirrorSingle(img), img);
            }
            catch (IncompatibleTypeException e) {
                IOFunctions.println("presmoothing failed: " + (Object)((Object)e));
                e.printStackTrace();
            }
        }
    }

    public static List<InterestPoint> limitList(int maxDetections, int maxDetectionsTypeIndex, List<InterestPoint> list) {
        if (list.size() <= maxDetections) {
            return list;
        }
        if (!InterestPointValue.class.isInstance((Object)list.get(0))) {
            IOFunctions.println("ERROR: Cannot limit detections to " + maxDetections + ", wrong instance.");
            return list;
        }
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Limiting detections to " + maxDetections + ", type = " + limitDetectionChoice[maxDetectionsTypeIndex]);
        Collections.sort(list, new Comparator<InterestPoint>(){

            @Override
            public int compare(InterestPoint o1, InterestPoint o2) {
                double v2;
                double v1 = Math.abs(((InterestPointValue)o1).getIntensity());
                if (v1 < (v2 = Math.abs(((InterestPointValue)o2).getIntensity()))) {
                    return 1;
                }
                if (v1 == v2) {
                    return 0;
                }
                return -1;
            }
        });
        ArrayList<InterestPoint> listNew = new ArrayList<InterestPoint>();
        if (maxDetectionsTypeIndex == 0) {
            for (int i = 0; i < maxDetections; ++i) {
                listNew.add(list.get(i));
            }
        } else if (maxDetectionsTypeIndex == 2) {
            for (int i = 0; i < maxDetections; ++i) {
                listNew.add(list.get(list.size() - 1 - i));
            }
        } else {
            int median = list.size() / 2;
            IOFunctions.println("Medium intensity: " + Math.abs(((InterestPointValue)list.get(median)).getIntensity()));
            int from = median - maxDetections / 2;
            int to = median + maxDetections / 2;
            for (int i = from; i <= to; ++i) {
                listNew.add(list.get(list.size() - 1 - i));
            }
        }
        return listNew;
    }

    protected ViewId getViewSelection(String dialogHeader, String text, Channel channel) {
        ArrayList<ViewDescription> views = SpimData2.getAllViewIdsForChannelSorted(this.spimData, this.viewIdsToProcess, channel);
        String[] viewChoice = new String[views.size()];
        for (int i = 0; i < views.size(); ++i) {
            ViewDescription vd = views.get(i);
            viewChoice[i] = "Timepoint " + vd.getTimePointId() + ", Angle " + ((ViewSetup)vd.getViewSetup()).getAngle().getName() + ", Illum " + ((ViewSetup)vd.getViewSetup()).getIllumination().getName() + ", ViewSetupId " + vd.getViewSetupId();
        }
        if (defaultViewChoice >= views.size()) {
            defaultViewChoice = 0;
        }
        GenericDialog gd = new GenericDialog(dialogHeader);
        gd.addMessage(text);
        gd.addChoice("View", viewChoice, viewChoice[defaultViewChoice]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        defaultViewChoice = gd.getNextChoiceIndex();
        ViewId viewId = (ViewId)views.get(defaultViewChoice);
        return viewId;
    }

    protected abstract void init(int var1);

    protected abstract boolean setDefaultValues(Channel var1, int var2);

    protected abstract boolean setAdvancedValues(Channel var1);

    protected abstract boolean setInteractiveValues(Channel var1);

    protected void correctForDownsampling(List<InterestPoint> ips, AffineTransform3D t) {
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Correcting coordinates for downsampling (xy=" + this.downsampleXY + "x, z=" + this.downsampleZ + "x) using AffineTransform: " + t);
        if (ips == null || ips.size() == 0) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): WARNING: List is empty.");
            return;
        }
        double[] tmp = new double[ips.get(0).getL().length];
        for (InterestPoint ip : ips) {
            t.apply(ip.getL(), tmp);
            ip.getL()[0] = tmp[0];
            ip.getL()[1] = tmp[1];
            ip.getL()[2] = tmp[2];
            t.apply(ip.getW(), tmp);
            ip.getW()[0] = tmp[0];
            ip.getW()[1] = tmp[1];
            ip.getW()[2] = tmp[2];
        }
    }

    public int downsampleFactor(int downsampleXY, int downsampleZ, VoxelDimensions v) {
        double calXY = Math.min(v.dimension(0), v.dimension(1));
        double calZ = v.dimension(2) * (double)downsampleZ;
        double log2ratio = Math.log(calZ / calXY) / Math.log(2.0);
        double exp2 = downsampleXY == 0 ? Math.pow(2.0, Math.floor(log2ratio)) : Math.pow(2.0, Math.ceil(log2ratio));
        return (int)Math.round(exp2);
    }

    protected RandomAccessibleInterval<FloatType> openAndDownsample(SpimData2 spimData, ViewDescription vd, AffineTransform3D t) {
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Requesting Img from ImgLoader (tp=" + vd.getTimePointId() + ", setup=" + vd.getViewSetupId() + ")");
        int downsampleXY = this.downsampleXY;
        if (downsampleXY < 1) {
            this.downsampleXY = downsampleXY = this.downsampleFactor(downsampleXY, this.downsampleZ, ((ViewSetup)vd.getViewSetup()).getVoxelSize());
        }
        if (downsampleXY > 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Downsampling in XY " + downsampleXY + "x ...");
        }
        if (this.downsampleZ > 1) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Downsampling in Z " + this.downsampleZ + "x ...");
        }
        int dsx = downsampleXY;
        int dsy = downsampleXY;
        int dsz = this.downsampleZ;
        RandomAccessibleInterval input = null;
        ImgLoader imgLoader = (ImgLoader)((SequenceDescription)spimData.getSequenceDescription()).getImgLoader();
        if ((dsx > 1 || dsy > 1 || dsz > 1) && MultiResolutionImgLoader.class.isInstance(imgLoader)) {
            MultiResolutionImgLoader mrImgLoader = (MultiResolutionImgLoader)imgLoader;
            double[][] mipmapResolutions = mrImgLoader.getSetupImgLoader(vd.getViewSetupId()).getMipmapResolutions();
            int bestLevel = 0;
            for (int level = 0; level < mipmapResolutions.length; ++level) {
                double[] factors = mipmapResolutions[level];
                int fx = (int)Math.round(factors[0]);
                int fy = (int)Math.round(factors[1]);
                int fz = (int)Math.round(factors[2]);
                if (fx > dsx || fy > dsy || fz > dsz || !DifferenceOf.contains(fx, ds) || !DifferenceOf.contains(fy, ds) || !DifferenceOf.contains(fz, ds)) continue;
                bestLevel = level;
            }
            int fx = (int)Math.round(mipmapResolutions[bestLevel][0]);
            int fy = (int)Math.round(mipmapResolutions[bestLevel][1]);
            int fz = (int)Math.round(mipmapResolutions[bestLevel][2]);
            t.set(mrImgLoader.getSetupImgLoader(vd.getViewSetupId()).getMipmapTransforms()[bestLevel]);
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Using precomputed Multiresolution Images [" + fx + "x" + fy + "x" + fz + "], Remaining downsampling [" + (dsx /= fx) + "x" + (dsy /= fy) + "x" + (dsz /= fz) + "]");
            input = mrImgLoader.getSetupImgLoader(vd.getViewSetupId()).getFloatImage(vd.getTimePointId(), bestLevel, false, new ImgLoaderHint[]{ImgLoaderHints.LOAD_COMPLETELY});
        } else {
            input = imgLoader.getSetupImgLoader(vd.getViewSetupId()).getFloatImage(vd.getTimePointId(), false, new ImgLoaderHint[]{ImgLoaderHints.LOAD_COMPLETELY});
            t.identity();
        }
        ImgFactory f = ((Img)input).factory();
        t.set((double)downsampleXY, 0, 0);
        t.set((double)downsampleXY, 1, 1);
        t.set((double)this.downsampleZ, 2, 2);
        while (dsx > 1) {
            input = Downsample.simple2x(input, f, new boolean[]{true, false, false});
            dsx /= 2;
        }
        while (dsy > 1) {
            input = Downsample.simple2x(input, f, new boolean[]{false, true, false});
            dsy /= 2;
        }
        while (dsz > 1) {
            input = Downsample.simple2x(input, f, new boolean[]{false, false, true});
            dsz /= 2;
        }
        return input;
    }

    private static final boolean contains(int i, int[] values) {
        for (int j : values) {
            if (i != j) continue;
            return true;
        }
        return false;
    }
}

