/*
 * Decompiled with CFR 0.152.
 */
package spim.process.cuda;

import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.iterator.LocalizingZeroMinIntervalIterator;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import spim.Threads;
import spim.process.cuda.BlockGeneratorFixedSizePrecise;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.ImagePortion;

public class Block {
    final int numDimensions;
    final long[] blockSize;
    final long[] offset;
    final long[] effectiveSize;
    final long[] effectiveOffset;
    final long[] effectiveLocalOffset;
    final boolean isPrecise;
    final Vector<ImagePortion> portions;
    final ExecutorService taskExecutor;

    public Block(long[] blockSize, long[] offset, long[] effectiveSize, long[] effectiveOffset, long[] effectiveLocalOffset, boolean isPrecise) {
        this.numDimensions = blockSize.length;
        this.blockSize = (long[])blockSize.clone();
        this.offset = (long[])offset.clone();
        this.effectiveSize = (long[])effectiveSize.clone();
        this.effectiveOffset = (long[])effectiveOffset.clone();
        this.effectiveLocalOffset = (long[])effectiveLocalOffset.clone();
        this.isPrecise = isPrecise;
        long n = blockSize[0];
        for (int d = 1; d < this.numDimensions; ++d) {
            n *= blockSize[d];
        }
        this.portions = FusionHelper.divideIntoPortions(n, Threads.numThreads() * 2);
        this.taskExecutor = Executors.newFixedThreadPool(Threads.numThreads());
    }

    public long[] getBlockSize() {
        long[] dim = new long[this.blockSize.length];
        for (int d = 0; d < dim.length; ++d) {
            dim[d] = this.blockSize[d];
        }
        return dim;
    }

    public void finalize() {
        this.taskExecutor.shutdown();
    }

    public boolean isPrecise() {
        return this.isPrecise;
    }

    public void copyBlock(final RandomAccessible<FloatType> source, final RandomAccessibleInterval<FloatType> block) {
        ArrayList<1> tasks = new ArrayList<1>();
        int i = 0;
        while (i < this.portions.size()) {
            final int threadIdx = i++;
            tasks.add(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    if (source.numDimensions() == 3 && ArrayImg.class.isInstance(block)) {
                        Block.copy3dArray(threadIdx, Block.this.portions.size(), (RandomAccessible<FloatType>)source, (ArrayImg)block, Block.this.offset);
                    } else {
                        ImagePortion portion = Block.this.portions.get(threadIdx);
                        Block.copy(portion.getStartPosition(), portion.getLoopSize(), (RandomAccessible<FloatType>)source, (RandomAccessibleInterval<FloatType>)block, Block.this.offset);
                    }
                    return true;
                }
            });
        }
        try {
            this.taskExecutor.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            IOFunctions.println("Failed to copy block: " + e);
            e.printStackTrace();
            return;
        }
    }

    public void pasteBlock(final RandomAccessibleInterval<FloatType> target, final RandomAccessibleInterval<FloatType> block) {
        ArrayList<2> tasks = new ArrayList<2>();
        int i = 0;
        while (i < this.portions.size()) {
            final int threadIdx = i++;
            tasks.add(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    if (target.numDimensions() == 3 && ArrayImg.class.isInstance(target) && ArrayImg.class.isInstance(block)) {
                        Block.paste3d(threadIdx, Block.this.portions.size(), (ArrayImg)target, (ArrayImg)block, Block.this.effectiveOffset, Block.this.effectiveSize, Block.this.effectiveLocalOffset);
                    } else {
                        ImagePortion portion = Block.this.portions.get(threadIdx);
                        Block.paste(portion.getStartPosition(), portion.getLoopSize(), (RandomAccessibleInterval<FloatType>)target, (RandomAccessibleInterval<FloatType>)block, Block.this.effectiveOffset, Block.this.effectiveSize, Block.this.effectiveLocalOffset);
                    }
                    return true;
                }
            });
        }
        try {
            this.taskExecutor.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            IOFunctions.println("Failed to paste block: " + e);
            e.printStackTrace();
            return;
        }
    }

    private static final void copy(long start, long loopSize, RandomAccessible<FloatType> source, RandomAccessibleInterval<FloatType> block, long[] offset) {
        int numDimensions = source.numDimensions();
        Cursor cursor = Views.iterable(block).localizingCursor();
        long[] min = new long[numDimensions];
        long[] max = new long[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            min[d] = offset[d];
            max[d] = offset[d] + block.dimension(d) - 1L;
        }
        RandomAccess randomAccess = source.randomAccess((Interval)new FinalInterval(min, max));
        cursor.jumpFwd(start);
        long[] tmp = new long[numDimensions];
        for (long l = 0L; l < loopSize; ++l) {
            cursor.fwd();
            cursor.localize(tmp);
            for (int d = 0; d < numDimensions; ++d) {
                int n = d;
                tmp[n] = tmp[n] + offset[d];
            }
            randomAccess.setPosition(tmp);
            ((FloatType)cursor.get()).set((FloatType)randomAccess.get());
        }
    }

    private static final void copy3dArray(int threadIdx, int numThreads, RandomAccessible<FloatType> source, ArrayImg<FloatType, ?> block, long[] offset) {
        int w = (int)block.dimension(0);
        int h = (int)block.dimension(1);
        int d = (int)block.dimension(2);
        long offsetX = offset[0];
        long offsetY = offset[1];
        long offsetZ = offset[2];
        float[] blockArray = ((FloatArray)block.update(null)).getCurrentStorageArray();
        FinalInterval interval = new FinalInterval(new long[]{offsetX, offsetY, offsetZ}, new long[]{offsetX + (long)w - 1L, offsetY + (long)h - 1L, offsetZ + (long)d - 1L});
        RandomAccess randomAccess = source.randomAccess((Interval)interval);
        long[] tmp = new long[]{offsetX, offsetY, 0L};
        for (int z = threadIdx; z < d; z += numThreads) {
            tmp[2] = (long)z + offsetZ;
            randomAccess.setPosition(tmp);
            int i = z * h * w;
            for (int y = 0; y < h; ++y) {
                randomAccess.setPosition(offsetX, 0);
                for (int x = 0; x < w; ++x) {
                    blockArray[i++] = ((FloatType)randomAccess.get()).get();
                    randomAccess.fwd(0);
                }
                randomAccess.move(-w, 0);
                randomAccess.fwd(1);
            }
        }
    }

    private static final void paste(long start, long loopSize, RandomAccessibleInterval<FloatType> target, RandomAccessibleInterval<FloatType> block, long[] effectiveOffset, long[] effectiveSize, long[] effectiveLocalOffset) {
        int numDimensions = target.numDimensions();
        LocalizingZeroMinIntervalIterator cursor = new LocalizingZeroMinIntervalIterator(effectiveSize);
        RandomAccess blockRandomAccess = block.randomAccess();
        RandomAccess targetRandomAccess = target.randomAccess();
        cursor.jumpFwd(start);
        long[] tmp = new long[numDimensions];
        for (long l = 0L; l < loopSize; ++l) {
            int d;
            cursor.fwd();
            cursor.localize(tmp);
            for (d = 0; d < numDimensions; ++d) {
                int n = d;
                tmp[n] = tmp[n] + effectiveLocalOffset[d];
            }
            blockRandomAccess.setPosition(tmp);
            for (d = 0; d < numDimensions; ++d) {
                int n = d;
                tmp[n] = tmp[n] + (effectiveOffset[d] - effectiveLocalOffset[d]);
            }
            targetRandomAccess.setPosition(tmp);
            ((FloatType)targetRandomAccess.get()).set((FloatType)blockRandomAccess.get());
        }
    }

    private static final void paste3d(int threadIdx, int numThreads, ArrayImg<FloatType, ?> target, ArrayImg<FloatType, ?> block, long[] effectiveOffset, long[] effectiveSize, long[] effectiveLocalOffset) {
        int minX = (int)effectiveOffset[0];
        int minY = (int)effectiveOffset[1];
        int minZ = (int)effectiveOffset[2];
        int maxY = (int)effectiveSize[1] + minY;
        int maxZ = (int)effectiveSize[2] + minZ;
        int sX = (int)effectiveSize[0];
        int minXb = (int)effectiveLocalOffset[0];
        int minYb = (int)effectiveLocalOffset[1];
        int minZb = (int)effectiveLocalOffset[2];
        int w = (int)target.dimension(0);
        int h = (int)target.dimension(1);
        int wb = (int)block.dimension(0);
        int hb = (int)block.dimension(1);
        float[] blockArray = ((FloatArray)block.update(null)).getCurrentStorageArray();
        float[] targetArray = ((FloatArray)target.update(null)).getCurrentStorageArray();
        for (int z = minZ + threadIdx; z < maxZ; z += numThreads) {
            int zBlock = z - minZ + minZb;
            int iTarget = z * h * w + minY * w + minX;
            int iBlock = zBlock * hb * wb + minYb * wb + minXb;
            for (int y = minY; y < maxY; ++y) {
                Block.copyX(blockArray, targetArray, sX, iTarget, iBlock);
                iTarget += w;
                iBlock += wb;
            }
        }
    }

    private static final void copyX(float[] blockArray, float[] targetArray, int count, int iTarget, int iBlock) {
        for (int x = 0; x < count; ++x) {
            targetArray[iTarget++] = blockArray[iBlock++];
        }
    }

    public static void main(String[] args) {
        ArrayImg block = ArrayImgs.floats((long[])new long[]{384L, 384L});
        long[] blockSize = new long[block.numDimensions()];
        block.dimensions(blockSize);
        ArrayImg image = ArrayImgs.floats((long[])new long[]{1024L, 1024L});
        long[] imgSize = new long[image.numDimensions()];
        image.dimensions(imgSize);
        long[] kernelSize = new long[]{16L, 32L};
        BlockGeneratorFixedSizePrecise blockGenerator = new BlockGeneratorFixedSizePrecise(blockSize);
        Block[] blocks = blockGenerator.divideIntoBlocks(imgSize, kernelSize);
        int i = 0;
        for (Block b : blocks) {
            b.copyBlock((RandomAccessible<FloatType>)Views.extendMirrorDouble((RandomAccessibleInterval)image), (RandomAccessibleInterval<FloatType>)block);
            for (FloatType f : Views.iterable((RandomAccessibleInterval)block)) {
                f.set((float)i);
            }
            ++i;
            b.pasteBlock((RandomAccessibleInterval<FloatType>)image, (RandomAccessibleInterval<FloatType>)block);
        }
        ImageJFunctions.show((RandomAccessibleInterval)image);
    }
}

