/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.geometrichashing;

import ij.gui.GenericDialog;
import java.util.List;
import mpicbg.spim.data.sequence.ViewId;
import spim.fiji.plugin.Interest_Point_Registration;
import spim.fiji.plugin.interestpointregistration.InterestPointRegistration;
import spim.fiji.spimdata.SpimData2;
import spim.process.interestpointregistration.ChannelProcess;
import spim.process.interestpointregistration.PairwiseMatch;
import spim.process.interestpointregistration.RANSACParameters;
import spim.process.interestpointregistration.TransformationModel;
import spim.process.interestpointregistration.geometrichashing.GeometricHashingPairwise;
import spim.process.interestpointregistration.geometrichashing.GeometricHashingParameters;

public class GeometricHashing
extends InterestPointRegistration {
    public static int defaultModel = 2;
    public static boolean defaultRegularize = true;
    protected TransformationModel model = null;
    protected RANSACParameters ransacParams;
    protected GeometricHashingParameters ghParams;

    public GeometricHashing(SpimData2 spimData, List<ViewId> viewIdsToProcess, List<ChannelProcess> channelsToProcess) {
        super(spimData, viewIdsToProcess, channelsToProcess);
    }

    protected GeometricHashingPairwise pairwiseMatchingInstance(PairwiseMatch pair, String description) {
        return new GeometricHashingPairwise(pair, this.model, description, this.ransacParams, this.ghParams);
    }

    @Override
    protected TransformationModel getTransformationModel() {
        return this.model;
    }

    @Override
    public GeometricHashing newInstance(SpimData2 spimData, List<ViewId> viewIdsToProcess, List<ChannelProcess> channelsToProcess) {
        return new GeometricHashing(spimData, viewIdsToProcess, channelsToProcess);
    }

    @Override
    public String getDescription() {
        return "Fast 3d geometric hashing (rotation invariant)";
    }

    @Override
    public void addQuery(GenericDialog gd, Interest_Point_Registration.RegistrationType registrationType) {
        gd.addChoice("Transformation model", TransformationModel.modelChoice, TransformationModel.modelChoice[defaultModel]);
        gd.addCheckbox("Regularize_model", defaultRegularize);
        gd.addSlider("Allowed_error_for_RANSAC (px)", 0.5, 20.0, (double)RANSACParameters.max_epsilon);
        gd.addSlider("Significance required for a descriptor match", 1.0, 20.0, (double)GeometricHashingParameters.ratioOfDistance);
    }

    @Override
    public boolean parseDialog(GenericDialog gd, Interest_Point_Registration.RegistrationType registrationType) {
        defaultModel = gd.getNextChoiceIndex();
        this.model = new TransformationModel(defaultModel);
        defaultRegularize = gd.getNextBoolean();
        if (defaultRegularize && !this.model.queryRegularizedModel()) {
            return false;
        }
        float maxEpsilon = RANSACParameters.max_epsilon = (float)gd.getNextNumber();
        float ratioOfDistance = GeometricHashingParameters.ratioOfDistance = (float)gd.getNextNumber();
        this.ransacParams = new RANSACParameters(maxEpsilon, RANSACParameters.min_inlier_ratio, RANSACParameters.min_inlier_factor, RANSACParameters.num_iterations);
        this.ghParams = new GeometricHashingParameters(GeometricHashingParameters.differenceThreshold, ratioOfDistance, GeometricHashingParameters.useAssociatedBeads);
        return true;
    }
}

