/*
 * Decompiled with CFR 0.152.
 */
package org.siox.util;

import org.siox.util.IntHashMap;

public class Utils {
    private static final IntHashMap RGB_TO_LAB = new IntHashMap(100000);

    private Utils() {
    }

    public static void dilate(float[] cm, int xres, int yres) {
        int idx;
        int x;
        int y;
        for (y = 0; y < yres; ++y) {
            for (x = 0; x < xres - 1; ++x) {
                idx = y * xres + x;
                cm[idx] = Math.max(cm[idx], cm[idx + 1]);
            }
        }
        for (y = 0; y < yres; ++y) {
            for (x = xres - 1; x >= 1; --x) {
                idx = y * xres + x;
                cm[idx] = Math.max(cm[idx - 1], cm[idx]);
            }
        }
        for (y = 0; y < yres - 1; ++y) {
            for (x = 0; x < xres; ++x) {
                idx = y * xres + x;
                cm[idx] = Math.max(cm[idx], cm[(y + 1) * xres + x]);
            }
        }
        for (y = yres - 1; y >= 1; --y) {
            for (x = 0; x < xres; ++x) {
                idx = y * xres + x;
                cm[idx] = Math.max(cm[(y - 1) * xres + x], cm[idx]);
            }
        }
    }

    public static void erode(float[] cm, int xres, int yres) {
        int idx;
        int x;
        int y;
        for (y = 0; y < yres; ++y) {
            for (x = 0; x < xres - 1; ++x) {
                idx = y * xres + x;
                cm[idx] = Math.min(cm[idx], cm[idx + 1]);
            }
        }
        for (y = 0; y < yres; ++y) {
            for (x = xres - 1; x >= 1; --x) {
                idx = y * xres + x;
                cm[idx] = Math.min(cm[idx - 1], cm[idx]);
            }
        }
        for (y = 0; y < yres - 1; ++y) {
            for (x = 0; x < xres; ++x) {
                idx = y * xres + x;
                cm[idx] = Math.min(cm[idx], cm[(y + 1) * xres + x]);
            }
        }
        for (y = yres - 1; y >= 1; --y) {
            for (x = 0; x < xres; ++x) {
                idx = y * xres + x;
                cm[idx] = Math.min(cm[(y - 1) * xres + x], cm[idx]);
            }
        }
    }

    public static void normalizeMatrix(float[] cm) {
        float max = 0.0f;
        for (int i = 0; i < cm.length; ++i) {
            if (!(max < cm[i])) continue;
            max = cm[i];
        }
        if ((double)max <= 0.0) {
            return;
        }
        if ((double)max == 1.0) {
            return;
        }
        float alpha = 1.0f / max;
        Utils.premultiplyMatrix(alpha, cm);
    }

    public static void premultiplyMatrix(float alpha, float[] cm) {
        for (int i = 0; i < cm.length; ++i) {
            cm[i] = alpha * cm[i];
        }
    }

    public static void smoothcm(float[] cm, int xres, int yres, float f1, float f2, float f3) {
        int idx;
        int x;
        int y;
        for (y = 0; y < yres; ++y) {
            for (x = 0; x < xres - 2; ++x) {
                idx = y * xres + x;
                cm[idx] = f1 * cm[idx] + f2 * cm[idx + 1] + f3 * cm[idx + 2];
            }
        }
        for (y = 0; y < yres; ++y) {
            for (x = xres - 1; x >= 2; --x) {
                idx = y * xres + x;
                cm[idx] = f3 * cm[idx - 2] + f2 * cm[idx - 1] + f1 * cm[idx];
            }
        }
        for (y = 0; y < yres - 2; ++y) {
            for (x = 0; x < xres; ++x) {
                idx = y * xres + x;
                cm[idx] = f1 * cm[idx] + f2 * cm[(y + 1) * xres + x] + f3 * cm[(y + 2) * xres + x];
            }
        }
        for (y = yres - 1; y >= 2; --y) {
            for (x = 0; x < xres; ++x) {
                idx = y * xres + x;
                cm[idx] = f3 * cm[(y - 2) * xres + x] + f2 * cm[(y - 1) * xres + x] + f1 * cm[idx];
            }
        }
    }

    public static float sqrEuclidianDist(float[] p, float[] q) {
        float sum = 0.0f;
        for (int i = 0; i < p.length; ++i) {
            sum += (p[i] - q[i]) * (p[i] - q[i]);
        }
        return sum;
    }

    public static float euclid(float[] p, float[] q) {
        return (float)Math.sqrt(Utils.sqrEuclidianDist(p, q));
    }

    public static float colordiff(int rgb0, int rgb1) {
        return (float)Math.sqrt(Utils.colordiffsq(rgb0, rgb1));
    }

    public static float colordiffsq(int rgb0, int rgb1) {
        int rDist = Utils.getRed(rgb0) - Utils.getRed(rgb1);
        int gDist = Utils.getGreen(rgb0) - Utils.getGreen(rgb1);
        int bDist = Utils.getBlue(rgb0) - Utils.getBlue(rgb1);
        return rDist * rDist + gDist * gDist + bDist * bDist;
    }

    public static int average(int argb0, int argb1) {
        return Utils.packPixel((Utils.getAlpha(argb0) + Utils.getAlpha(argb1)) / 2, (Utils.getRed(argb0) + Utils.getRed(argb1)) / 2, (Utils.getGreen(argb0) + Utils.getGreen(argb1)) / 2, (Utils.getBlue(argb0) + Utils.getBlue(argb1)) / 2);
    }

    public static float labcolordiffsq(int rgb0, int rgb1) {
        float[] c1 = Utils.rgbToClab(rgb0);
        float[] c2 = Utils.rgbToClab(rgb1);
        float euclid = 0.0f;
        for (int k = 0; k < c1.length; ++k) {
            euclid += (c1[k] - c2[k]) * (c1[k] - c2[k]);
        }
        return euclid;
    }

    public static float labcolordiff(int rgb0, int rgb1) {
        return (float)Math.sqrt(Utils.labcolordiffsq(rgb0, rgb1));
    }

    public static float[] rgbToClab(int rgb) {
        float[] lab = (float[])RGB_TO_LAB.get(rgb);
        if (lab != null) {
            return lab;
        }
        lab = new float[3];
        int R = Utils.getRed(rgb);
        int G = Utils.getGreen(rgb);
        int B = Utils.getBlue(rgb);
        float var_R = (float)R / 255.0f;
        float var_G = (float)G / 255.0f;
        float var_B = (float)B / 255.0f;
        var_R = (double)var_R > 0.04045 ? (float)Math.pow((var_R + 0.055f) / 1.055f, 2.4) : (var_R /= 12.92f);
        var_G = (double)var_G > 0.04045 ? (float)Math.pow((var_G + 0.055f) / 1.055f, 2.4) : (var_G /= 12.92f);
        var_B = (double)var_B > 0.04045 ? (float)Math.pow((var_B + 0.055f) / 1.055f, 2.4) : (var_B /= 12.92f);
        float X = (var_R *= 100.0f) * 0.4124f + (var_G *= 100.0f) * 0.3576f + (var_B *= 100.0f) * 0.1805f;
        float Y = var_R * 0.2126f + var_G * 0.7152f + var_B * 0.0722f;
        float Z = var_R * 0.0193f + var_G * 0.1192f + var_B * 0.9505f;
        float var_X = X / 95.047f;
        float var_Y = Y / 100.0f;
        float var_Z = Z / 108.883f;
        var_X = var_X > 0.008856f ? (float)Math.pow(var_X, 0.3333333432674408) : 7.787f * var_X + 0.13793103f;
        var_Y = var_Y > 0.008856f ? (float)Math.pow(var_Y, 0.3333333432674408) : 7.787f * var_Y + 0.13793103f;
        var_Z = var_Z > 0.008856f ? (float)Math.pow(var_Z, 0.3333333432674408) : 7.787f * var_Z + 0.13793103f;
        lab[0] = 116.0f * var_Y - 16.0f;
        lab[1] = 500.0f * (var_X - var_Y);
        lab[2] = 200.0f * (var_Y - var_Z);
        RGB_TO_LAB.put(rgb, (Object)lab);
        return lab;
    }

    public static int clabToRGB(float[] clab) {
        float L = clab[0];
        float a = clab[1];
        float b = clab[2];
        float var_Y = (L + 16.0f) / 116.0f;
        float var_X = a / 500.0f + var_Y;
        float var_Z = var_Y - b / 200.0f;
        float var_yPow3 = (float)Math.pow(var_Y, 3.0);
        float var_xPow3 = (float)Math.pow(var_X, 3.0);
        float var_zPow3 = (float)Math.pow(var_Z, 3.0);
        var_Y = var_yPow3 > 0.008856f ? var_yPow3 : (var_Y - 0.13793103f) / 7.787f;
        var_X = var_xPow3 > 0.008856f ? var_xPow3 : (var_X - 0.13793103f) / 7.787f;
        var_Z = var_zPow3 > 0.008856f ? var_zPow3 : (var_Z - 0.13793103f) / 7.787f;
        float X = 95.047f * var_X;
        float Y = 100.0f * var_Y;
        float Z = 108.883f * var_Z;
        var_X = X / 100.0f;
        var_Y = Y / 100.0f;
        var_Z = Z / 100.0f;
        float var_R = var_X * 3.2406f + var_Y * -1.5372f + var_Z * -0.4986f;
        float var_G = var_X * -0.9689f + var_Y * 1.8758f + var_Z * 0.0415f;
        float var_B = var_X * 0.0557f + var_Y * -0.204f + var_Z * 1.057f;
        var_R = var_R > 0.0031308f ? (float)((double)1.055f * Math.pow(var_R, 0.4166666567325592) - (double)0.055f) : 12.92f * var_R;
        var_G = var_G > 0.0031308f ? (float)((double)1.055f * Math.pow(var_G, 0.4166666567325592) - (double)0.055f) : 12.92f * var_G;
        var_B = var_B > 0.0031308f ? (float)((double)1.055f * Math.pow(var_B, 0.4166666567325592) - (double)0.055f) : 12.92f * var_B;
        int R = Math.round(var_R * 255.0f);
        int G = Math.round(var_G * 255.0f);
        int B = Math.round(var_B * 255.0f);
        return Utils.packPixel(255, R, G, B);
    }

    public static int setAlpha(int alpha, int rgb) {
        if (alpha > 255) {
            alpha = 0;
        } else if (alpha < 0) {
            alpha = 0;
        }
        return alpha << 24 | rgb & 0xFFFFFF;
    }

    public static int setAlpha(float alpha, int rgb) {
        return Utils.setAlpha((int)(255.0f * alpha), rgb);
    }

    public static int packPixel(int a, int r, int g, int b) {
        if (a < 0) {
            a = 0;
        } else if (a > 255) {
            a = 255;
        }
        if (r < 0) {
            r = 0;
        } else if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 255) {
            b = 255;
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBlue(int rgb) {
        return rgb & 0xFF;
    }

    public static String clabToString(float[] clab) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < clab.length; ++i) {
            buff.append(clab[i]).append(i == clab.length - 1 ? "" : ", ");
        }
        return buff.toString();
    }
}

