/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.random_forest;

import sc.fiji.labkit.pixel_classification.random_forest.ReflectionUtils;
import weka.core.Instance;

public class TransparentRandomTree {
    private final int attribute;
    private final double threshold;
    private final TransparentRandomTree smallerChild;
    private final TransparentRandomTree biggerChild;
    private final double[] classProbabilities;

    private TransparentRandomTree(int attribute, double threshold, TransparentRandomTree smallerChild, TransparentRandomTree biggerChild, double[] classProbabilities) {
        this.attribute = attribute;
        this.threshold = threshold;
        this.smallerChild = smallerChild;
        this.biggerChild = biggerChild;
        this.classProbabilities = classProbabilities;
    }

    public static TransparentRandomTree leaf(double[] classProbabilities) {
        return new TransparentRandomTree(-1, Double.NaN, null, null, classProbabilities);
    }

    public static TransparentRandomTree node(int attribute, double threshold, TransparentRandomTree smallerChild, TransparentRandomTree biggerChild) {
        return new TransparentRandomTree(attribute, threshold, smallerChild, biggerChild, null);
    }

    public static TransparentRandomTree forFastRandomTree(Object fastRandomTree) {
        int attribute = ReflectionUtils.getPrivateField(fastRandomTree, "m_Attribute", Integer.class);
        if (attribute < 0) {
            double[] probs = ReflectionUtils.getPrivateField(fastRandomTree, "m_ClassProbs", double[].class);
            return TransparentRandomTree.leaf(probs);
        }
        double threshold = ReflectionUtils.getPrivateField(fastRandomTree, "m_SplitPoint", Double.class);
        Object[] successors = ReflectionUtils.getPrivateField(fastRandomTree, "m_Successors", Object[].class);
        return TransparentRandomTree.node(attribute, threshold, TransparentRandomTree.forFastRandomTree(successors[0]), TransparentRandomTree.forFastRandomTree(successors[1]));
    }

    public int attributeIndex() {
        return this.attribute;
    }

    public double threshold() {
        return this.threshold;
    }

    public TransparentRandomTree smallerChild() {
        return this.smallerChild;
    }

    public TransparentRandomTree biggerChild() {
        return this.biggerChild;
    }

    public double[] classProbabilities() {
        return this.classProbabilities;
    }

    public double[] distributionForInstance(Instance instance) {
        if (!this.isLeaf()) {
            TransparentRandomTree child = instance.value(this.attribute) < this.threshold ? this.smallerChild : this.biggerChild;
            return child.distributionForInstance(instance);
        }
        return this.classProbabilities;
    }

    public boolean isLeaf() {
        return this.attribute == -1;
    }

    public int height() {
        return this.isLeaf() ? 0 : 1 + Math.max(this.smallerChild().height(), this.biggerChild().height());
    }

    public int numberOfNodes() {
        return 1 + (this.isLeaf() ? 0 : this.smallerChild().numberOfNodes() + this.biggerChild().numberOfNodes());
    }

    public int numberOfLeafs() {
        return this.isLeaf() ? 1 : this.smallerChild().numberOfLeafs() + this.biggerChild().numberOfLeafs();
    }

    public int numberOfClasses() {
        if (this.isLeaf()) {
            return this.classProbabilities.length;
        }
        return this.smallerChild.numberOfClasses();
    }
}

