/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.action;

import java.util.Collection;
import java.util.Collections;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.GroupAction;

public class Remove
implements GroupAction {
    private String updateSite;

    public Remove(String updateSite) {
        this.updateSite = updateSite;
    }

    @Override
    public boolean isValid(FilesCollection files, FileObject file) {
        Collection<String> sites;
        boolean unshadowing;
        FileObject.Status status = file.getStatus();
        boolean canRemove = status.isValid(FileObject.Action.REMOVE);
        boolean bl = unshadowing = this.updateSite.equals(file.updateSite) && file.overridesOtherUpdateSite();
        if (!canRemove) {
            if (!unshadowing) {
                return false;
            }
            if (status != FileObject.Status.INSTALLED && status != FileObject.Status.MODIFIED && status != FileObject.Status.UPDATEABLE) {
                return false;
            }
        }
        return (sites = files.getSiteNamesToUpload()).size() == 0 || sites.contains(this.updateSite);
    }

    @Override
    public void setAction(FilesCollection files, FileObject file) {
        file.setAction(files, FileObject.Action.REMOVE);
    }

    @Override
    public String getLabel(FilesCollection files, Iterable<FileObject> selected) {
        boolean unshadowing = false;
        for (FileObject file : selected) {
            if (!file.overridesOtherUpdateSite()) continue;
            unshadowing = true;
        }
        return "Mark obsolete" + (unshadowing ? " (unshadowing)" : "") + " (" + this.updateSite + ")";
    }

    public String toString() {
        return this.getLabel(null, Collections.emptyList());
    }
}

