/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.neighborsearch;

import java.util.ArrayList;
import java.util.List;
import net.imglib2.KDTree;
import net.imglib2.KDTreeNode;
import net.imglib2.RealLocalizable;
import net.imglib2.Sampler;
import net.imglib2.kdtree.RadiusNeighborSearchImpl;
import net.imglib2.neighborsearch.RadiusNeighborSearch;

public class RadiusNeighborSearchOnKDTree<T>
implements RadiusNeighborSearch<T> {
    private final KDTree<T> tree;
    private final RadiusNeighborSearchImpl impl;
    private final List<KDTreeNode<T>> matches;

    public RadiusNeighborSearchOnKDTree(KDTree<T> tree) {
        this.tree = tree;
        this.impl = new RadiusNeighborSearchImpl(tree.impl());
        this.matches = new ArrayList<KDTreeNode<T>>();
    }

    private RadiusNeighborSearchOnKDTree(RadiusNeighborSearchOnKDTree<T> other) {
        this.tree = other.tree;
        this.impl = other.impl.copy();
        this.matches = new ArrayList<KDTreeNode<T>>();
        for (KDTreeNode<T> match : other.matches) {
            this.matches.add(this.tree.createNode().setNodeIndex(match.nodeIndex()));
        }
    }

    @Override
    public void search(RealLocalizable reference, double radius, boolean sortResults) {
        this.impl.search(reference, radius, sortResults);
        this.fillMatches(this.impl.numNeighbors() - 1);
    }

    private void fillMatches(int last) {
        while (this.matches.size() < last + 1) {
            this.matches.add(this.tree.createNode());
        }
        for (int i = 0; i <= last; ++i) {
            this.matches.get(i).setNodeIndex(this.impl.bestIndex(i));
        }
    }

    @Override
    public int numDimensions() {
        return this.tree.numDimensions();
    }

    @Override
    public int numNeighbors() {
        return this.impl.numNeighbors();
    }

    @Override
    public Sampler<T> getSampler(int i) {
        return this.matches.get(i);
    }

    @Override
    public RealLocalizable getPosition(int i) {
        return this.matches.get(i);
    }

    @Override
    public double getSquareDistance(int i) {
        return this.impl.bestSquDistance(i);
    }

    @Override
    public RadiusNeighborSearchOnKDTree<T> copy() {
        return new RadiusNeighborSearchOnKDTree<T>(this);
    }
}

