/*
 * Decompiled with CFR 0.152.
 */
package imglib.ops.condition;

import imglib.ops.condition.Condition;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;

public class PixelOnBorder<T extends RealType<T>>
implements Condition<T> {
    private final double borderValue;
    private final int[] imageDims;
    private final int[] neighPos;
    private final LocalizableByDimCursor<T> neighCursor;

    public PixelOnBorder(Image<T> image, double borderValue) {
        this.borderValue = borderValue;
        this.imageDims = image.getDimensions();
        this.neighPos = image.createPositionArray();
        this.neighCursor = image.createLocalizableByDimCursor();
    }

    @Override
    public boolean isSatisfied(LocalizableCursor<T> cursor, int[] position) {
        double currPixValue = ((RealType)cursor.getType()).getRealDouble();
        if (currPixValue != this.borderValue) {
            return false;
        }
        if (position[0] > 0) {
            this.neighPos[0] = position[0] - 1;
            this.neighPos[1] = position[1];
            this.neighCursor.setPosition(this.neighPos);
            if (((RealType)this.neighCursor.getType()).getRealDouble() != this.borderValue) {
                return true;
            }
        }
        if (position[0] < this.imageDims[0] - 1) {
            this.neighPos[0] = position[0] + 1;
            this.neighPos[1] = position[1];
            this.neighCursor.setPosition(this.neighPos);
            if (((RealType)this.neighCursor.getType()).getRealDouble() != this.borderValue) {
                return true;
            }
        }
        if (position[1] > 0) {
            this.neighPos[0] = position[0];
            this.neighPos[1] = position[1] - 1;
            this.neighCursor.setPosition(this.neighPos);
            if (((RealType)this.neighCursor.getType()).getRealDouble() != this.borderValue) {
                return true;
            }
        }
        if (position[1] < this.imageDims[1] - 1) {
            this.neighPos[0] = position[0];
            this.neighPos[1] = position[1] + 1;
            this.neighCursor.setPosition(this.neighPos);
            if (((RealType)this.neighCursor.getType()).getRealDouble() != this.borderValue) {
                return true;
            }
        }
        return false;
    }
}

