/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.search;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.imagej.ops.OpInfo;
import net.imagej.ops.OpListing;
import net.imagej.ops.OpService;
import net.imagej.ops.search.OpSearchResult;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.search.SearchResult;
import org.scijava.search.Searcher;
import org.scijava.util.Types;

@Plugin(type=Searcher.class, priority=9999.0)
public class OpSearcher
implements Searcher {
    private Function<Type, Type> paramReducer = type -> {
        Class raw = Types.raw((Type)type);
        Optional<Type> simpleName = SIG_SIMPLIFICATIONS.entrySet().stream().filter(e -> Types.isAssignable((Type)raw, (Type)((Type)e.getKey()))).map(Map.Entry::getValue).findFirst();
        return simpleName.orElse((Type)type);
    };
    @Parameter
    private OpService opService;
    private final Map<String, Set<OpInfo>> opsOfName = new HashMap<String, Set<OpInfo>>();
    private static final Map<Type, Type> SIG_SIMPLIFICATIONS = new HashMap<Type, Type>(){
        {
            this.put(RandomAccessible.class, Img.class);
            this.put(RealRandomAccessible.class, Img.class);
            this.put(IterableInterval.class, Img.class);
            this.put(Number.class, Number.class);
            this.put(RealType.class, Number.class);
            this.put(Byte.TYPE, Number.class);
            this.put(Short.TYPE, Number.class);
            this.put(Integer.TYPE, Number.class);
            this.put(Long.TYPE, Number.class);
            this.put(Float.TYPE, Number.class);
            this.put(Double.TYPE, Number.class);
        }
    };

    public String title() {
        return "Ops";
    }

    public List<SearchResult> search(String text, boolean fuzzy) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        this.updateNameSets();
        String filterText = this.filterString(text);
        return this.opsOfName.keySet().stream().filter(name -> this.namePriority((String)name, filterText) > 0).flatMap(name -> this.opsOfName.get(name).stream()).map(OpInfo::listing).map(sig -> sig.reduce(this.paramReducer)).distinct().sorted((a, b) -> this.sortByName(a.getName(), b.getName(), filterText)).map(sig -> new OpSearchResult(this.opService.context(), (OpListing)sig)).collect(Collectors.toList());
    }

    public void setParameterReducer(Function<Type, Type> func) {
        this.paramReducer = func;
    }

    private int sortByName(String name1, String name2, String filterText) {
        String filterName1 = this.filterString(name1);
        String filterName2 = this.filterString(name2);
        int priorityDiff = this.namePriority(filterName2, filterText) - this.namePriority(filterName1, filterText);
        if (priorityDiff != 0) {
            return priorityDiff;
        }
        return name1.length() - name2.length();
    }

    private void updateNameSets() {
        for (OpInfo info : this.opService.infos()) {
            String name = this.filterString(info.getName());
            this.opsOfName.computeIfAbsent(name, str -> new HashSet());
            this.opsOfName.get(name).add(info);
        }
    }

    private String filterString(String text) {
        if (text == null) {
            text = "";
        }
        return text.toLowerCase();
    }

    private int namePriority(String opName, String searchText) {
        if (opName.equals(searchText)) {
            return 3;
        }
        if (this.startsWith(opName, searchText)) {
            return 2;
        }
        if (this.hasSubstring(opName, searchText)) {
            return 1;
        }
        return 0;
    }

    private boolean startsWith(String name, String desiredLower) {
        return name != null && name.toLowerCase().startsWith(desiredLower.toLowerCase());
    }

    private boolean hasSubstring(String name, String desiredLower) {
        return name != null && name.contains(desiredLower);
    }
}

