/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jdatepicker.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.sourceforge.jdatepicker.DateModel;
import net.sourceforge.jdatepicker.JDatePanel;
import net.sourceforge.jdatepicker.graphics.JNextIcon;
import net.sourceforge.jdatepicker.graphics.JPreviousIcon;
import net.sourceforge.jdatepicker.impl.UtilCalendarModel;
import net.sourceforge.jdatepicker.util.JDatePickerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDatePanelImpl
extends JPanel
implements JDatePanel {
    private static final long serialVersionUID = -2299249311312882915L;
    private HashSet<ActionListener> actionListeners = new HashSet();
    private Properties i18nStrings = new Properties(this.getDefaultStrings());
    private boolean showYearButtons = false;
    private boolean doubleClickAction = false;
    private InternalCalendarModel internalModel;
    private InternalView internalView;
    private InternalController internalController;

    public JDatePanelImpl(DateModel<?> model) {
        this.internalModel = new InternalCalendarModel(model != null ? model : this.createDefaultDateModel());
        this.internalController = new InternalController();
        this.internalView = new InternalView();
        this.setLayout(new GridLayout(1, 1));
        this.add(this.internalView);
    }

    protected DateModel<?> createDefaultDateModel() {
        return new UtilCalendarModel();
    }

    private Properties getDefaultStrings() {
        Properties defaults = new Properties();
        defaults.put("messages.today", "Today");
        defaults.put("messages.nextMonth", "Next month");
        defaults.put("messages.previousMonth", "Previous month");
        defaults.put("messages.nextYear", "Next year");
        defaults.put("messages.previousYear", "Previous year");
        defaults.put("messages.clear", "Clear");
        return defaults;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    private void fireActionPerformed() {
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(new ActionEvent(this, 1001, "Date selected"));
        }
    }

    @Override
    public void setI18nStrings(Properties i18nStrings) {
        this.i18nStrings = i18nStrings;
    }

    @Override
    public Properties getI18nStrings() {
        return this.i18nStrings;
    }

    @Override
    public void setShowYearButtons(boolean showYearButtons) {
        this.showYearButtons = showYearButtons;
        this.internalView.updateShowYearButtons();
    }

    @Override
    public boolean isShowYearButtons() {
        return this.showYearButtons;
    }

    @Override
    public void setDoubleClickAction(boolean doubleClickAction) {
        this.doubleClickAction = doubleClickAction;
    }

    @Override
    public boolean isDoubleClickAction() {
        return this.doubleClickAction;
    }

    @Override
    public DateModel<?> getModel() {
        return this.internalModel.getModel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InternalCalendarModel
    implements TableModel,
    SpinnerModel,
    ChangeListener {
        private DateModel<?> model;
        private HashSet<ChangeListener> spinnerChangeListeners = new HashSet();
        private HashSet<TableModelListener> tableModelListeners = new HashSet();

        public InternalCalendarModel(DateModel<?> model) {
            this.model = model;
            model.addChangeListener(this);
        }

        public DateModel<?> getModel() {
            return this.model;
        }

        @Override
        public void addChangeListener(ChangeListener arg0) {
            this.spinnerChangeListeners.add(arg0);
        }

        @Override
        public void removeChangeListener(ChangeListener arg0) {
            this.spinnerChangeListeners.remove(arg0);
        }

        @Override
        public Object getNextValue() {
            return Integer.toString(this.model.getYear() + 1);
        }

        @Override
        public Object getPreviousValue() {
            return Integer.toString(this.model.getYear() - 1);
        }

        @Override
        public void setValue(Object text) {
            this.model.setYear(new Integer((String)text));
        }

        @Override
        public Object getValue() {
            return Integer.toString(this.model.getYear());
        }

        @Override
        public void addTableModelListener(TableModelListener arg0) {
            this.tableModelListeners.add(arg0);
        }

        @Override
        public void removeTableModelListener(TableModelListener arg0) {
            this.tableModelListeners.remove(arg0);
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int arg0) {
            DateFormatSymbols df = new DateFormatSymbols();
            String[] shortDays = df.getShortWeekdays();
            return shortDays[arg0 + 1];
        }

        public Class getColumnClass(int arg0) {
            return Integer.class;
        }

        @Override
        public int getRowCount() {
            return 6;
        }

        @Override
        public Object getValueAt(int arg0, int arg1) {
            Calendar firstDayOfMonth = Calendar.getInstance();
            firstDayOfMonth.set(this.model.getYear(), this.model.getMonth(), 1);
            int DOW = firstDayOfMonth.get(7);
            int value = arg1 - DOW + arg0 * 7 + 2;
            return new Integer(value);
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }

        @Override
        public void setValueAt(Object arg0, int arg1, int arg2) {
        }

        private void fireValueChanged() {
            for (ChangeListener cl : this.spinnerChangeListeners) {
                cl.stateChanged(new ChangeEvent(this));
            }
            JDatePanelImpl.this.internalView.updateMonthLabel();
            for (TableModelListener tl : this.tableModelListeners) {
                tl.tableChanged(new TableModelEvent(this));
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireValueChanged();
        }
    }

    private class InternalController
    implements ActionListener,
    MouseListener {
        private InternalController() {
        }

        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getSource() == JDatePanelImpl.this.internalView.getNextMonthButton()) {
                JDatePanelImpl.this.internalModel.getModel().addMonth(1);
            } else if (arg0.getSource() == JDatePanelImpl.this.internalView.getPreviousMonthButton()) {
                JDatePanelImpl.this.internalModel.getModel().addMonth(-1);
            } else if (arg0.getSource() == JDatePanelImpl.this.internalView.getNextYearButton()) {
                JDatePanelImpl.this.internalModel.getModel().addYear(1);
            } else if (arg0.getSource() == JDatePanelImpl.this.internalView.getPreviousYearButton()) {
                JDatePanelImpl.this.internalModel.getModel().addYear(-1);
            } else {
                for (int month = 0; month < JDatePanelImpl.this.internalView.getMonthPopupMenuItems().length; ++month) {
                    if (arg0.getSource() != JDatePanelImpl.this.internalView.getMonthPopupMenuItems()[month]) continue;
                    JDatePanelImpl.this.internalModel.getModel().setMonth(month);
                }
            }
        }

        public void mousePressed(MouseEvent arg0) {
            if (arg0.getSource() == JDatePanelImpl.this.internalView.getMonthLabel()) {
                JDatePanelImpl.this.internalView.getMonthPopupMenu().setLightWeightPopupEnabled(false);
                JDatePanelImpl.this.internalView.getMonthPopupMenu().show((Component)arg0.getSource(), arg0.getX(), arg0.getY());
            } else if (arg0.getSource() == JDatePanelImpl.this.internalView.getTodayLabel()) {
                Calendar today = Calendar.getInstance();
                JDatePanelImpl.this.internalModel.getModel().setDate(today.get(1), today.get(2), today.get(5));
            } else if (arg0.getSource() == JDatePanelImpl.this.internalView.getDayTable()) {
                int row = JDatePanelImpl.this.internalView.getDayTable().getSelectedRow();
                int col = JDatePanelImpl.this.internalView.getDayTable().getSelectedColumn();
                if (row >= 0 && row <= 5) {
                    Integer date = (Integer)JDatePanelImpl.this.internalModel.getValueAt(row, col);
                    JDatePanelImpl.this.internalModel.getModel().setDay(date);
                    JDatePanelImpl.this.internalModel.getModel().setSelected(true);
                    if (JDatePanelImpl.this.doubleClickAction && arg0.getClickCount() == 2) {
                        JDatePanelImpl.this.fireActionPerformed();
                    }
                    if (!JDatePanelImpl.this.doubleClickAction) {
                        JDatePanelImpl.this.fireActionPerformed();
                    }
                }
            } else if (arg0.getSource() == JDatePanelImpl.this.internalView.getNoneLabel()) {
                JDatePanelImpl.this.internalModel.getModel().setSelected(false);
                if (JDatePanelImpl.this.doubleClickAction && arg0.getClickCount() == 2) {
                    JDatePanelImpl.this.fireActionPerformed();
                }
                if (!JDatePanelImpl.this.doubleClickAction) {
                    JDatePanelImpl.this.fireActionPerformed();
                }
            }
        }

        public void mouseClicked(MouseEvent arg0) {
        }

        public void mouseEntered(MouseEvent arg0) {
        }

        public void mouseExited(MouseEvent arg0) {
        }

        public void mouseReleased(MouseEvent arg0) {
        }
    }

    private class InternalTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -2341614459632756921L;

        private InternalTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean isSelected, boolean hasFocus, int row, int col) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(arg0, arg1, isSelected, hasFocus, row, col);
            label.setHorizontalAlignment(0);
            if (row == -1) {
                label.setForeground(new Color(10, 36, 106));
                label.setBackground(Color.LIGHT_GRAY);
                label.setHorizontalAlignment(0);
                return label;
            }
            Calendar todayCal = Calendar.getInstance();
            Calendar selectedCal = Calendar.getInstance();
            selectedCal.set(JDatePanelImpl.this.internalModel.getModel().getYear(), JDatePanelImpl.this.internalModel.getModel().getMonth(), JDatePanelImpl.this.internalModel.getModel().getDay());
            int cellDayValue = (Integer)arg1;
            int lastDayOfMonth = selectedCal.getActualMaximum(5);
            if (cellDayValue < 1 || cellDayValue > lastDayOfMonth) {
                label.setForeground(Color.LIGHT_GRAY);
                label.setBackground(Color.WHITE);
                if (cellDayValue > lastDayOfMonth) {
                    label.setText(Integer.toString(cellDayValue - lastDayOfMonth));
                } else {
                    GregorianCalendar lastMonth = new GregorianCalendar();
                    lastMonth.set(selectedCal.get(1), selectedCal.get(2) - 1, 1);
                    int lastDayLastMonth = ((Calendar)lastMonth).getActualMaximum(5);
                    label.setText(Integer.toString(lastDayLastMonth + cellDayValue));
                }
            } else {
                label.setForeground(Color.BLACK);
                label.setBackground(Color.WHITE);
                if (todayCal.get(5) == cellDayValue && todayCal.get(2) == JDatePanelImpl.this.internalModel.getModel().getMonth() && todayCal.get(1) == JDatePanelImpl.this.internalModel.getModel().getYear()) {
                    label.setForeground(Color.RED);
                    if (JDatePanelImpl.this.internalModel.getModel().isSelected() && selectedCal.get(5) == cellDayValue) {
                        label.setBackground(new Color(10, 36, 106));
                    }
                } else if (JDatePanelImpl.this.internalModel.getModel().isSelected() && selectedCal.get(5) == cellDayValue) {
                    label.setForeground(Color.WHITE);
                    label.setBackground(new Color(10, 36, 106));
                }
            }
            return label;
        }
    }

    private class InternalView
    extends JPanel {
        private static final long serialVersionUID = -6844493839307157682L;
        private JPanel centerPanel;
        private JPanel northCenterPanel;
        private JPanel northPanel;
        private JPanel southPanel;
        private JPanel previousButtonPanel;
        private JPanel nextButtonPanel;
        private JTable dayTable;
        private JTableHeader dayTableHeader;
        private InternalTableCellRenderer dayTableCellRenderer;
        private JLabel monthLabel;
        private JLabel todayLabel;
        private JLabel noneLabel;
        private JPopupMenu monthPopupMenu;
        private JMenuItem[] monthPopupMenuItems;
        private JButton nextMonthButton;
        private JButton previousMonthButton;
        private JButton previousYearButton;
        private JButton nextYearButton;
        private JSpinner yearSpinner;

        private void updateShowYearButtons() {
            if (JDatePanelImpl.this.showYearButtons) {
                this.getNextButtonPanel().add(this.getNextYearButton());
                this.getPreviousButtonPanel().removeAll();
                this.getPreviousButtonPanel().add(this.getPreviousYearButton());
                this.getPreviousButtonPanel().add(this.getPreviousMonthButton());
            } else {
                this.getNextButtonPanel().remove(this.getNextYearButton());
                this.getPreviousButtonPanel().remove(this.getPreviousYearButton());
            }
        }

        private void updateMonthLabel() {
            DateFormatSymbols df = new DateFormatSymbols();
            this.monthLabel.setText(df.getMonths()[JDatePanelImpl.this.internalModel.getModel().getMonth()]);
        }

        public InternalView() {
            this.initialise();
        }

        private void initialise() {
            this.setLayout(new BorderLayout());
            this.setSize(200, 180);
            this.setPreferredSize(new Dimension(200, 180));
            this.setBackground(SystemColor.activeCaptionText);
            this.setOpaque(false);
            this.add((Component)this.getNorthPanel(), "North");
            this.add((Component)this.getSouthPanel(), "South");
            this.add((Component)this.getCenterPanel(), "Center");
        }

        private JPanel getNorthPanel() {
            if (this.northPanel == null) {
                this.northPanel = new JPanel();
                this.northPanel.setLayout(new BorderLayout());
                this.northPanel.setName("");
                this.northPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                this.northPanel.setBackground(SystemColor.activeCaption);
                this.northPanel.add((Component)this.getPreviousButtonPanel(), "West");
                this.northPanel.add((Component)this.getNextButtonPanel(), "East");
                this.northPanel.add((Component)this.getNorthCenterPanel(), "Center");
            }
            return this.northPanel;
        }

        private JPanel getNorthCenterPanel() {
            if (this.northCenterPanel == null) {
                this.northCenterPanel = new JPanel();
                this.northCenterPanel.setLayout(new BorderLayout());
                this.northCenterPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                this.northCenterPanel.setOpaque(false);
                this.northCenterPanel.add((Component)this.getMonthLabel(), "Center");
                this.northCenterPanel.add((Component)this.getYearSpinner(), "East");
            }
            return this.northCenterPanel;
        }

        private JLabel getMonthLabel() {
            if (this.monthLabel == null) {
                this.monthLabel = new JLabel();
                this.monthLabel.setForeground(SystemColor.activeCaptionText);
                this.monthLabel.setHorizontalAlignment(0);
                this.monthLabel.addMouseListener(JDatePanelImpl.this.internalController);
                this.updateMonthLabel();
            }
            return this.monthLabel;
        }

        private JSpinner getYearSpinner() {
            if (this.yearSpinner == null) {
                this.yearSpinner = new JSpinner();
                this.yearSpinner.setModel(JDatePanelImpl.this.internalModel);
            }
            return this.yearSpinner;
        }

        private JPanel getSouthPanel() {
            if (this.southPanel == null) {
                this.southPanel = new JPanel();
                this.southPanel.setLayout(new BorderLayout());
                this.southPanel.setBackground(Color.WHITE);
                this.southPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                this.southPanel.add((Component)this.getTodayLabel(), "West");
                this.southPanel.add((Component)this.getNoneLabel(), "East");
            }
            return this.southPanel;
        }

        private JLabel getNoneLabel() {
            if (this.noneLabel == null) {
                this.noneLabel = new JLabel();
                this.noneLabel.setHorizontalAlignment(0);
                this.noneLabel.addMouseListener(JDatePanelImpl.this.internalController);
                this.noneLabel.setText(JDatePanelImpl.this.i18nStrings.getProperty("messages.clear"));
            }
            return this.noneLabel;
        }

        private JLabel getTodayLabel() {
            if (this.todayLabel == null) {
                this.todayLabel = new JLabel();
                this.todayLabel.setHorizontalAlignment(0);
                this.todayLabel.addMouseListener(JDatePanelImpl.this.internalController);
                DateFormat df1 = JDatePickerUtil.getMediumDateFormat();
                this.todayLabel.setText(JDatePanelImpl.this.i18nStrings.getProperty("messages.today") + ": " + df1.format(new Date()));
            }
            return this.todayLabel;
        }

        private JPanel getCenterPanel() {
            if (this.centerPanel == null) {
                this.centerPanel = new JPanel();
                this.centerPanel.setLayout(new BorderLayout());
                this.centerPanel.setOpaque(false);
                this.centerPanel.add((Component)this.getDayTableHeader(), "North");
                this.centerPanel.add((Component)this.getDayTable(), "Center");
            }
            return this.centerPanel;
        }

        private JTable getDayTable() {
            if (this.dayTable == null) {
                this.dayTable = new JTable();
                this.dayTable.setAutoResizeMode(4);
                this.dayTable.setRowHeight(18);
                this.dayTable.setPreferredSize(new Dimension(100, 80));
                this.dayTable.setModel(JDatePanelImpl.this.internalModel);
                this.dayTable.setShowGrid(true);
                this.dayTable.setGridColor(Color.WHITE);
                this.dayTable.setSelectionMode(0);
                this.dayTable.setCellSelectionEnabled(true);
                this.dayTable.setRowSelectionAllowed(true);
                this.dayTable.setFocusable(false);
                this.dayTable.addMouseListener(JDatePanelImpl.this.internalController);
                TableColumn column = null;
                for (int i = 0; i < 7; ++i) {
                    column = this.dayTable.getColumnModel().getColumn(i);
                    column.setPreferredWidth(15);
                    column.setCellRenderer(this.getDayTableCellRenderer());
                }
            }
            return this.dayTable;
        }

        private InternalTableCellRenderer getDayTableCellRenderer() {
            if (this.dayTableCellRenderer == null) {
                this.dayTableCellRenderer = new InternalTableCellRenderer();
            }
            return this.dayTableCellRenderer;
        }

        private JTableHeader getDayTableHeader() {
            if (this.dayTableHeader == null) {
                this.dayTableHeader = this.getDayTable().getTableHeader();
                this.dayTableHeader.setResizingAllowed(false);
                this.dayTableHeader.setReorderingAllowed(false);
                this.dayTableHeader.setDefaultRenderer(this.getDayTableCellRenderer());
            }
            return this.dayTableHeader;
        }

        private JPanel getPreviousButtonPanel() {
            if (this.previousButtonPanel == null) {
                this.previousButtonPanel = new JPanel();
                GridLayout layout = new GridLayout(1, 2);
                layout.setHgap(3);
                this.previousButtonPanel.setLayout(layout);
                this.previousButtonPanel.setName("");
                this.previousButtonPanel.setBackground(SystemColor.activeCaption);
                if (JDatePanelImpl.this.isShowYearButtons()) {
                    this.previousButtonPanel.add(this.getPreviousYearButton());
                }
                this.previousButtonPanel.add(this.getPreviousMonthButton());
            }
            return this.previousButtonPanel;
        }

        private JPanel getNextButtonPanel() {
            if (this.nextButtonPanel == null) {
                this.nextButtonPanel = new JPanel();
                GridLayout layout = new GridLayout(1, 2);
                layout.setHgap(3);
                this.nextButtonPanel.setLayout(layout);
                this.nextButtonPanel.setName("");
                this.nextButtonPanel.setBackground(SystemColor.activeCaption);
                this.nextButtonPanel.add(this.getNextMonthButton());
                if (JDatePanelImpl.this.isShowYearButtons()) {
                    this.nextButtonPanel.add(this.getNextYearButton());
                }
            }
            return this.nextButtonPanel;
        }

        private JButton getNextMonthButton() {
            if (this.nextMonthButton == null) {
                this.nextMonthButton = new JButton(new JNextIcon(4, 7));
                this.nextMonthButton.setText("");
                this.nextMonthButton.setPreferredSize(new Dimension(20, 15));
                this.nextMonthButton.setBorder(BorderFactory.createBevelBorder(0));
                this.nextMonthButton.setFocusable(false);
                this.nextMonthButton.addActionListener(JDatePanelImpl.this.internalController);
                this.nextMonthButton.setToolTipText(JDatePanelImpl.this.i18nStrings.getProperty("messages.nextMonth"));
            }
            return this.nextMonthButton;
        }

        private JButton getNextYearButton() {
            if (this.nextYearButton == null) {
                this.nextYearButton = new JButton(new JNextIcon(8, 7, true));
                this.nextYearButton.setText("");
                this.nextYearButton.setPreferredSize(new Dimension(20, 15));
                this.nextYearButton.setBorder(BorderFactory.createBevelBorder(0));
                this.nextYearButton.setFocusable(false);
                this.nextYearButton.addActionListener(JDatePanelImpl.this.internalController);
                this.nextYearButton.setToolTipText(JDatePanelImpl.this.i18nStrings.getProperty("messages.nextYear"));
            }
            return this.nextYearButton;
        }

        private JButton getPreviousMonthButton() {
            if (this.previousMonthButton == null) {
                this.previousMonthButton = new JButton(new JPreviousIcon(4, 7));
                this.previousMonthButton.setText("");
                this.previousMonthButton.setPreferredSize(new Dimension(20, 15));
                this.previousMonthButton.setBorder(BorderFactory.createBevelBorder(0));
                this.previousMonthButton.setFocusable(false);
                this.previousMonthButton.addActionListener(JDatePanelImpl.this.internalController);
                this.previousMonthButton.setToolTipText(JDatePanelImpl.this.i18nStrings.getProperty("messages.previousMonth"));
            }
            return this.previousMonthButton;
        }

        private JButton getPreviousYearButton() {
            if (this.previousYearButton == null) {
                this.previousYearButton = new JButton(new JPreviousIcon(8, 7, true));
                this.previousYearButton.setText("");
                this.previousYearButton.setPreferredSize(new Dimension(20, 15));
                this.previousYearButton.setBorder(BorderFactory.createBevelBorder(0));
                this.previousYearButton.setFocusable(false);
                this.previousYearButton.addActionListener(JDatePanelImpl.this.internalController);
                this.previousYearButton.setToolTipText(JDatePanelImpl.this.i18nStrings.getProperty("messages.previousYear"));
            }
            return this.previousYearButton;
        }

        private JPopupMenu getMonthPopupMenu() {
            if (this.monthPopupMenu == null) {
                this.monthPopupMenu = new JPopupMenu();
                JMenuItem[] menuItems = this.getMonthPopupMenuItems();
                for (int i = 0; i < menuItems.length; ++i) {
                    this.monthPopupMenu.add(menuItems[i]);
                }
            }
            return this.monthPopupMenu;
        }

        private JMenuItem[] getMonthPopupMenuItems() {
            if (this.monthPopupMenuItems == null) {
                DateFormatSymbols df = new DateFormatSymbols();
                String[] months = df.getMonths();
                this.monthPopupMenuItems = new JMenuItem[months.length - 1];
                for (int i = 0; i < months.length - 1; ++i) {
                    JMenuItem mi = new JMenuItem(months[i]);
                    mi.addActionListener(JDatePanelImpl.this.internalController);
                    this.monthPopupMenuItems[i] = mi;
                }
            }
            return this.monthPopupMenuItems;
        }
    }
}

