/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.img.optional;

import java.nio.file.Path;
import java.util.function.BiConsumer;
import org.scijava.optional.Options;
import org.scijava.optional.Values;

public interface DiskCacheOptions<T>
extends Options<T> {
    default public T numIoThreads(int numIoThreads) {
        return (T)this.setValue("numIoThreads", numIoThreads);
    }

    default public T maxIoQueueSize(int maxIoQueueSize) {
        return (T)this.setValue("maxIoQueueSize", maxIoQueueSize);
    }

    default public T cacheDirectory(Path dir) {
        return (T)this.setValue("cacheDirectory", dir);
    }

    default public T tempDirectory(Path dir) {
        return (T)this.setValue("tempDirectory", dir);
    }

    default public T tempDirectoryPrefix(String prefix) {
        return (T)this.setValue("tempDirectoryPrefix", prefix);
    }

    default public T deleteCacheDirectoryOnExit(boolean deleteOnExit) {
        return (T)this.setValue("deleteCacheDirectoryOnExit", deleteOnExit);
    }

    default public T initializeCellsAsDirty(boolean initializeAsDirty) {
        return (T)this.setValue("initializeCellsAsDirty", initializeAsDirty);
    }

    public static interface Val
    extends Values {
        default public void forEach(BiConsumer<String, Object> action) {
            action.accept("numIoThreads", this.numIoThreads());
            action.accept("maxIoQueueSize", this.maxIoQueueSize());
            action.accept("cacheDirectory", this.cacheDirectory());
            action.accept("tempDirectory", this.tempDirectory());
            action.accept("tempDirectoryPrefix", this.tempDirectoryPrefix());
            action.accept("deleteCacheDirectoryOnExit", this.deleteCacheDirectoryOnExit());
            action.accept("initializeCellsAsDirty", this.initializeCellsAsDirty());
        }

        default public int numIoThreads() {
            return (Integer)this.getValueOrDefault("numIoThreads", 1);
        }

        default public int maxIoQueueSize() {
            return (Integer)this.getValueOrDefault("maxIoQueueSize", 10);
        }

        default public Path cacheDirectory() {
            return (Path)this.getValueOrDefault("cacheDirectory", null);
        }

        default public Path tempDirectory() {
            return (Path)this.getValueOrDefault("tempDirectory", null);
        }

        default public String tempDirectoryPrefix() {
            return (String)this.getValueOrDefault("tempDirectoryPrefix", "imglib2");
        }

        default public boolean deleteCacheDirectoryOnExit() {
            return (Boolean)this.getValueOrDefault("deleteCacheDirectoryOnExit", true);
        }

        default public boolean initializeCellsAsDirty() {
            return (Boolean)this.getValueOrDefault("initializeCellsAsDirty", false);
        }
    }
}

