/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.swing.UIManager;

public final class UIUtils {
    private static final WeakHashMap<Object, Double> uiScaleFactors = new WeakHashMap();

    public static Color mix(Color c1, Color c2, double c1Weight) {
        double c2Weight = 1.0 - c1Weight;
        return new Color((int)((double)c1.getRed() * c1Weight + (double)c2.getRed() * c2Weight), (int)((double)c1.getGreen() * c1Weight + (double)c2.getGreen() * c2Weight), (int)((double)c1.getBlue() * c1Weight + (double)c2.getBlue() * c2Weight));
    }

    public static void setPreferredWidth(Component component, int preferredWidth) {
        component.setPreferredSize(new Dimension(preferredWidth, component.getPreferredSize().height));
    }

    public static void setPreferredHeight(Component component, int preferredHeight) {
        component.setPreferredSize(new Dimension(component.getPreferredSize().width, preferredHeight));
    }

    public static void setMinimumWidth(Component component, int minimumWidth) {
        component.setMinimumSize(new Dimension(minimumWidth, component.getMinimumSize().height));
    }

    public static void setMinimumHeight(Component component, int minimumHeight) {
        component.setMinimumSize(new Dimension(component.getMinimumSize().width, minimumHeight));
    }

    public static void drawString(Graphics g, TextPosition textPosition, int line, String text) {
        int posX;
        Class<UIUtils> key = UIUtils.class;
        double uiScale = UIUtils.getUIScaleFactor(key);
        FontMetrics fontMetrics = g.getFontMetrics();
        Rectangle clipBounds = g.getClipBounds();
        int spacing = fontMetrics.getHeight();
        int textWidth = fontMetrics.stringWidth(text);
        switch (textPosition) {
            case TOP_CENTER: {
                posX = (int)((clipBounds.getWidth() - (double)textWidth) / 2.0);
                break;
            }
            default: {
                posX = (int)(clipBounds.getWidth() - (double)textWidth - uiScale * 17.0);
            }
        }
        int posY = (line + 1) * spacing - 1;
        g.drawString(text, posX, posY);
    }

    public static double getUIScaleFactor(Object key) {
        return uiScaleFactors.computeIfAbsent(key, k -> UIScale.getUserScaleFactor());
    }

    private static int getFontSize(Font referenceFont, String category) {
        double uiScale = UIUtils.getUIScaleFactor(Runtime.getRuntime());
        int referenceFontSize = referenceFont.getSize();
        switch (category) {
            case "mini": {
                return (int)Math.round((double)referenceFontSize - 3.0 * uiScale);
            }
            case "small": {
                return (int)Math.round((double)referenceFontSize - 2.0 * uiScale);
            }
            case "medium": {
                return (int)Math.round((double)referenceFontSize - uiScale);
            }
            case "large": {
                return (int)Math.round((double)referenceFontSize + 2.0 * uiScale);
            }
        }
        return referenceFontSize;
    }

    public static Font getFont(String key) {
        Font font = UIManager.getFont(key);
        if (font == null) {
            Font defaultFont = UIManager.getFont("Label.font");
            int fontSize = key.contains("mini") ? UIUtils.getFontSize(defaultFont, "mini") : (key.contains("small") ? UIUtils.getFontSize(defaultFont, "small") : (key.contains("medium") ? UIUtils.getFontSize(defaultFont, "medium") : (key.contains("large") ? UIUtils.getFontSize(defaultFont, "large") : defaultFont.getSize())));
            String fontName = key.contains("monospace") || key.contains("Monospace") ? "Monospaced" : defaultFont.getName();
            int fontStyle = key.contains("bold") ? 1 : defaultFont.getStyle();
            font = new Font(fontName, fontStyle, fontSize);
        }
        return font;
    }

    public static void resetPropertyCaches() {
        uiScaleFactors.clear();
    }

    public static boolean isDark(String key) {
        Color bg = UIManager.getColor(key);
        if (bg == null) {
            return false;
        }
        return (double)(bg.getRed() + bg.getGreen() + bg.getBlue()) / 3.0 < 127.0;
    }

    public static boolean getUIBoolean(String key, boolean defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public static synchronized void installFlatLafInfos() {
        Set lafNames = Arrays.stream(UIManager.getInstalledLookAndFeels()).map(UIManager.LookAndFeelInfo::getName).collect(Collectors.toSet());
        if (!lafNames.contains("FlatLaf Light")) {
            FlatLightLaf.installLafInfo();
        }
        if (!lafNames.contains("FlatLaf Dark")) {
            FlatDarkLaf.installLafInfo();
        }
        if (!lafNames.contains("FlatLaf Darcula")) {
            FlatDarculaLaf.installLafInfo();
        }
        if (!lafNames.contains("FlatLaf IntelliJ")) {
            FlatIntelliJLaf.installLafInfo();
        }
    }

    public static enum TextPosition {
        TOP_CENTER,
        TOP_RIGHT;

    }
}

