/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;

public class DeInterleave_
implements PlugIn {
    int nChannels = (int)Prefs.get((String)"Deint_ch.int", (double)2.0);
    boolean keep = Prefs.get((String)"Deint_keep.boolean", (boolean)true);

    public void run(String arg) {
        int endSlice;
        int beginSlice;
        ImagePlus inputImage = WindowManager.getCurrentImage();
        if (inputImage == null) {
            IJ.noImage();
            return;
        }
        ImageStack inputStack = inputImage.getStack();
        if (inputStack.getSize() == 1) {
            IJ.error((String)"Please select a stack before choosing Deinterleave");
            return;
        }
        if (!this.showDialog()) {
            return;
        }
        String inputFilename = inputImage.getTitle();
        Calibration oc = inputImage.getCalibration().copy();
        ImageStack shuffledStack = this.makeShuffled(inputStack);
        ImagePlus shuffledImage = new ImagePlus(inputFilename, shuffledStack);
        int stackSize = shuffledStack.getSize();
        int nFrames = stackSize / this.nChannels;
        for (int channel = 0; channel <= this.nChannels && (beginSlice = channel * nFrames) != (endSlice = Math.min(beginSlice + nFrames, stackSize)); ++channel) {
            String channelName = Integer.toString(channel + 1);
            ImagePlus channelImage = new ImagePlus(inputFilename + " #" + channelName, this.makeSubStack(shuffledStack, beginSlice, endSlice));
            channelImage.show();
            channelImage.setCalibration(oc);
            ImageWindow win = channelImage.getWindow();
            if (null == win) continue;
            win.repaint();
        }
        shuffledImage.changes = false;
        shuffledImage.close();
        if (!this.keep) {
            inputImage.changes = false;
            inputImage.close();
        }
        IJ.register(DeInterleave_.class);
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog("De-Interleaver");
        gd.addNumericField("How many channels?", (double)this.nChannels, 0);
        gd.addCheckbox("Keep source stack", this.keep);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.nChannels = (int)gd.getNextNumber();
        this.keep = gd.getNextBoolean();
        Prefs.set((String)"Deint_ch.int", (int)this.nChannels);
        Prefs.set((String)"Deint_keep.boolean", (boolean)this.keep);
        return true;
    }

    public ImageStack makeSubStack(ImageStack stack, int beginSlice, int endSlice) {
        ImageStack newStack = new ImageStack(stack.getWidth(), stack.getHeight(), stack.getColorModel());
        for (int i = beginSlice; i < endSlice; ++i) {
            newStack.addSlice(stack.getSliceLabel(i + 1), stack.getProcessor(i + 1));
        }
        return newStack;
    }

    public ImageStack makeShuffled(ImageStack stack) {
        ImageStack newStack = new ImageStack(stack.getWidth(), stack.getHeight(), stack.getColorModel());
        for (int channel = 0; channel < this.nChannels; ++channel) {
            for (int i = channel; i < stack.getSize(); i += this.nChannels) {
                newStack.addSlice(stack.getSliceLabel(i + 1), stack.getProcessor(i + 1));
            }
        }
        return newStack;
    }
}

