/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.event.FigureSelectionEvent;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class DefaultAttributeAction
extends AbstractSelectedAction {
    private AttributeKey[] keys;
    @Nullable
    private Map<AttributeKey, Object> fixedAttributes;

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey key) {
        this(editor, key, null, null);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey key, @Nullable Map<AttributeKey, Object> fixedAttributes) {
        this(editor, new AttributeKey[]{key}, null, null, fixedAttributes);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey[] keys) {
        this(editor, keys, null, null);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey key, @Nullable Icon icon) {
        this(editor, key, null, icon);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey key, @Nullable String name) {
        this(editor, key, name, null);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey key, @Nullable String name, @Nullable Icon icon) {
        this(editor, new AttributeKey[]{key}, name, icon);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey[] keys, @Nullable String name, @Nullable Icon icon) {
        this(editor, keys, name, icon, new HashMap<AttributeKey, Object>());
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey[] keys, @Nullable String name, @Nullable Icon icon, @Nullable Map<AttributeKey, Object> fixedAttributes) {
        super(editor);
        this.keys = (AttributeKey[])keys.clone();
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(DefaultAttributeAction.this.keys[0].getKey())) {
                    DefaultAttributeAction.this.putValue("attribute_" + DefaultAttributeAction.this.keys[0].getKey(), evt.getNewValue());
                }
            }
        });
        this.fixedAttributes = fixedAttributes;
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.getView() != null && this.getView().getSelectionCount() > 0) {
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            CompositeEdit edit = new CompositeEdit(labels.getString("drawAttributeChange"));
            this.fireUndoableEditHappened(edit);
            this.changeAttribute();
            this.fireUndoableEditHappened(edit);
        }
    }

    public void changeAttribute() {
        CompositeEdit edit = new CompositeEdit("attributes");
        this.fireUndoableEditHappened(edit);
        DrawingEditor editor = this.getEditor();
        for (Figure figure : this.getView().getSelectedFigures()) {
            figure.willChange();
            for (int j = 0; j < this.keys.length; ++j) {
                figure.set(this.keys[j], editor.getDefaultAttribute(this.keys[j]));
            }
            for (Map.Entry<AttributeKey, Object> entry : this.fixedAttributes.entrySet()) {
                figure.set(entry.getKey(), entry.getValue());
            }
            figure.changed();
        }
        this.fireUndoableEditHappened(edit);
    }

    public void selectionChanged(FigureSelectionEvent evt) {
    }
}

