/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.security.AccessControlException;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class JComponentPopup
extends JPopupMenu {
    private boolean isAWTEventListenerPermitted = true;
    private Handler handler = new Handler();

    public JComponentPopup() {
        this.setLightWeightPopupEnabled(false);
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        if (this.isAWTEventListenerPermitted) {
            return;
        }
        AWTEvent evt = EventQueue.getCurrentEvent();
        if (evt != null && evt.getSource() instanceof Component) {
            Component src = (Component)evt.getSource();
            Component invoker = this.getInvoker();
            if (!SwingUtilities.isDescendingFrom(src, this) && SwingUtilities.getWindowAncestor(src) == SwingUtilities.getWindowAncestor(invoker)) {
                JLayeredPane srcLP = (JLayeredPane)SwingUtilities.getAncestorOfClass(JLayeredPane.class, src);
                Component srcLPChild = src;
                while (srcLPChild.getParent() != srcLP) {
                    srcLPChild = srcLPChild.getParent();
                }
                if (srcLP.getLayer(srcLPChild) < JLayeredPane.POPUP_LAYER) {
                    this.setVisible(false);
                }
            }
        } else {
            super.menuSelectionChanged(isIncluded);
        }
    }

    @Override
    public void setVisible(boolean newValue) {
        if (this.isVisible() != newValue) {
            if (this.isAWTEventListenerPermitted) {
                try {
                    if (newValue) {
                        Toolkit.getDefaultToolkit().addAWTEventListener(this.handler, 16L);
                    } else {
                        Toolkit.getDefaultToolkit().removeAWTEventListener(this.handler);
                    }
                }
                catch (AccessControlException e) {
                    this.isAWTEventListenerPermitted = false;
                }
            }
            super.setVisible(newValue);
        }
    }

    private class Handler
    implements AWTEventListener {
        private Handler() {
        }

        @Override
        public void eventDispatched(AWTEvent ev) {
            if (!(ev instanceof MouseEvent) || !(ev.getSource() instanceof Component)) {
                return;
            }
            MouseEvent me = (MouseEvent)ev;
            Component src = (Component)ev.getSource();
            Component invoker = JComponentPopup.this.getInvoker();
            if (ev.getID() == 501) {
                if (!SwingUtilities.isDescendingFrom(src, JComponentPopup.this) && SwingUtilities.getWindowAncestor(src) == SwingUtilities.getWindowAncestor(invoker)) {
                    JLayeredPane srcLP = (JLayeredPane)SwingUtilities.getAncestorOfClass(JLayeredPane.class, src);
                    Component srcLPChild = src;
                    while (srcLPChild.getParent() != srcLP) {
                        srcLPChild = srcLPChild.getParent();
                    }
                    if (srcLP.getLayer(srcLPChild) < JLayeredPane.POPUP_LAYER) {
                        JComponentPopup.this.setVisible(false);
                    }
                }
            } else if (ev.getID() == 500 && me.getClickCount() == 2 && SwingUtilities.isDescendingFrom(src, JComponentPopup.this)) {
                JComponentPopup.this.setVisible(false);
            }
        }
    }
}

