/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;
import org.jhotdraw.gui.plaf.palette.PaletteUtilities;

public class PaletteTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final float[] enabledStops = new float[]{0.0f, 0.35f, 0.4f, 1.0f};
    private static final Color[] enabledStopColors = new Color[]{new Color(0xF8F8F8), new Color(0xEEEEEE), new Color(0xCACACA), new Color(0xFFFFFF)};
    private boolean tabsOverlapBorder;
    private Color selectedColor;
    private boolean tabsOpaque = true;
    private boolean contentOpaque = true;

    public static ComponentUI createUI(JComponent c) {
        return new PaletteTabbedPaneUI();
    }

    @Override
    protected void installDefaults() {
        PaletteLookAndFeel laf = PaletteLookAndFeel.getInstance();
        PaletteLookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.highlight = laf.getColor("TabbedPane.light");
        this.lightHighlight = laf.getColor("TabbedPane.highlight");
        this.shadow = laf.getColor("TabbedPane.shadow");
        this.darkShadow = laf.getColor("TabbedPane.darkShadow");
        this.focus = laf.getColor("TabbedPane.focus");
        this.selectedColor = laf.getColor("TabbedPane.selected");
        this.textIconGap = laf.getInt("TabbedPane.textIconGap");
        this.tabInsets = laf.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = laf.getInsets("TabbedPane.selectedTabPadInsets");
        this.tabAreaInsets = laf.getInsets("TabbedPane.tabAreaInsets");
        this.tabsOverlapBorder = laf.getBoolean("TabbedPane.tabsOverlapBorder");
        this.contentBorderInsets = laf.getInsets("TabbedPane.contentBorderInsets");
        this.tabRunOverlay = laf.getInt("TabbedPane.tabRunOverlay");
        this.tabsOpaque = laf.getBoolean("TabbedPane.tabsOpaque");
        this.contentOpaque = laf.getBoolean("TabbedPane.contentOpaque");
        Object opaque = laf.get("TabbedPane.opaque");
        if (opaque == null) {
            opaque = Boolean.FALSE;
        }
        PaletteLookAndFeel.installProperty(this.tabPane, "opaque", opaque);
        if (this.tabInsets == null) {
            this.tabInsets = new Insets(0, 4, 1, 4);
        }
        if (this.selectedTabPadInsets == null) {
            this.selectedTabPadInsets = new Insets(2, 2, 2, 1);
        }
        if (this.tabAreaInsets == null) {
            this.tabAreaInsets = new Insets(3, 2, 0, 2);
        }
        if (this.contentBorderInsets == null) {
            this.contentBorderInsets = new Insets(2, 2, 3, 3);
        }
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean isSelected;
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean bl = isSelected = selectedIndex == tabIndex;
        if (this.tabsOpaque || this.tabPane.isOpaque()) {
            this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        }
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        String title = this.tabPane.getTitleAt(tabIndex);
        Font font = isSelected ? PaletteLookAndFeel.getInstance().getFont("TabbedPane.selectedFont") : this.tabPane.getFont();
        FontMetrics metrics = PaletteUtilities.getFontMetrics(this.tabPane, g, font);
        Icon icon = this.getIconForTab(tabIndex);
        this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        if (this.tabPane.getTabComponentAt(tabIndex) == null) {
            String clippedTitle = title;
            this.paintText(g, tabPlacement, font, metrics, tabIndex, clippedTitle, textRect, isSelected);
            this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        }
        this.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(isSelected ? this.darkShadow : this.shadow);
        switch (tabPlacement) {
            case 2: {
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.drawLine(x, y + 2, x, y + h - 3);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 2, y, x + w - 1, y);
                g.drawLine(x + 2, y + h - 2, x + w - 1, y + h - 2);
                g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
                break;
            }
            case 4: {
                g.drawLine(x, y, x + w - 3, y);
                g.drawLine(x, y + h - 2, x + w - 3, y + h - 2);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                g.drawLine(x, y + h - 1, x + w - 3, y + h - 1);
                break;
            }
            case 3: {
                g.drawLine(x, y, x, y + h - 2);
                g.drawLine(x + 1, y + h - 2, x + w - 1, y + h - 2);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 2);
                break;
            }
            default: {
                g.drawLine(x, y + 2, x, y + h - 1);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 2, y, x + w - 3, y);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 1);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
            }
        }
    }

    @Override
    protected void paintTabBackground(Graphics gr, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Graphics2D g = (Graphics2D)gr;
        g.setColor(!isSelected || this.selectedColor == null ? this.tabPane.getBackgroundAt(tabIndex) : this.selectedColor);
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + 1, y + 1, w - 1, h - 3);
                break;
            }
            case 4: {
                g.fillRect(x, y + 1, w - 2, h - 3);
                break;
            }
            case 3: {
                if (!isSelected) {
                    LinearGradientPaint lgp = new LinearGradientPaint(new Point2D.Float(x, y), new Point2D.Float(x, y + h - 1), enabledStops, enabledStopColors, MultipleGradientPaint.CycleMethod.REPEAT);
                    g.setPaint(lgp);
                }
                g.fillRect(x + 1, y, w - 3, h - 1);
                break;
            }
            default: {
                g.fillRect(x + 1, y + 1, w - 3, h - 1);
            }
        }
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                Color selectedFG;
                Color fg = this.tabPane.getForegroundAt(tabIndex);
                if (isSelected && fg instanceof UIResource && (selectedFG = PaletteLookAndFeel.getInstance().getColor("TabbedPane.selectedForeground")) != null) {
                    fg = selectedFG;
                }
                g.setColor(fg);
                PaletteUtilities.drawStringUnderlineCharAt((JComponent)this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                PaletteUtilities.drawStringUnderlineCharAt((JComponent)this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                PaletteUtilities.drawStringUnderlineCharAt((JComponent)this.tabPane, g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        boolean paintBorder;
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (this.tabsOverlapBorder) {
                    x -= tabAreaInsets.right;
                }
                w -= x - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (!this.tabsOverlapBorder) break;
                w += tabAreaInsets.left;
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (!this.tabsOverlapBorder) break;
                h += tabAreaInsets.top;
                break;
            }
            default: {
                y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (this.tabsOverlapBorder) {
                    y -= tabAreaInsets.bottom;
                }
                h -= y - insets.top;
            }
        }
        if (this.tabPane.getTabCount() > 0 && (this.contentOpaque || this.tabPane.isOpaque())) {
            Color color = PaletteLookAndFeel.getInstance().getColor("TabbedPane.contentAreaColor");
            if (color != null) {
                g.setColor(color);
            } else if (this.selectedColor == null || selectedIndex == -1) {
                g.setColor(this.tabPane.getBackground());
            } else {
                g.setColor(this.selectedColor);
            }
            g.fillRect(x, y, w, h);
        }
        boolean bl = paintBorder = this.tabPane.getClientProperty("Palette.TabbedPane.paintContentBorder") != Boolean.FALSE;
        if (tabPlacement == 1 || paintBorder) {
            this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
        if (tabPlacement == 2 || paintBorder) {
            this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
        if (tabPlacement == 3 || paintBorder) {
            this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
        if (tabPlacement == 4 || paintBorder) {
            this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.lightHighlight);
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y, x + w - 2, y);
        } else {
            g.drawLine(x, y, selRect.x - 1, y);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width, y, x + w - 2, y);
            } else {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y, x + w - 2, y);
            }
        }
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.lightHighlight);
        if (tabPlacement != 2 || selectedIndex < 0 || selRect.x + selRect.width + 1 < x || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x, y, x, y + h - 2);
        } else {
            g.drawLine(x, y, x, selRect.y - 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.drawLine(x, selRect.y + selRect.height, x, y + h - 2);
            }
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.shadow);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.y - 1 > h || selRect.x < x || selRect.x > x + w) {
            g.setColor(this.shadow);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        } else {
            g.setColor(this.shadow);
            g.drawLine(x, y + h - 1, selRect.x, y + h - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.setColor(this.shadow);
                g.drawLine(selRect.x + selRect.width - 1, y + h - 1, x + w - 1, y + h - 1);
            }
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.shadow);
        if (tabPlacement != 4 || selectedIndex < 0 || selRect.x - 1 > w || selRect.y < y || selRect.y > y + h) {
            g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 3);
            g.setColor(this.darkShadow);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        } else {
            g.drawLine(x + w - 2, y + 1, x + w - 2, selRect.y - 1);
            g.setColor(this.darkShadow);
            g.drawLine(x + w - 1, y, x + w - 1, selRect.y - 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, selRect.y + selRect.height, x + w - 2, y + h - 2);
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 2);
            }
        }
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        switch (tabPlacement) {
            case 2: {
                nudge = isSelected ? -1 : 1;
                break;
            }
            case 4: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            default: {
                nudge = tabRect.width % 2;
            }
        }
        return nudge;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = 0;
        switch (tabPlacement) {
            case 3: {
                nudge = -1;
                break;
            }
            case 2: 
            case 4: {
                nudge = tabRect.height % 2;
                break;
            }
            default: {
                nudge = isSelected ? -1 : 1;
            }
        }
        return nudge;
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getTabLayoutPolicy() == 1;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return super.createLayoutManager();
        }
        return new TabbedPaneLayout();
    }

    @Override
    protected FontMetrics getFontMetrics() {
        Font font = PaletteLookAndFeel.getInstance().getFont("TabbedPane.selectedFont");
        return this.tabPane.getFontMetrics(font);
    }

    protected class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public TabbedPaneLayout() {
            super(PaletteTabbedPaneUI.this);
        }

        @Override
        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                super.normalizeTabRuns(tabPlacement, tabCount, start, max);
            }
        }

        @Override
        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
        }

        @Override
        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
        }
    }
}

