/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.mini;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.io.SerializationInputOutputFormat;
import org.jhotdraw.draw.tool.CreationTool;
import org.jhotdraw.util.ResourceBundleUtil;

public class CreationToolSample {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                DefaultDrawingView view = new DefaultDrawingView();
                DefaultDrawing drawing = new DefaultDrawing();
                drawing.addInputFormat(new SerializationInputOutputFormat());
                drawing.addOutputFormat(new SerializationInputOutputFormat());
                view.setDrawing(drawing);
                DefaultDrawingEditor editor = new DefaultDrawingEditor();
                editor.add(view);
                JToolBar tb = new JToolBar();
                ButtonFactory.addSelectionToolTo(tb, editor);
                HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
                AttributeKeys.FILL_COLOR.put(a, Color.GREEN);
                ButtonFactory.addToolTo(tb, editor, new CreationTool(new RectangleFigure(), a), "edit.createRectangle", labels);
                tb.setOrientation(1);
                JFrame f = new JFrame("Editor with Creation Tool");
                f.setDefaultCloseOperation(3);
                f.setSize(400, 300);
                f.getContentPane().add((Component)tb, "West");
                JScrollPane sp = new JScrollPane(view.getComponent());
                sp.setPreferredSize(new Dimension(200, 200));
                f.getContentPane().add((Component)sp, "Center");
                f.setVisible(true);
            }
        });
    }
}

