/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt.widget;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import org.scijava.plugin.Plugin;
import org.scijava.ui.awt.widget.AWTInputWidget;
import org.scijava.widget.FileWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class AWTFileWidget
extends AWTInputWidget<File>
implements FileWidget<Panel>,
ActionListener,
TextListener {
    private TextField path;
    private Button browse;

    public File getValue() {
        String text = this.path.getText();
        return text.isEmpty() ? null : new File(text);
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        this.getComponent().setLayout(new BorderLayout());
        this.path = new TextField(20);
        this.path.addTextListener(this);
        this.getComponent().add((Component)this.path, "Center");
        this.browse = new Button("Browse");
        this.browse.addActionListener(this);
        this.getComponent().add((Component)this.browse, "East");
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isType(File.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file = new File(this.path.getText());
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        String style = this.get().getItem().getWidgetStyle();
        FileDialog fileDialog = new FileDialog((Frame)null);
        if ("save".equals(style)) {
            fileDialog.setMode(1);
        } else {
            fileDialog.setMode(0);
        }
        fileDialog.setDirectory(file.getAbsolutePath());
        fileDialog.setVisible(true);
        String filename = fileDialog.getFile();
        fileDialog.dispose();
        if (filename == null) {
            return;
        }
        this.path.setText(filename);
    }

    @Override
    public void textValueChanged(TextEvent e) {
        this.updateModel();
    }

    public void doRefresh() {
        String text = this.get().getText();
        if (text.equals(this.path.getText())) {
            return;
        }
        this.path.setText(text);
    }
}

