/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.fontchooser.model;

import java.awt.Font;
import java.util.Objects;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.drjekyll.fontchooser.model.FontSelectionModel;

public class DefaultFontSelectionModel
implements FontSelectionModel {
    private static final int DEFAULT_SIZE = 12;
    private final EventListenerList listenerList = new EventListenerList();
    private transient ChangeEvent changeEvent;
    private Font selectedFont = new Font("SansSerif", 0, 12);

    public DefaultFontSelectionModel(Font font) {
        this.selectedFont = font;
    }

    @Override
    public Font getSelectedFont() {
        return this.selectedFont;
    }

    @Override
    public String getSelectedFontName() {
        return this.selectedFont.getName();
    }

    @Override
    public String getSelectedFontFamily() {
        return this.selectedFont.getFamily();
    }

    @Override
    public int getSelectedFontSize() {
        return this.selectedFont.getSize();
    }

    @Override
    public void setSelectedFont(Font font) {
        if (font != null && !this.selectedFont.equals(font)) {
            this.selectedFont = font;
            this.fireStateChanged();
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (!Objects.equals(listeners[i], ChangeListener.class)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

