/*
 * Decompiled with CFR 0.152.
 */
package levelsets.algorithm;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.LinkedList;
import levelsets.algorithm.BandElement;
import levelsets.algorithm.DeferredByteArray3D;
import levelsets.algorithm.FastMarching;
import levelsets.algorithm.StagedAlgorithm;

public class DenseFieldLevelSet
implements StagedAlgorithm {
    private double[][] phi = null;
    private double[][] phi_upd = null;
    private double[][] gradients = null;
    private double[][] extended_gradients = null;
    private byte[][] status = null;
    private BufferedImage inImg = null;
    private BufferedImage img = null;
    private LinkedList<BandElement> contour = new LinkedList();
    private FastMarching fm = null;
    private boolean needInit = true;
    int[] pixel = new int[4];
    private static byte FRONT = 1;
    private static byte BAND = (byte)2;
    private static byte FAR = (byte)3;
    private static double ADVECTION_FORCE = 0.1;
    private static double CURVATURE_EPSILON = 1.0;
    private static double DELTA_T = 0.1;

    public DenseFieldLevelSet(BufferedImage img, FastMarching fm) {
        this.img = img;
        this.fm = fm;
        this.phi = new double[img.getWidth()][img.getHeight()];
        this.phi_upd = new double[img.getWidth()][img.getHeight()];
        this.gradients = new double[img.getWidth()][img.getHeight()];
        this.extended_gradients = new double[img.getWidth()][img.getHeight()];
        this.status = new byte[img.getWidth()][img.getHeight()];
        this.inImg = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
        img.copyData(this.inImg.getRaster());
        this.calculateGradients();
    }

    @Override
    public boolean step(int granularity) {
        if (this.needInit) {
            this.initPhi();
            this.createDistanceTransform();
            this.visualize();
            this.needInit = false;
        }
        for (int i = 0; i < granularity; ++i) {
            this.iterate();
            this.visualize();
        }
        return true;
    }

    private void visualize() {
        this.inImg.copyData(this.img.getRaster());
        this.createFrontOverlay();
    }

    private void iterate() {
        for (int x = 0; x < this.phi.length; ++x) {
            for (int y = 0; y < this.phi[0].length; ++y) {
                this.update(x, y);
            }
        }
        double[][] phi_swap = this.phi;
        this.phi = this.phi_upd;
        this.phi_upd = phi_swap;
    }

    private void update(int x, int y) {
        double advection = this.getAdvectionTerm(x, y);
        double curvature = this.getCurvature(x, y);
        this.phi_upd[x][y] = this.phi[x][y] - DELTA_T * (advection * ADVECTION_FORCE + curvature * CURVATURE_EPSILON);
    }

    private double getAdvectionTerm(int x, int y) {
        double xB = x > 0 ? this.phi[x - 1][y] : Double.MAX_VALUE;
        double xF = x + 1 < this.phi.length ? this.phi[x + 1][y] : Double.MAX_VALUE;
        double yB = y > 0 ? this.phi[x][y - 1] : Double.MAX_VALUE;
        double yF = y + 1 < this.phi[0].length ? this.phi[x][y + 1] : Double.MAX_VALUE;
        double xBdiff = Math.max(this.phi[x][y] - xB, 0.0);
        double xFdiff = Math.min(xF - this.phi[x][y], 0.0);
        double yBdiff = Math.max(this.phi[x][y] - yB, 0.0);
        double yFdiff = Math.min(yF - this.phi[x][y], 0.0);
        return Math.sqrt(xBdiff * xBdiff + xFdiff * xFdiff + yBdiff * yBdiff + yFdiff * yFdiff);
    }

    private double getCurvature(int x, int y) {
        if (x == 0 || x >= this.phi.length - 1) {
            return 0.0;
        }
        if (y == 0 || y >= this.phi[0].length - 1) {
            return 0.0;
        }
        double phiX = (this.phi[x + 1][y] - this.phi[x - 1][y]) / 2.0;
        double phiY = (this.phi[x][y + 1] - this.phi[x][y - 1]) / 2.0;
        double phiXX = this.phi[x + 1][y] + this.phi[x - 1][y] - 2.0 * this.phi[x][y];
        double phiYY = this.phi[x][y + 1] + this.phi[x][y - 1] - 2.0 * this.phi[x][y];
        double phiXY = (this.phi[x + 1][y + 1] - this.phi[x + 1][y - 1] - this.phi[x - 1][y + 1] + this.phi[x - 1][y - 1]) / 4.0;
        double curvature = 0.0;
        double deltaPhi = 0.0;
        if (phiX != 0.0 || phiY != 0.0) {
            deltaPhi = Math.sqrt(phiX * phiX + phiY * phiY);
            curvature = -1.0 * (phiXX * phiY * phiY + phiYY * phiX * phiX - 2.0 * phiX * phiY * phiXY) / Math.pow(phiX * phiX + phiY * phiY, 1.0);
        }
        return curvature * deltaPhi;
    }

    private double getImageTerm() {
        return 0.0;
    }

    private void extractContour() {
        this.contour.clear();
        for (int x = 0; x < this.phi.length - 1; ++x) {
            for (int y = 0; y < this.phi[0].length - 1; ++y) {
                double max = Math.max(Math.max(this.phi[x][y], this.phi[x + 1][y]), Math.max(this.phi[x][y + 1], this.phi[x + 1][y + 1]));
                double min = Math.min(Math.min(this.phi[x][y], this.phi[x + 1][y]), Math.min(this.phi[x][y + 1], this.phi[x + 1][y + 1]));
                if (max < 0.0 || min > 0.0) continue;
                this.contour.add(new BandElement(x, y, 0, 0.0));
                this.writeContourPixel(x, y);
            }
        }
    }

    private void calculateGradients() {
        WritableRaster raster = this.img.getRaster();
        for (int x = 1; x < this.gradients.length - 2; ++x) {
            for (int y = 1; y < this.phi[0].length - 2; ++y) {
                double xGradient = (raster.getPixel(x + 1, y, this.pixel)[0] - raster.getPixel(x - 1, y, this.pixel)[0]) / 2;
                double yGradient = (raster.getPixel(x, y + 1, this.pixel)[0] - raster.getPixel(x, y - 1, this.pixel)[0]) / 2;
                this.gradients[x][y] = Math.sqrt(xGradient * xGradient + yGradient * yGradient);
            }
        }
    }

    private void writeContourPixel(int x, int y) {
        WritableRaster raster = this.img.getRaster();
        this.pixel[0] = 255;
        raster.setPixel(x, y, this.pixel);
    }

    private void createFrontOverlay() {
        this.extractContour();
    }

    private void writePixel(int x, int y, double value) {
        WritableRaster raster = this.img.getRaster();
        this.pixel[1] = this.pixel[2] = (int)value;
        this.pixel[0] = this.pixel[2];
        raster.setPixel(x, y, this.pixel);
    }

    public BufferedImage createImage(double[][] data) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int add = 0;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                int current = (int)Math.abs(data[i][j]);
                if (current < min) {
                    min = current;
                }
                if (current <= max) continue;
                max = current;
            }
        }
        add = -1 * min;
        BufferedImage image = this.img;
        WritableRaster out = image.getRaster();
        int[] pixel = new int[4];
        double scaler = 255.0 / (double)(max + add - (min + add));
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int current;
                pixel[1] = pixel[2] = (current = (int)Math.round((double)((int)Math.abs(data[i][j]) + add) * scaler));
                pixel[0] = pixel[2];
                out.setPixel(i, j, pixel);
            }
        }
        return image;
    }

    private void initPhi() {
        DeferredByteArray3D statemap = this.fm.getStateMap();
        for (int x = 0; x < statemap.getXLength(); ++x) {
            for (int y = 0; y < statemap.getYLength(); ++y) {
                if (statemap.get(x, y, 0) == 1) {
                    this.phi[x][y] = 0.0;
                    this.contour.add(new BandElement(x, y, 0, 0.0));
                    continue;
                }
                this.phi[x][y] = statemap.get(x, y, 0) == 2 ? -1.0 : 1.0;
            }
        }
    }

    private void createDistanceTransform() {
        DeferredByteArray3D statemap = this.fm.getStateMap();
        for (int x = 0; x < statemap.getXLength(); ++x) {
            for (int y = 0; y < statemap.getYLength(); ++y) {
                if (statemap.get(x, y, 0) == 1) continue;
                double sign = this.phi[x][y];
                this.phi[x][y] = Double.MAX_VALUE;
                for (BandElement current : this.contour) {
                    double dist = Math.sqrt((x - current.getX()) * (x - current.getX()) + (y - current.getY()) * (y - current.getY()));
                    if (!(dist < this.phi[x][y])) continue;
                    this.phi[x][y] = dist;
                }
                this.phi[x][y] = this.phi[x][y] * sign;
            }
        }
    }
}

