/*
 * Decompiled with CFR 0.152.
 */
package levelsets.algorithm;

import ij.IJ;
import levelsets.algorithm.LevelSetImplementation;
import levelsets.ij.ImageContainer;
import levelsets.ij.ImageProgressContainer;
import levelsets.ij.StateContainer;

public class GeodesicActiveContour
extends LevelSetImplementation {
    protected double[][][] gradients = null;
    protected double[][][] grad_gradients = null;
    protected final double ALPHA_ADVECTION;
    protected final double BETA_PROPAGATION;
    protected final double GAMMA_CURVATURE;
    protected final double GAMMA_GREYSCALE;
    protected final double GREY_EPSILON = 1.0;
    protected final double GREY_T = 1.0;

    public GeodesicActiveContour(ImageContainer image, ImageProgressContainer img_progress, StateContainer init_state, double convergence, double advection, double prop, double curve, double grey) {
        super(image, img_progress, init_state, convergence);
        this.ALPHA_ADVECTION = advection;
        this.BETA_PROPAGATION = prop;
        this.GAMMA_CURVATURE = curve;
        this.GAMMA_GREYSCALE = grey;
    }

    @Override
    protected final void init() {
        super.init();
        this.gradients = this.img.calculateGradients();
        for (int z = 0; z < this.gradients[0][0].length; ++z) {
            for (int x = 1; x < this.gradients.length - 1; ++x) {
                for (int y = 1; y < this.gradients[0].length - 1; ++y) {
                    this.gradients[x][y][z] = 1.0 / (1.0 + this.gradients[x][y][z] * 1.0);
                }
            }
        }
        this.grad_gradients = this.calculateGradients(this.gradients);
    }

    @Override
    protected final double getDeltaPhi(int x, int y, int z) {
        double curvature = this.getCurvatureTerm(x, y, z);
        double advection = this.getAdvectionTerm(x, y, z);
        double propagation = this.getPropagationTerm(x, y, z);
        double delta_phi = -this.DELTA_T * (advection * this.ALPHA_ADVECTION + propagation * this.BETA_PROPAGATION + curvature * this.GAMMA_CURVATURE);
        return delta_phi;
    }

    @Override
    protected final void updateDeltaT() {
        this.DELTA_T = 0.16666666666666666 / (this.GAMMA_CURVATURE * this.BETA_PROPAGATION * this.ALPHA_ADVECTION);
    }

    protected final double getAdvectionTerm(int x, int y, int z) {
        double result = 0.0;
        double xB = x > 0 ? this.phi.get(x - 1, y, z) : Double.MAX_VALUE;
        double xF = x + 1 < this.phi.getXLength() ? this.phi.get(x + 1, y, z) : Double.MAX_VALUE;
        double yB = y > 0 ? this.phi.get(x, y - 1, z) : Double.MAX_VALUE;
        double yF = y + 1 < this.phi.getYLength() ? this.phi.get(x, y + 1, z) : Double.MAX_VALUE;
        double zB = z > 0 ? this.phi.get(x, y, z - 1) : Double.MAX_VALUE;
        double zF = z + 1 < this.phi.getZLength() ? this.phi.get(x, y, z + 1) : Double.MAX_VALUE;
        double cell_phi = this.phi.get(x, y, z);
        double xBdiff = cell_phi - xB;
        double xFdiff = xF - cell_phi;
        double yBdiff = cell_phi - yB;
        double yFdiff = yF - cell_phi;
        double zBdiff = 0.0;
        double zFdiff = 0.0;
        result = this.grad_gradients[x][y][z] > 0.0 ? (xBdiff + yBdiff + zBdiff) * this.grad_gradients[x][y][z] : (xFdiff + yFdiff + zFdiff) * this.grad_gradients[x][y][z];
        return result;
    }

    protected final double getPropagationTerm(int x, int y, int z) {
        double yFdiff;
        double yBdiff;
        double xFdiff;
        double xBdiff;
        double xB = x > 0 ? this.phi.get(x - 1, y, z) : Double.MAX_VALUE;
        double xF = x + 1 < this.phi.getXLength() ? this.phi.get(x + 1, y, z) : Double.MAX_VALUE;
        double yB = y > 0 ? this.phi.get(x, y - 1, z) : Double.MAX_VALUE;
        double yF = y + 1 < this.phi.getYLength() ? this.phi.get(x, y + 1, z) : Double.MAX_VALUE;
        double zB = z > 0 ? this.phi.get(x, y, z - 1) : Double.MAX_VALUE;
        double zF = z + 1 < this.phi.getZLength() ? this.phi.get(x, y, z + 1) : Double.MAX_VALUE;
        double cell_phi = this.phi.get(x, y, z);
        double zBdiff = 0.0;
        double zFdiff = 0.0;
        if (this.gradients[x][y][z] > 0.0) {
            xBdiff = Math.max(cell_phi - xB, 0.0);
            xFdiff = Math.min(xF - cell_phi, 0.0);
            yBdiff = Math.max(cell_phi - yB, 0.0);
            yFdiff = Math.min(yF - cell_phi, 0.0);
        } else {
            xBdiff = Math.min(cell_phi - xB, 0.0);
            xFdiff = Math.max(xF - cell_phi, 0.0);
            yBdiff = Math.min(cell_phi - yB, 0.0);
            yFdiff = Math.max(yF - cell_phi, 0.0);
        }
        return Math.sqrt(xBdiff * xBdiff + xFdiff * xFdiff + yBdiff * yBdiff + yFdiff * yFdiff + zBdiff * zBdiff + zFdiff * zFdiff) * this.gradients[x][y][z];
    }

    protected final double getCurvatureTerm(int x, int y, int z) {
        if (x == 0 || x >= this.phi.getXLength() - 1) {
            return 0.0;
        }
        if (y == 0 || y >= this.phi.getYLength() - 1) {
            return 0.0;
        }
        boolean curvature_3d = false;
        double cell_phi = this.phi.get(x, y, z);
        double phiXB = this.phi.get(x - 1, y, z);
        double phiXF = this.phi.get(x + 1, y, z);
        double phiYB = this.phi.get(x, y - 1, z);
        double phiYF = this.phi.get(x, y + 1, z);
        double phiX = (phiXF - phiXB) / 2.0;
        double phiY = (phiYF - phiYB) / 2.0;
        double phiXX = phiXF + phiXB - 2.0 * cell_phi;
        double phiYY = phiYF + phiYB - 2.0 * cell_phi;
        double phiXY = (this.phi.get(x + 1, y + 1, z) - this.phi.get(x + 1, y - 1, z) - this.phi.get(x - 1, y + 1, z) + this.phi.get(x - 1, y - 1, z)) / 4.0;
        double phiZ = 0.0;
        double phiZZ = 0.0;
        double phiXZ = 0.0;
        double phiYZ = 0.0;
        if (curvature_3d) {
            double phiZB = this.phi.get(x, y, z - 1);
            double phiZF = this.phi.get(x, y, z + 1);
            phiZ = (phiZF - phiZB) / 2.0;
            phiZZ = phiZF + phiZB - 2.0 * cell_phi;
            phiXZ = (this.phi.get(x + 1, y, z + 1) - this.phi.get(x + 1, y, z - 1) - this.phi.get(x - 1, y, z + 1) + this.phi.get(x - 1, y, z - 1)) / 4.0;
            phiYZ = (this.phi.get(x, y + 1, z + 1) - this.phi.get(x, y + 1, z - 1) - this.phi.get(x, y - 1, z + 1) + this.phi.get(x, y - 1, z - 1)) / 4.0;
        }
        if (phiX == 0.0 || phiY == 0.0) {
            return 0.0;
        }
        if (curvature_3d && phiZ == 0.0) {
            return 0.0;
        }
        double curvature = 0.0;
        double deltaPhi = 0.0;
        if (curvature_3d) {
            deltaPhi = Math.sqrt(phiX * phiX + phiY * phiY + phiZ * phiZ);
            curvature = -1.0 * (phiXX * (phiY * phiY + phiZ * phiZ) + phiYY * (phiX * phiX + phiZ * phiZ) + phiZZ * (phiX * phiX + phiY * phiY) - 2.0 * phiX * phiY * phiXY - 2.0 * phiX * phiZ * phiXZ - 2.0 * phiY * phiZ * phiYZ) / Math.pow(phiX * phiX + phiY * phiY + phiZ * phiZ, 1.0);
        } else {
            deltaPhi = Math.sqrt(phiX * phiX + phiY * phiY);
            curvature = -1.0 * (phiXX * phiY * phiY + phiYY * phiX * phiX - 2.0 * phiX * phiY * phiXY) / Math.pow(phiX * phiX + phiY * phiY, 1.0);
        }
        return curvature * deltaPhi * this.gradients[x][y][z];
    }

    protected final double[][][] calculateGradients(double[][][] grad_src) {
        IJ.log((String)"Calculating gradients");
        double zScale = this.img.getzScale();
        double[][][] gradients = new double[this.img.getWidth()][this.img.getHeight()][this.img.getImageCount()];
        for (int z = 0; z < gradients[0][0].length; ++z) {
            for (int x = 1; x < gradients.length - 1; ++x) {
                for (int y = 1; y < gradients[0].length - 1; ++y) {
                    double xGradient = (grad_src[x + 1][y][z] - grad_src[x - 1][y][z]) / 2.0;
                    double yGradient = (grad_src[x][y + 1][z] - grad_src[x][y - 1][z]) / 2.0;
                    double zGradient = 0.0;
                    if (z > 0 && z < gradients[0][0].length - 1) {
                        zGradient = (grad_src[x][y][z + 1] - grad_src[x][y][z - 1]) / (2.0 * zScale);
                    }
                    gradients[x][y][z] = -Math.sqrt(xGradient * xGradient + yGradient * yGradient + zGradient * zGradient);
                }
            }
        }
        return gradients;
    }
}

