/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image.display;

import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.type.numeric.IntegerType;

public class IntegerTypeDisplay<T extends IntegerType<T>>
extends Display<T> {
    public IntegerTypeDisplay(Image<T> img) {
        super(img);
        IntegerType type = (IntegerType)img.createType();
        this.min = type.getMinValue();
        this.max = type.getMaxValue();
    }

    @Override
    public void setMinMax() {
        Cursor c = this.img.createCursor();
        if (!c.hasNext()) {
            IntegerType type = (IntegerType)this.img.createType();
            this.min = type.getMinValue();
            this.max = type.getMaxValue();
            return;
        }
        c.fwd();
        this.min = this.max = (double)((IntegerType)c.getType()).getIntegerLong();
        while (c.hasNext()) {
            c.fwd();
            long value = ((IntegerType)c.getType()).getIntegerLong();
            if ((double)value > this.max) {
                this.max = value;
                continue;
            }
            if (!((double)value < this.min)) continue;
            this.min = value;
        }
        c.close();
    }

    @Override
    public float get32Bit(T c) {
        return c.getIntegerLong();
    }

    @Override
    public float get32BitNormed(T c) {
        return this.normFloat(c.getIntegerLong());
    }

    @Override
    public byte get8BitSigned(T c) {
        return (byte)Math.round(this.normFloat(c.getIntegerLong()) * 255.0f);
    }

    @Override
    public short get8BitUnsigned(T c) {
        return (short)Math.round(this.normFloat(c.getIntegerLong()) * 255.0f);
    }
}

