/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.path;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.path.Path;

public class InvalidPath
implements Path {
    private final Path parent;
    private final JsonNode index;

    public InvalidPath(Path parent, JsonNode index) {
        this.parent = parent;
        this.index = index;
        if (parent == null) {
            throw new NullPointerException("parent must not be null");
        }
    }

    @Override
    public void toJsonNode(ArrayNode out) throws JsonQueryException {
        this.parent.toJsonNode(out);
        out.add(this.index);
    }

    @Override
    public void get(JsonNode in, Path ipath, PathOutput output, boolean permissive) throws JsonQueryException {
        this.parent.get(in, ipath, (parent, ppath) -> {
            throw new JsonQueryException(String.format("Cannot index %s with %s", in.getNodeType().toString().toLowerCase(), this.index.getNodeType().toString().toLowerCase()));
        }, permissive);
    }

    @Override
    public JsonNode mutate(JsonNode in, Path.Mutation mutation, boolean makeParent) throws JsonQueryException {
        return this.parent.mutate(in, oldval -> {
            throw new JsonQueryException(String.format("Cannot index %s with %s", in.getNodeType().toString().toLowerCase(), this.index.getNodeType().toString().toLowerCase()));
        }, makeParent);
    }
}

