/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.SibsonInterpolator3;
import edu.mines.jtk.interp.TestFunction;
import edu.mines.jtk.mosaic.PixelsView;
import edu.mines.jtk.mosaic.PlotFrame;
import edu.mines.jtk.mosaic.PlotPanelPixels3;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Stopwatch;
import java.awt.Color;
import javax.swing.SwingUtilities;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SibsonInterpolator3Test
extends TestCase {
    private static final float XMIN = 0.0f;
    private static final float XMAX = 1.0f;
    private static final int NS = 125;
    private static final int NX = 41;
    private static final double DX = (double)0.025f;
    private static final double FX = 0.0;
    private static final Sampling SX = new Sampling(41, 0.025f, 0.0);
    private static SibsonInterpolator3.Method HL = SibsonInterpolator3.Method.HALE_LIANG;
    private static SibsonInterpolator3.Method BS = SibsonInterpolator3.Method.BRAUN_SAMBRIDGE;
    private static SibsonInterpolator3.Method WS = SibsonInterpolator3.Method.WATSON_SAMBRIDGE;
    private static final double TOLERANCE = 1.0E-5;

    public static void main(String[] args) {
        if (args.length >= 1 && args[0].equals("bench")) {
            SibsonInterpolator3Test.benchMethods();
            return;
        }
        TestSuite suite = new TestSuite(SibsonInterpolator3Test.class);
        TestRunner.run((Test)suite);
    }

    public void testSimpleTet() {
        this.testSimpleTet(HL);
        this.testSimpleTet(BS);
        this.testSimpleTet(WS);
    }

    private void testSimpleTet(SibsonInterpolator3.Method m) {
        float[] f = new float[]{-1.0f, -1.0f, -1.0f, 3.0f};
        float[] x1 = new float[]{1.0f, -1.0f, -1.0f, 1.0f};
        float[] x2 = new float[]{-1.0f, 1.0f, -1.0f, 1.0f};
        float[] x3 = new float[]{-1.0f, -1.0f, 1.0f, 1.0f};
        SibsonInterpolator3 si = new SibsonInterpolator3(m, f, x1, x2, x3);
        this.assertValue(si, 0.0f, 0.0f, 0.0f, 0.0f);
        this.assertValue(si, 0.5f, 0.0f, 0.0f, 0.5f);
        this.assertValue(si, 0.0f, 0.5f, 0.0f, 0.5f);
        this.assertValue(si, 0.0f, 0.0f, 0.5f, 0.5f);
        this.assertValue(si, 0.5f, 0.5f, 0.5f, 1.5f);
    }

    public void testSimpleCube() {
        this.testSimpleCube(HL);
        this.testSimpleCube(BS);
    }

    private void testSimpleCube(SibsonInterpolator3.Method m) {
        float[] f = new float[]{-3.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 3.0f};
        float[] x1 = new float[]{-1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f};
        float[] x2 = new float[]{-1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f};
        float[] x3 = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        SibsonInterpolator3 si = new SibsonInterpolator3(m, f, x1, x2, x3);
        si.setNullValue(999.0f);
        this.assertValue(si, 0.0f, 0.0f, 0.0f, 0.0f);
        this.assertValue(si, -0.5f, -0.5f, -0.5f, -1.5f);
        this.assertValue(si, 0.5f, -0.5f, -0.5f, -0.5f);
        this.assertValue(si, -0.5f, 0.5f, -0.5f, -0.5f);
        this.assertValue(si, 0.5f, 0.5f, -0.5f, 0.5f);
        this.assertValue(si, -0.5f, -0.5f, 0.5f, -0.5f);
        this.assertValue(si, 0.5f, -0.5f, 0.5f, 0.5f);
        this.assertValue(si, -0.5f, 0.5f, 0.5f, 0.5f);
        this.assertValue(si, 0.5f, 0.5f, 0.5f, 1.5f);
    }

    public void testLinear() {
        this.testLinear(HL);
    }

    private void testLinear(SibsonInterpolator3.Method m) {
        TestFunction tf = TestFunction.makeLinear();
        float[][] fx = tf.sampleUniform3(125, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        float[] f = fx[0];
        float[] x1 = fx[1];
        float[] x2 = fx[2];
        float[] x3 = fx[3];
        SibsonInterpolator3 si = new SibsonInterpolator3(m, f, x1, x2, x3);
        si.setNullValue(999.0f);
        int n1 = 41;
        int n2 = 41;
        int n3 = 41;
        Sampling s1 = SX;
        Sampling s2 = SX;
        Sampling s3 = SX;
        float[][][] g = si.interpolate(s1, s2, s3);
        for (int i3 = 0; i3 < n3; ++i3) {
            float x3i = (float)s3.getValue(i3);
            for (int i2 = 0; i2 < n2; ++i2) {
                float x2i = (float)s2.getValue(i2);
                for (int i1 = 0; i1 < n1; ++i1) {
                    float x1i = (float)s1.getValue(i1);
                    float fe = tf.f(x1i, x2i, x3i);
                    this.assertEquals(fe, g[i3][i2][i1]);
                }
            }
        }
    }

    public static void benchMethods() {
        TestFunction tf = TestFunction.makeSine();
        SibsonInterpolator3Test.testScattered(tf);
        SibsonInterpolator3Test.testUniform(tf);
    }

    private void assertEquals(float e, float a) {
        SibsonInterpolator3Test.assertEquals((double)e, (double)a, (double)1.0E-5);
    }

    private void assertValue(SibsonInterpolator3 si, float x1, float x2, float x3, float f) {
        float g = si.interpolate(x1, x2, x3);
        this.assertEquals(f, g);
    }

    private static void testScattered(TestFunction tf) {
        float[][] fx = tf.sampleScattered3(125, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        SibsonInterpolator3Test.testMethods(tf, fx);
    }

    private static void testUniform(TestFunction tf) {
        float[][] fx = tf.sampleUniform3(125, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        SibsonInterpolator3Test.testMethods(tf, fx);
    }

    private static void testMethods(TestFunction tf, float[][] fx) {
        SibsonInterpolator3.Method[] methods;
        float[] f = fx[0];
        float[] x1 = fx[1];
        float[] x2 = fx[2];
        float[] x3 = fx[3];
        System.out.println();
        for (SibsonInterpolator3.Method method : methods = new SibsonInterpolator3.Method[]{HL}) {
            SibsonInterpolator3 si = new SibsonInterpolator3(method, f, x1, x2, x3);
            si.setNullValue(1.0f);
            si.setBounds(SX, SX, SX);
            si.setGradientPower(1.0);
            double tmin = Double.MAX_VALUE;
            float[][][] g = null;
            for (int iter = 0; iter < 3; ++iter) {
                Stopwatch sw = new Stopwatch();
                sw.start();
                g = si.interpolate(SX, SX, SX);
                sw.stop();
                tmin = ArrayMath.min(tmin, sw.time());
            }
            System.out.println("method=" + (Object)((Object)method) + " time=" + tmin);
            System.out.println("min=" + ArrayMath.min(g) + " max=" + ArrayMath.max(g));
            SibsonInterpolator3Test.plot(method, g);
        }
    }

    private static void dump(float[] f, float[] x1, float[] x2, float[] x3) {
        for (int i = 0; i < f.length; ++i) {
            System.out.println("i=" + i + " f=" + f[i] + " x1=" + x1[i] + " x2=" + x2[i] + " x3=" + x3[i]);
        }
    }

    private static void dump(float[][][] g) {
        int n1 = g[0][0].length;
        int n2 = g[0].length;
        int n3 = g.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    System.out.println("i1=" + i1 + " i2=" + i2 + " i3=" + i3 + " g=" + g[i3][i2][i1]);
                }
            }
        }
    }

    private static void plot(final SibsonInterpolator3.Method method, final float[][][] g) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlotPanelPixels3 plot = new PlotPanelPixels3(PlotPanelPixels3.Orientation.X1RIGHT, PlotPanelPixels3.AxesPlacement.LEFT_BOTTOM, SX, SX, SX, g);
                plot.setTitle(method.toString());
                plot.setLabel1("x");
                plot.setLabel2("y");
                plot.setLabel3("z");
                plot.addColorBar();
                plot.setLineColor(null);
                plot.setColorModel(ColorMap.JET);
                plot.setLineColor(Color.BLACK);
                plot.setInterpolation(PixelsView.Interpolation.NEAREST);
                plot.setClips(0.0f, 1.0f);
                PlotFrame frame = new PlotFrame(plot);
                frame.setSize(800, 760);
                frame.setDefaultCloseOperation(3);
                frame.setVisible(true);
            }
        });
    }
}

