/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.BoundingBox;
import edu.mines.jtk.sgl.BoundingBoxTree;
import edu.mines.jtk.util.ArrayMath;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BoundingBoxTreeTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(BoundingBoxTreeTest.class);
        TestRunner.run((Test)suite);
    }

    public void testRandom() {
        int minSize = 10;
        int n = 10000;
        float[] x = ArrayMath.randfloat(n);
        float[] y = ArrayMath.randfloat(n);
        float[] z = ArrayMath.randfloat(n);
        BoundingBoxTree bbt = new BoundingBoxTree(minSize, x, y, z);
        BoundingBoxTree.Node root = bbt.getRoot();
        this.test(root, minSize, x, y, z);
    }

    private void test(BoundingBoxTree.Node node, int minSize, float[] x, float[] y, float[] z) {
        int[] i = node.getIndices();
        int n = i.length;
        BoundingBoxTreeTest.assertTrue((minSize <= n ? 1 : 0) != 0);
        BoundingBox bb = node.getBoundingBox();
        for (int j = 0; j < n; ++j) {
            int ij = i[j];
            BoundingBoxTreeTest.assertTrue((boolean)bb.contains(x[ij], y[ij], z[ij]));
        }
        BoundingBoxTree.Node left = node.getLeft();
        BoundingBoxTree.Node right = node.getRight();
        if (left != null) {
            BoundingBoxTreeTest.assertTrue((boolean)bb.contains(left.getBoundingBox()));
            BoundingBoxTreeTest.assertTrue((boolean)bb.contains(right.getBoundingBox()));
            this.test(left, minSize, x, y, z);
            this.test(right, minSize, x, y, z);
        } else {
            BoundingBoxTreeTest.assertTrue((n / 2 < minSize ? 1 : 0) != 0);
        }
    }
}

