/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.actions;

import java.io.File;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FilenameUtils;
import sc.fiji.labkit.ui.Extensible;
import sc.fiji.labkit.ui.menu.MenuKey;

public abstract class AbstractFileIoAction {
    public static final FileFilter TIFF_FILTER = new FileNameExtensionFilter("TIF Image (*.tif, *.tiff)", "tif", "tiff");
    public static final FileFilter LABELING_FILTER = new FileNameExtensionFilter("Labeling (*.labeling)", "labeling");
    public static final FileFilter HDF5_FILTER = new FileNameExtensionFilter("HDF5 + XML (*.h5, *.xml)", "h5", "xml");
    protected final Extensible extensible;
    private final JFileChooser fileChooser;

    public AbstractFileIoAction(Extensible extensible, FileFilter ... fileFilters) {
        this.extensible = extensible;
        this.fileChooser = new JFileChooser();
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        for (FileFilter fileFilter : fileFilters) {
            this.fileChooser.addChoosableFileFilter(fileFilter);
        }
        this.fileChooser.setAcceptAllFileFilterUsed(true);
        this.fileChooser.setFileFilter(fileFilters[0]);
    }

    public <T> void initSaveAction(MenuKey<T> menuKey, String title, float priority, Action<T> action, String keyStroke) {
        this.initAction(menuKey, title, priority, action, keyStroke, 1);
    }

    public <T> void initOpenAction(MenuKey<T> menuKey, String title, float priority, Action<T> action, String keyStroke) {
        this.initAction(menuKey, title, priority, action, keyStroke, 0);
    }

    private <T> void initAction(MenuKey<T> menuKey, String title, float priority, Action<T> action, String keyStroke, int dialogType) {
        this.extensible.addMenuItem(menuKey, title, priority, data -> this.openDialogAndThen(title, dialogType, data, action), null, keyStroke);
    }

    protected <T> void openDialogAndThen(String title, int dialogType, T data, Action<T> action) {
        this.fileChooser.setDialogTitle(title);
        String filename = action.suggestedFile();
        if (filename != null) {
            this.fileChooser.setSelectedFile(new File(filename));
        }
        this.fileChooser.setDialogType(dialogType);
        int returnVal = this.fileChooser.showDialog(this.extensible.dialogParent(), null);
        if (returnVal == 0) {
            this.runAction(data, action, this.getSelectedFile());
        }
    }

    private String getSelectedFile() {
        FileFilter filter;
        String path = this.fileChooser.getSelectedFile().getAbsolutePath();
        boolean exists = new File(path).exists();
        String extension = FilenameUtils.getExtension((String)path);
        if (this.fileChooser.getDialogType() == 1 && !exists && (extension == null || extension.isEmpty()) && (filter = this.fileChooser.getFileFilter()) instanceof FileNameExtensionFilter) {
            return path + "." + ((FileNameExtensionFilter)filter).getExtensions()[0];
        }
        return path;
    }

    private <T> void runAction(T data, Action<T> action, String filename) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            try {
                action.run(data, filename);
            }
            catch (CancellationException cancellationException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                executor.shutdown();
            }
        });
    }

    public static interface Action<T> {
        default public String suggestedFile() {
            return null;
        }

        public void run(T var1, String var2) throws Exception;
    }
}

