/*
 * Decompiled with CFR 0.152.
 */
package fiji.stacks;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.NewImage;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;

public class Radial_Reslice
implements PlugInFilter {
    private static final String[] sense = new String[]{"Clockwise", "Anti-clockwise"};
    private static String senseAt = sense[0];
    private static boolean centre = false;
    private static boolean suppress = false;
    private double inputZSpacing = 1.0;
    private double outputZSpacing = 1.0;
    private double arcangle = 360.0;
    private int outputSlices = 1;
    private boolean noRoi;
    private boolean rgb;
    private ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        return 31;
    }

    public void run(ImageProcessor ip) {
        int roiType;
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        int stackSize = this.imp.getStackSize();
        Roi roi = this.imp.getRoi();
        int n = roiType = roi != null ? roi.getType() : 0;
        if (stackSize < 2) {
            IJ.error((String)"Radial Reslicer...", (String)"Stack required");
            return;
        }
        if (roiType != 5) {
            IJ.error((String)"Radial Reslicer...", (String)"Line selection required");
            return;
        }
        if (!this.showDialog(this.imp)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        ImagePlus imp2 = null;
        this.rgb = this.imp.getType() == 4;
        imp2 = this.radreslice(this.imp);
        if (imp2 == null) {
            return;
        }
        double min = ip.getMin();
        double max = ip.getMax();
        if (!this.rgb) {
            imp2.getProcessor().setMinAndMax(min, max);
        }
        imp2.show();
        if (this.noRoi) {
            this.imp.killRoi();
        } else {
            this.imp.draw();
        }
        IJ.showStatus((String)(IJ.d2s((double)((double)(System.currentTimeMillis() - startTime) / 1000.0), (int)2) + " seconds"));
    }

    public ImagePlus radreslice(ImagePlus imp) {
        Roi roi = imp.getRoi();
        int roiType = roi != null ? roi.getType() : 0;
        Calibration origCal = imp.getCalibration();
        ImagePlus imp2 = this.radslice(imp);
        imp2.setCalibration(imp.getCalibration());
        Calibration cal = imp2.getCalibration();
        cal.pixelDepth = origCal.pixelHeight;
        return imp2;
    }

    boolean showDialog(ImagePlus imp) {
        Calibration cal = imp.getCalibration();
        String units = cal.getUnits();
        if (cal.pixelWidth == 0.0) {
            cal.pixelWidth = 1.0;
        }
        double outputSpacing = cal.pixelDepth;
        this.inputZSpacing = cal.pixelDepth;
        GenericDialog gd2 = new GenericDialog("Radial Reslice");
        gd2.addNumericField("Angle (degrees):", 360.0, 0);
        gd2.addNumericField("Degrees_per_slice", 1.0, 0);
        gd2.addChoice("Direction:", sense, senseAt);
        gd2.addCheckbox("Rotate_about_centre", centre);
        gd2.addCheckbox("Suppress_reversed_duplicates", suppress);
        gd2.showDialog();
        if (gd2.wasCanceled()) {
            return false;
        }
        this.arcangle = gd2.getNextNumber();
        if (this.arcangle > 360.0 || this.arcangle < 1.0) {
            this.arcangle = 360.0;
        }
        if (cal.pixelDepth == 0.0) {
            cal.pixelDepth = 1.0;
        }
        this.outputSlices = (int)Math.round(this.arcangle / gd2.getNextNumber());
        senseAt = gd2.getNextChoice();
        centre = gd2.getNextBoolean();
        suppress = gd2.getNextBoolean();
        return true;
    }

    ImagePlus radslice(ImagePlus imp) {
        double X0 = 0.0;
        double Y0 = 0.0;
        double X1 = 0.0;
        double Y1 = 0.0;
        double X2 = 0.0;
        double Y2 = 0.0;
        double r = 0.0;
        double a = 0.0;
        double a0 = 0.0;
        double ang = 0.0;
        this.noRoi = false;
        Roi roi = imp.getRoi();
        Line line = (Line)roi;
        X1 = Math.round(line.x1);
        Y1 = Math.round(line.y1);
        X2 = Math.round(line.x2);
        Y2 = Math.round(line.y2);
        X0 = X1;
        Y0 = Y1;
        r = line.getRawLength();
        a = Math.PI / 180 * (this.arcangle / (double)this.outputSlices);
        if (centre) {
            X0 = X1 + (X2 - X1) / 2.0;
            Y0 = Y1 + (Y2 - Y1) / 2.0;
            r /= 2.0;
            if (suppress && this.arcangle > 180.0) {
                this.outputSlices = (int)((double)this.outputSlices * (180.0 / this.arcangle));
            }
        }
        if (senseAt.equals(sense[1])) {
            a = -a;
        }
        if ((a0 = Math.atan2(X2 - X0, Y0 - Y2)) < 0.0) {
            a0 += Math.PI * 2;
        }
        if (this.outputSlices == 0) {
            IJ.error((String)"Radial reslice", (String)("Output Z spacing (" + IJ.d2s((double)this.outputZSpacing, (int)0) + " pixels) is too large."));
            return null;
        }
        boolean virtualStack = imp.getStack().isVirtual();
        String status = null;
        Object imp2 = null;
        ImageStack stack2 = null;
        boolean isStack = imp.getStackSize() > 1;
        IJ.resetEscape();
        for (int i = 0; i < this.outputSlices; ++i) {
            if (virtualStack) {
                status = this.outputSlices > 1 ? i + 1 + "/" + this.outputSlices + ", " : "";
            }
            ImageProcessor ip = this.getSlice(imp, X1, Y1, X2, Y2, status);
            if (isStack) {
                this.drawLine(X1, Y1, X2, Y2, imp);
            }
            if (stack2 == null && ((stack2 = this.createOutputStack(imp, ip)) == null || stack2.getSize() < this.outputSlices)) {
                return null;
            }
            stack2.setPixels(ip.getPixels(), i + 1);
            ang = a0 + a * (double)(i + 1);
            if (ang < 0.0) {
                ang += Math.PI * 2;
            }
            X2 = r * Math.sin(ang) + X0;
            Y2 = Y0 - r * Math.cos(ang);
            if (centre) {
                X1 = -r * Math.sin(ang) + X0;
                Y1 = Y0 + r * Math.cos(ang);
            }
            if (!IJ.escapePressed()) continue;
            IJ.beep();
            imp.draw();
            return null;
        }
        return new ImagePlus("Reslice of " + imp.getShortTitle(), stack2);
    }

    ImageStack createOutputStack(ImagePlus imp, ImageProcessor ip) {
        int flags;
        int d2;
        int h2;
        int bitDepth = imp.getBitDepth();
        int w2 = ip.getWidth();
        ImagePlus imp2 = NewImage.createImage((String)"temp", (int)w2, (int)(h2 = ip.getHeight()), (int)(d2 = this.outputSlices), (int)bitDepth, (int)(flags = 9));
        if (imp2 != null && imp2.getStackSize() == d2) {
            IJ.showStatus((String)"Reslice... (press 'Esc' to abort)");
        }
        if (imp2 == null) {
            return null;
        }
        ImageStack stack2 = imp2.getStack();
        stack2.setColorModel(ip.getColorModel());
        return stack2;
    }

    ImageProcessor getSlice(ImagePlus imp, double x1, double y1, double x2, double y2, String status) {
        Roi roi = imp.getRoi();
        int roiType = roi != null ? roi.getType() : 0;
        ImageStack stack = imp.getStack();
        int stackSize = stack.getSize();
        ImageProcessor ip2 = null;
        float[] line = null;
        for (int i = 0; i < stackSize; ++i) {
            ImageProcessor ip = stack.getProcessor(i + 1);
            line = this.getLine(ip, x1, y1, x2, y2, line);
            if (i == 0) {
                ip2 = ip.createProcessor(line.length, stackSize);
            }
            this.putRow(ip2, 0, i, line, line.length);
            if (status == null) continue;
            IJ.showStatus((String)("Slicing: " + status + i + "/" + stackSize));
        }
        Calibration cal = imp.getCalibration();
        double zSpacing = this.inputZSpacing / cal.pixelWidth;
        if (zSpacing != 1.0) {
            ip2.setInterpolate(true);
            ip2 = ip2.resize(line.length, (int)((double)stackSize * zSpacing));
        }
        return ip2;
    }

    public void putRow(ImageProcessor ip, int x, int y, float[] data, int length) {
        if (this.rgb) {
            for (int i = 0; i < length; ++i) {
                ip.putPixel(x++, y, Float.floatToIntBits(data[i]));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                ip.putPixelValue(x++, y, (double)data[i]);
            }
        }
    }

    private float[] getLine(ImageProcessor ip, double x1, double y1, double x2, double y2, float[] data) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        int n = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
        if (data == null) {
            data = new float[n];
        }
        double xinc = dx / (double)n;
        double yinc = dy / (double)n;
        double rx = x1;
        double ry = y1;
        for (int i = 0; i < n; ++i) {
            if (this.rgb) {
                int rgbPixel = ((ColorProcessor)ip).getInterpolatedRGBPixel(rx, ry);
                data[i] = Float.intBitsToFloat(rgbPixel & 0xFFFFFF);
            } else {
                data[i] = (float)ip.getInterpolatedValue(rx, ry);
            }
            rx += xinc;
            ry += yinc;
        }
        return data;
    }

    void drawLine(double x1, double y1, double x2, double y2, ImagePlus imp) {
        ImageCanvas ic = imp.getCanvas();
        if (ic == null) {
            return;
        }
        Graphics g = ic.getGraphics();
        g.setColor(Roi.getColor());
        g.setXORMode(Color.black);
        g.drawLine(ic.screenX((int)(x1 + 0.5)), ic.screenY((int)(y1 + 0.5)), ic.screenX((int)(x2 + 0.5)), ic.screenY((int)(y2 + 0.5)));
    }
}

