/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.component;

import bdv.util.BdvHandle;
import bdv.viewer.ViewerPanel;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMLabKitFrame;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.util.Behaviours;
import sc.fiji.labkit.ui.brush.BdvMouseBehaviourUtils;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.models.ImageLabelingModel;

public class TMSelectLabelController {
    private static final double[] PIXEL_CENTER_OFFSET = new double[]{0.5, 0.5, 0.5};
    private final ClickBehaviour behaviour = this::click;
    private final BdvHandle bdv;
    private final ViewerPanel viewer;
    private final ImageLabelingModel model;
    private static final String SELECT_LABEL = "select label";
    private static final String[] SELECT_LABEL_KEYS = new String[]{"shift button1"};

    public TMSelectLabelController(BdvHandle bdv, ImageLabelingModel model) {
        this.bdv = bdv;
        this.viewer = bdv.getViewerPanel();
        this.model = model;
    }

    public void setActive(boolean active) {
        BdvMouseBehaviourUtils.setMouseBehaviourActive((BdvHandle)this.bdv, (Behaviour)this.behaviour, (boolean)active);
    }

    private void click(int x, int y) {
        RealPoint globalPosition = new RealPoint(3);
        this.viewer.displayToGlobalCoordinates((double)x, (double)y, (RealPositionable)globalPosition);
        this.model.labelTransformation().applyInverse((RealPositionable)globalPosition, (RealLocalizable)globalPosition);
        globalPosition.move(PIXEL_CENTER_OFFSET);
        RandomAccess ra = this.labeling().randomAccess();
        ra.setPosition((Localizable)this.roundAndReduceDimension((RealLocalizable)globalPosition, ra.numDimensions()));
        Optional<Label> label = this.nextLabel((LabelingType<Label>)((LabelingType)ra.get()), (Label)this.model.selectedLabel().get());
        label.ifPresent(arg_0 -> ((Holder)this.model.selectedLabel()).set(arg_0));
    }

    private Optional<Label> nextLabel(LabelingType<Label> labels, Label label) {
        List visibleLabels = labels.stream().filter(Label::isVisible).collect(Collectors.toList());
        visibleLabels.sort(Comparator.comparing(((Labeling)this.model.labeling().get()).getLabels()::indexOf));
        if (visibleLabels.contains(label)) {
            int index = visibleLabels.indexOf(label);
            return Optional.of((Label)visibleLabels.get((index + 1) % visibleLabels.size()));
        }
        return visibleLabels.stream().findFirst();
    }

    private RandomAccessibleInterval<LabelingType<Label>> labeling() {
        RandomAccessibleInterval label = (RandomAccessibleInterval)this.model.labeling().get();
        if (this.model.isTimeSeries()) {
            return Views.hyperSlice((RandomAccessibleInterval)label, (int)(label.numDimensions() - 1), (long)this.viewer.state().getCurrentTimepoint());
        }
        return label;
    }

    private Point roundAndReduceDimension(RealLocalizable realLocalizable, int numDimesions) {
        Point point = new Point(numDimesions);
        for (int i = 0; i < point.numDimensions(); ++i) {
            point.setPosition((long)realLocalizable.getDoublePosition(i), i);
        }
        return point;
    }

    public void install(Behaviours behaviours) {
        behaviours.behaviour((Behaviour)this.behaviour, SELECT_LABEL, SELECT_LABEL_KEYS);
    }

    @Plugin(type=CommandDescriptionProvider.class)
    public static class Descriptions
    extends CommandDescriptionProvider {
        public Descriptions() {
            super(TMLabKitFrame.KEY_CONFIG_SCOPE, new String[]{"trackmate-labkit"});
        }

        public void getCommandDescriptions(CommandDescriptions descriptions) {
            descriptions.add(TMSelectLabelController.SELECT_LABEL, SELECT_LABEL_KEYS, "Select the label under the cursor.");
        }
    }
}

