/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.gui.displaysettings.Colormap;
import fiji.plugin.trackmate.visualization.FeatureColorGenerator;
import fiji.plugin.trackmate.visualization.PerTrackFeatureColorGenerator;
import java.awt.Color;

public class SpotColorGeneratorPerTrackFeature
implements FeatureColorGenerator<Spot> {
    private final Model model;
    private final Color missingValueColor;
    private final PerTrackFeatureColorGenerator colorGenerator;

    public SpotColorGeneratorPerTrackFeature(Model model, String trackFeature, Color missingValueColor, Color undefinedValueColor, Colormap colormap, double min, double max) {
        this.model = model;
        this.missingValueColor = missingValueColor;
        this.colorGenerator = new PerTrackFeatureColorGenerator(model, trackFeature, missingValueColor, undefinedValueColor, colormap, min, max);
    }

    @Override
    public Color color(Spot spot) {
        Integer trackID = this.model.getTrackModel().trackIDOf(spot);
        if (null == trackID || !this.model.getTrackModel().isVisible(trackID)) {
            return this.missingValueColor;
        }
        return this.colorGenerator.colorOf(trackID);
    }
}

