/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.FactoryAnyD;
import org.ojalgo.access.Mutate1D;
import org.ojalgo.access.MutateAnyD;
import org.ojalgo.access.StructureAnyD;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.type.context.NumberContext;

public interface AccessAnyD<N extends Number>
extends StructureAnyD,
Access1D<N> {
    public static AccessAnyD<Double> asPrimitiveAnyD(final AccessAnyD<?> access) {
        return new AccessAnyD<Double>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long count(int dimension) {
                return access.count(dimension);
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long[] ref) {
                return access.doubleValue(ref);
            }

            @Override
            public Double get(long index) {
                return access.doubleValue(index);
            }

            @Override
            public Double get(long[] ref) {
                return access.doubleValue(ref);
            }

            @Override
            public long[] shape() {
                return access.shape();
            }
        };
    }

    public static boolean equals(AccessAnyD<?> accessA, AccessAnyD<?> accessB, NumberContext context) {
        long tmpCount;
        boolean retVal = true;
        int d = 0;
        while ((retVal &= (tmpCount = accessA.count(d)) == accessB.count(d)) && (++d <= 3 || tmpCount > 1L)) {
        }
        return retVal && Access1D.equals(accessA, accessB, context);
    }

    default public <NN extends Number, R extends MutateAnyD.Receiver<NN>> Collectable<NN, R> asCollectableAnyD() {
        return new Collectable<NN, R>(){

            @Override
            public long count(int dimension) {
                return AccessAnyD.this.count(dimension);
            }

            @Override
            public long[] shape() {
                return AccessAnyD.this.shape();
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.accept(AccessAnyD.this);
            }
        };
    }

    @Override
    default public double doubleValue(long index) {
        return this.doubleValue(StructureAnyD.reference(index, this.shape()));
    }

    public double doubleValue(long[] var1);

    @Override
    default public N get(long index) {
        return this.get(StructureAnyD.reference(index, this.shape()));
    }

    public N get(long[] var1);

    public static interface Visitable<N extends Number>
    extends StructureAnyD,
    Access1D.Visitable<N> {
        public void visitOne(long[] var1, VoidFunction<N> var2);

        public void visitSet(int var1, long var2, VoidFunction<N> var4);

        public void visitSet(long[] var1, int var2, VoidFunction<N> var3);
    }

    public static interface Sliceable<N extends Number>
    extends StructureAnyD,
    Access1D.Sliceable<N> {
        public Access1D<N> sliceSet(long[] var1, int var2);
    }

    public static interface IndexOf
    extends StructureAnyD,
    Access1D.IndexOf {
    }

    public static interface Elements
    extends StructureAnyD,
    Access1D.Elements {
        public boolean isAbsolute(long[] var1);

        public boolean isSmall(long[] var1, double var2);
    }

    public static interface Collectable<N extends Number, R extends MutateAnyD.Receiver<N>>
    extends StructureAnyD {
        default public <I extends R> I collect(FactoryAnyD<I> factory) {
            MutateAnyD.Receiver retVal = (MutateAnyD.Receiver)factory.makeZero(this.shape());
            this.supplyTo(retVal);
            return (I)retVal;
        }

        public void supplyTo(R var1);
    }

    public static interface Aggregatable<N extends Number>
    extends StructureAnyD,
    Access1D.Aggregatable<N> {
        public Number aggregateSet(int var1, long var2, Aggregator var4);

        public Number aggregateSet(long[] var1, int var2, Aggregator var3);

        default public void reduce(int dimension, Aggregator aggregator, Mutate1D receiver) {
            long count1 = this.count(dimension);
            long count2 = receiver.count();
            long limit = Math.min(count1, count2);
            for (long i = 0L; i < limit; ++i) {
                receiver.set(i, this.aggregateSet(dimension, i, aggregator));
            }
        }
    }
}

