/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.function.multiary.AbstractMultiary;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;

public final class LinearFunction<N extends Number>
extends AbstractMultiary<N, LinearFunction<N>>
implements MultiaryFunction.Linear<N> {
    private final MatrixStore<N> myFactors;

    public static LinearFunction<BigDecimal> makeBig(Access1D<? extends Number> factors) {
        return new LinearFunction<BigDecimal>((MatrixStore)BigDenseStore.FACTORY.rows(factors));
    }

    public static LinearFunction<BigDecimal> makeBig(int arity) {
        return new LinearFunction<BigDecimal>((MatrixStore)BigDenseStore.FACTORY.makeZero(1L, arity));
    }

    public static LinearFunction<ComplexNumber> makeComplex(Access1D<? extends Number> factors) {
        return new LinearFunction<ComplexNumber>((MatrixStore)GenericDenseStore.COMPLEX.rows(factors));
    }

    public static LinearFunction<ComplexNumber> makeComplex(int arity) {
        return new LinearFunction<ComplexNumber>((MatrixStore)GenericDenseStore.COMPLEX.makeZero(1L, arity));
    }

    public static LinearFunction<Double> makePrimitive(Access1D<? extends Number> factors) {
        return new LinearFunction<Double>((MatrixStore)PrimitiveDenseStore.FACTORY.rows(factors));
    }

    public static LinearFunction<Double> makePrimitive(int arity) {
        return new LinearFunction<Double>((MatrixStore)PrimitiveDenseStore.FACTORY.makeZero(1L, arity));
    }

    LinearFunction(MatrixStore<N> factors) {
        this.myFactors = factors;
        if (this.myFactors.countRows() != 1L) {
            throw new IllegalArgumentException("Must be a row vector!");
        }
    }

    @Override
    public int arity() {
        return (int)this.myFactors.countColumns();
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        return this.myFactors.transpose();
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.factory().builder().makeZero(this.arity(), this.arity()).get();
    }

    @Override
    public N invoke(Access1D<N> arg) {
        PhysicalStore tmpPreallocated = (PhysicalStore)this.myFactors.physical().makeZero(1L, 1L);
        Scalar retVal = this.getScalarConstant();
        this.myFactors.multiply(arg, tmpPreallocated);
        retVal = (Scalar)retVal.add(tmpPreallocated.get(0L, 0L));
        return retVal.get();
    }

    @Override
    public PhysicalStore<N> linear() {
        return (PhysicalStore)this.myFactors;
    }

    @Override
    protected PhysicalStore.Factory<N, ?> factory() {
        return this.myFactors.physical();
    }
}

