/*
 * Decompiled with CFR 0.152.
 */
package bunwarpj;

import bunwarpj.ClearAll;
import bunwarpj.IODialog;
import bunwarpj.MainDialog;
import bunwarpj.PointHandler;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.Toolbar;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class PointToolbar
extends Canvas
implements MouseListener {
    private static final long serialVersionUID = 4280253125939921252L;
    private static final int NUM_TOOLS = 19;
    private static final int SIZE = 22;
    private static final int OFFSET = 3;
    private static final Color gray = Color.lightGray;
    private static final Color brighter = gray.brighter();
    private static final Color darker = gray.darker();
    private static final Color evenDarker = darker.darker();
    private final boolean[] down = new boolean[19];
    private Graphics g;
    private ImagePlus sourceImp;
    private ImagePlus targetImp;
    private Toolbar previousInstance;
    private PointHandler sourcePh;
    private PointHandler targetPh;
    private PointToolbar instance;
    private long mouseDownTime;
    private int currentTool = 0;
    private int x;
    private int y;
    private int xOffset;
    private int yOffset;
    private MainDialog dialog;

    public PointToolbar(Toolbar previousToolbar, MainDialog dialog) {
        this.previousInstance = previousToolbar;
        this.dialog = dialog;
        this.instance = this;
        if (null != previousToolbar) {
            Container container = previousToolbar.getParent();
            Component[] component = container.getComponents();
            for (int i = 0; i < component.length; ++i) {
                if (component[i] != previousToolbar) continue;
                container.remove((Component)previousToolbar);
                container.add((Component)this, i);
                break;
            }
            this.resetButtons();
            this.down[this.currentTool] = true;
            this.setTool(this.currentTool);
            this.setForeground(evenDarker);
            this.setBackground(gray);
            this.addMouseListener(this);
            container.validate();
        }
    }

    public int getCurrentTool() {
        return this.currentTool;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int newTool = 0;
        for (int i = 0; i < 19; ++i) {
            if (i * 22 >= x || x >= i * 22 + 22) continue;
            newTool = i;
        }
        boolean doubleClick = newTool == this.getCurrentTool() && System.currentTimeMillis() - this.mouseDownTime <= 500L && newTool == 2;
        this.mouseDownTime = System.currentTimeMillis();
        if (newTool == 7 && !this.dialog.isFinalActionLaunched()) {
            return;
        }
        if (newTool != 7 && this.dialog.isFinalActionLaunched()) {
            return;
        }
        this.setTool(newTool);
        if (doubleClick) {
            ClearAll clearAllDialog = new ClearAll((Frame)IJ.getInstance(), this.sourcePh, this.targetPh);
            GUI.center((Window)clearAllDialog);
            clearAllDialog.setVisible(true);
            this.setTool(0);
            clearAllDialog.dispose();
        }
        switch (newTool) {
            case 5: {
                IODialog fileDialog = new IODialog((Frame)IJ.getInstance(), this.sourceImp, this.targetImp, this.sourcePh, this.targetPh, this.dialog);
                GUI.center((Window)fileDialog);
                fileDialog.setVisible(true);
                this.setTool(0);
                fileDialog.dispose();
                break;
            }
            case 3: 
            case 4: {
                this.dialog.setClearMask(true);
                break;
            }
            case 7: {
                this.dialog.setStopRegistration();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        for (int i = 0; i < 19; ++i) {
            this.drawButton(g, i);
        }
    }

    public void restorePreviousToolbar() {
        Container container = this.instance.getParent();
        if (null != container) {
            Component[] component = container.getComponents();
            for (int i = 0; i < component.length; ++i) {
                if (component[i] != this.instance) continue;
                container.remove(this.instance);
                container.add((Component)this.previousInstance, i);
                container.validate();
                break;
            }
        }
    }

    public void setAllUp() {
        for (int i = 0; i < 19; ++i) {
            this.down[i] = false;
        }
    }

    public void setSource(ImagePlus sourceImp, PointHandler sourcePh) {
        this.sourceImp = sourceImp;
        this.sourcePh = sourcePh;
    }

    public void setTarget(ImagePlus targetImp, PointHandler targetPh) {
        this.targetImp = targetImp;
        this.targetPh = targetPh;
    }

    public void setTool(int tool) {
        if (tool == this.currentTool) {
            return;
        }
        this.down[tool] = true;
        this.down[this.currentTool] = false;
        Graphics g = this.getGraphics();
        this.drawButton(g, this.currentTool);
        this.drawButton(g, tool);
        g.dispose();
        this.showMessage(tool);
        this.currentTool = tool;
    }

    private void d(int x, int y) {
        this.g.drawLine(this.x, this.y, x += this.xOffset, y += this.yOffset);
        this.x = x;
        this.y = y;
    }

    private void drawButton(Graphics g, int tool) {
        this.fill3DRect(g, tool * 22 + 1, 1, 22, 21, !this.down[tool]);
        if (tool == 7 && !this.dialog.isFinalActionLaunched()) {
            return;
        }
        if (tool != 7 && this.dialog.isFinalActionLaunched()) {
            return;
        }
        g.setColor(Color.black);
        int x = tool * 22 + 3;
        int y = 3;
        if (this.down[tool]) {
            ++x;
            ++y;
        }
        this.g = g;
        int[] px = new int[]{x + 4, x + 4, x + 14, x + 9, x + 14};
        int[] py = new int[]{y + 3, y + 13, y + 13, y + 8, y + 3};
        switch (tool) {
            case 0: {
                this.xOffset = x;
                this.yOffset = y;
                this.m(7, 0);
                this.d(7, 1);
                this.m(6, 2);
                this.d(6, 3);
                this.m(8, 2);
                this.d(8, 3);
                this.m(5, 4);
                this.d(5, 5);
                this.m(9, 4);
                this.d(9, 5);
                this.m(4, 6);
                this.d(4, 8);
                this.m(10, 6);
                this.d(10, 8);
                this.m(5, 9);
                this.d(5, 14);
                this.m(9, 9);
                this.d(9, 14);
                this.m(7, 4);
                this.d(7, 6);
                this.m(7, 8);
                this.d(7, 8);
                this.m(4, 11);
                this.d(10, 11);
                g.fillRect(x + 6, y + 12, 3, 3);
                this.m(11, 13);
                this.d(15, 13);
                this.m(13, 11);
                this.d(13, 15);
                break;
            }
            case 5: {
                this.xOffset = x;
                this.yOffset = y;
                this.m(3, 1);
                this.d(9, 1);
                this.d(9, 4);
                this.d(12, 4);
                this.d(12, 14);
                this.d(3, 14);
                this.d(3, 1);
                this.m(10, 2);
                this.d(11, 3);
                this.m(5, 4);
                this.d(7, 4);
                this.m(5, 6);
                this.d(10, 6);
                this.m(5, 8);
                this.d(10, 8);
                this.m(5, 10);
                this.d(10, 10);
                this.m(5, 12);
                this.d(10, 12);
                break;
            }
            case 11: {
                this.xOffset = x + 2;
                this.yOffset = y + 2;
                this.m(3, 0);
                this.d(3, 0);
                this.d(5, 0);
                this.d(8, 3);
                this.d(8, 5);
                this.d(7, 6);
                this.d(7, 7);
                this.d(6, 7);
                this.d(5, 8);
                this.d(3, 8);
                this.d(0, 5);
                this.d(0, 3);
                this.d(3, 0);
                this.m(8, 8);
                this.d(9, 8);
                this.d(13, 12);
                this.d(13, 13);
                this.d(12, 13);
                this.d(8, 9);
                this.d(8, 8);
                break;
            }
            case 1: {
                this.xOffset = x;
                this.yOffset = y;
                this.m(1, 1);
                this.d(1, 10);
                this.m(2, 2);
                this.d(2, 9);
                this.m(3, 3);
                this.d(3, 8);
                this.m(4, 4);
                this.d(4, 7);
                this.m(5, 5);
                this.d(5, 7);
                this.m(6, 6);
                this.d(6, 7);
                this.m(7, 7);
                this.d(7, 7);
                this.m(11, 5);
                this.d(11, 6);
                this.m(10, 7);
                this.d(10, 8);
                this.m(12, 7);
                this.d(12, 8);
                this.m(9, 9);
                this.d(9, 11);
                this.m(13, 9);
                this.d(13, 11);
                this.m(10, 12);
                this.d(10, 15);
                this.m(12, 12);
                this.d(12, 15);
                this.m(11, 9);
                this.d(11, 10);
                this.m(11, 13);
                this.d(11, 15);
                this.m(9, 13);
                this.d(13, 13);
                break;
            }
            case 2: {
                this.xOffset = x;
                this.yOffset = y;
                this.m(7, 0);
                this.d(7, 1);
                this.m(6, 2);
                this.d(6, 3);
                this.m(8, 2);
                this.d(8, 3);
                this.m(5, 4);
                this.d(5, 5);
                this.m(9, 4);
                this.d(9, 5);
                this.m(4, 6);
                this.d(4, 8);
                this.m(10, 6);
                this.d(10, 8);
                this.m(5, 9);
                this.d(5, 14);
                this.m(9, 9);
                this.d(9, 14);
                this.m(7, 4);
                this.d(7, 6);
                this.m(7, 8);
                this.d(7, 8);
                this.m(4, 11);
                this.d(10, 11);
                g.fillRect(x + 6, y + 12, 3, 3);
                this.m(11, 13);
                this.d(15, 13);
                break;
            }
            case 3: {
                this.xOffset = x;
                this.yOffset = y;
                g.fillPolygon(px, py, 5);
                break;
            }
            case 4: {
                this.xOffset = x;
                this.yOffset = y;
                g.fillRect(x + 1, y + 1, 15, 15);
                g.setColor(gray);
                g.fillPolygon(px, py, 5);
                g.setColor(Color.black);
                break;
            }
            case 7: {
                this.xOffset = x;
                this.yOffset = y;
                this.m(1, 5);
                this.d(1, 11);
                this.d(5, 15);
                this.d(11, 15);
                this.d(15, 11);
                this.d(15, 5);
                this.d(11, 1);
                this.d(5, 1);
                this.d(1, 5);
                this.m(5, 6);
                this.d(3, 6);
                this.d(3, 8);
                this.d(5, 8);
                this.d(5, 10);
                this.d(3, 10);
                this.m(6, 6);
                this.d(6, 8);
                this.m(7, 6);
                this.d(7, 10);
                this.m(11, 6);
                this.d(9, 6);
                this.d(9, 10);
                this.d(11, 10);
                this.d(11, 6);
                this.m(12, 10);
                this.d(12, 6);
                this.d(14, 6);
                this.d(14, 8);
                this.d(12, 8);
            }
        }
    }

    private void fill3DRect(Graphics g, int x, int y, int width, int height, boolean raised) {
        if (raised) {
            g.setColor(gray);
        } else {
            g.setColor(darker);
        }
        g.fillRect(x + 1, y + 1, width - 2, height - 2);
        g.setColor(raised ? brighter : evenDarker);
        g.drawLine(x, y, x, y + height - 1);
        g.drawLine(x + 1, y, x + width - 2, y);
        g.setColor(raised ? evenDarker : brighter);
        g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y, x + width - 1, y + height - 2);
    }

    private void m(int x, int y) {
        this.x = this.xOffset + x;
        this.y = this.yOffset + y;
    }

    private void resetButtons() {
        for (int i = 0; i < 19; ++i) {
            this.down[i] = false;
        }
    }

    private void showMessage(int tool) {
        switch (tool) {
            case 0: {
                IJ.showStatus((String)"Add crosses");
                return;
            }
            case 5: {
                IJ.showStatus((String)"Input/Output menu");
                return;
            }
            case 11: {
                IJ.showStatus((String)"Magnifying glass");
                return;
            }
            case 1: {
                IJ.showStatus((String)"Move crosses");
                return;
            }
            case 2: {
                IJ.showStatus((String)"Remove crosses");
                return;
            }
            case 3: {
                IJ.showStatus((String)"Draw an inner mask");
                return;
            }
            case 4: {
                IJ.showStatus((String)"Draw an outer mask");
                return;
            }
            case 7: {
                IJ.showStatus((String)"Stop registration");
                return;
            }
        }
        IJ.showStatus((String)"Undefined operation");
    }
}

