/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.internal;

import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Tuple3d;
import org.scijava.vecmath.Vector3d;

public class Distance {
    static final double FUZZ = 1.0E-5;

    private static final double DIST(double in) {
        return Math.abs(in);
    }

    public static double rayToSegment(Point3d rayorig, Vector3d raydir, Point3d segstart, Point3d segend) {
        return Distance.rayToSegment(rayorig, raydir, segstart, segend, null, null, null);
    }

    public static double rayToSegment(Point3d rayorig, Vector3d raydir, Point3d segstart, Point3d segend, Point3d rayint, Point3d segint, double[] param) {
        Vector3d diff = new Vector3d();
        diff.sub((Tuple3d)rayorig, (Tuple3d)segstart);
        Vector3d segdir = new Vector3d();
        segdir.sub((Tuple3d)segend, (Tuple3d)segstart);
        double A = raydir.dot(raydir);
        double B = -raydir.dot(segdir);
        double C = segdir.dot(segdir);
        double D = raydir.dot(diff);
        double F = diff.dot(diff);
        double det = Math.abs(A * C - B * B);
        if (det >= 1.0E-5) {
            double E = -segdir.dot(diff);
            double s = B * E - C * D;
            double t = B * D - A * E;
            if (s >= 0.0) {
                if (t >= 0.0) {
                    if (t <= det) {
                        double invDet = 1.0 / det;
                        s *= invDet;
                        t *= invDet;
                        if (rayint != null) {
                            rayint.scaleAdd(s, (Tuple3d)raydir, (Tuple3d)rayorig);
                        }
                        if (segint != null) {
                            segint.scaleAdd(t, (Tuple3d)segdir, (Tuple3d)segstart);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Distance.DIST(s * (A * s + B * t + 2.0 * D) + t * (B * s + C * t + 2.0 * E) + F);
                    }
                    t = 1.0;
                    if (D >= 0.0) {
                        s = 0.0;
                        if (rayint != null) {
                            rayint.set((Tuple3d)rayorig);
                        }
                        if (segint != null) {
                            segint.set((Tuple3d)segend);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Distance.DIST(C + 2.0 * E + F);
                    }
                    s = -D / A;
                    if (rayint != null) {
                        rayint.scaleAdd(s, (Tuple3d)raydir, (Tuple3d)rayorig);
                    }
                    if (segint != null) {
                        segint.set((Tuple3d)segend);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST((D + 2.0 * B) * s + C + 2.0 * E + F);
                }
                t = 0.0;
                if (D >= 0.0) {
                    s = 0.0;
                    if (rayint != null) {
                        rayint.set((Tuple3d)rayorig);
                    }
                    if (segint != null) {
                        segint.set((Tuple3d)segstart);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(F);
                }
                s = -D / A;
                if (rayint != null) {
                    rayint.scaleAdd(s, (Tuple3d)raydir, (Tuple3d)rayorig);
                }
                if (segint != null) {
                    segint.set((Tuple3d)segstart);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(D * s + F);
            }
            if (t <= 0.0) {
                if (D < 0.0) {
                    s = -D / A;
                    t = 0.0;
                    if (rayint != null) {
                        rayint.scaleAdd(s, (Tuple3d)raydir, (Tuple3d)rayorig);
                    }
                    if (segint != null) {
                        segint.set((Tuple3d)segstart);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(D * s + F);
                }
                s = 0.0;
                if (E >= 0.0) {
                    t = 0.0;
                    if (rayint != null) {
                        rayint.set((Tuple3d)rayorig);
                    }
                    if (segint != null) {
                        segint.set((Tuple3d)segstart);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(F);
                }
                if (-E >= C) {
                    t = 1.0;
                    if (rayint != null) {
                        rayint.set((Tuple3d)rayorig);
                    }
                    if (segint != null) {
                        segint.set((Tuple3d)segend);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(C + 2.0 * E + F);
                }
                t = -E / C;
                if (rayint != null) {
                    rayint.set((Tuple3d)rayorig);
                }
                if (segint != null) {
                    segint.scaleAdd(t, (Tuple3d)segdir, (Tuple3d)segstart);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(E * t + F);
            }
            if (t <= det) {
                s = 0.0;
                if (E >= 0.0) {
                    t = 0.0;
                    if (rayint != null) {
                        rayint.set((Tuple3d)rayorig);
                    }
                    if (segint != null) {
                        segint.set((Tuple3d)segstart);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(F);
                }
                if (-E >= C) {
                    t = 1.0;
                    if (rayint != null) {
                        rayint.set((Tuple3d)rayorig);
                    }
                    if (segint != null) {
                        segint.set((Tuple3d)segend);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(C + 2.0 * E + F);
                }
                t = -E / C;
                if (rayint != null) {
                    rayint.set((Tuple3d)rayorig);
                }
                if (segint != null) {
                    segint.scaleAdd(t, (Tuple3d)segdir, (Tuple3d)segstart);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(E * t + F);
            }
            double tmp = B + D;
            if (tmp < 0.0) {
                s = -tmp / A;
                t = 1.0;
                if (rayint != null) {
                    rayint.scaleAdd(s, (Tuple3d)raydir, (Tuple3d)rayorig);
                }
                if (segint != null) {
                    segint.set((Tuple3d)segend);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(tmp * s + C + 2.0 * E + F);
            }
            s = 0.0;
            if (E >= 0.0) {
                t = 0.0;
                if (rayint != null) {
                    rayint.set((Tuple3d)rayorig);
                }
                if (segint != null) {
                    segint.set((Tuple3d)segstart);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(F);
            }
            if (-E >= C) {
                t = 1.0;
                if (rayint != null) {
                    rayint.set((Tuple3d)rayorig);
                }
                if (segint != null) {
                    segint.set((Tuple3d)segend);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(C + 2.0 * E + F);
            }
            t = -E / C;
            if (rayint != null) {
                rayint.set((Tuple3d)rayorig);
            }
            if (segint != null) {
                segint.scaleAdd(t, (Tuple3d)segdir, (Tuple3d)segstart);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Distance.DIST(E * t + F);
        }
        if (B > 0.0) {
            double t = 0.0;
            if (D >= 0.0) {
                double s = 0.0;
                if (rayint != null) {
                    rayint.set((Tuple3d)rayorig);
                }
                if (segint != null) {
                    segint.set((Tuple3d)segstart);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(F);
            }
            double s = -D / A;
            if (rayint != null) {
                rayint.scaleAdd(s, (Tuple3d)raydir, (Tuple3d)rayorig);
            }
            if (segint != null) {
                segint.set((Tuple3d)segstart);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Distance.DIST(D * s + F);
        }
        double E = segdir.dot(diff);
        double t = 1.0;
        double tmp = B + D;
        if (tmp >= 0.0) {
            double s = 0.0;
            if (rayint != null) {
                rayint.set((Tuple3d)rayorig);
            }
            if (segint != null) {
                segint.set((Tuple3d)segend);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Distance.DIST(C + 2.0 * E + F);
        }
        double s = -tmp / A;
        if (rayint != null) {
            rayint.scaleAdd(s, (Tuple3d)raydir, (Tuple3d)rayorig);
        }
        if (segint != null) {
            segint.set((Tuple3d)segend);
        }
        if (param != null) {
            param[0] = s;
            param[1] = t;
        }
        return Distance.DIST(tmp * s + C + 2.0 * E + F);
    }

    public static double rayToRay(Point3d ray0orig, Vector3d ray0dir, Point3d ray1orig, Vector3d ray1dir) {
        return Distance.rayToRay(ray0orig, ray0dir, ray1orig, ray1dir, null, null, null);
    }

    public static double rayToRay(Point3d ray0orig, Vector3d ray0dir, Point3d ray1orig, Vector3d ray1dir, Point3d ray0int, Point3d ray1int, double[] param) {
        Vector3d diff = new Vector3d();
        diff.sub((Tuple3d)ray0orig, (Tuple3d)ray1orig);
        double A = ray0dir.dot(ray0dir);
        double B = -ray0dir.dot(ray1dir);
        double C = ray1dir.dot(ray1dir);
        double D = ray0dir.dot(diff);
        double F = diff.dot(diff);
        double det = Math.abs(A * C - B * B);
        if (det >= 1.0E-5) {
            double E = -ray1dir.dot(diff);
            double s = B * E - C * D;
            double t = B * D - A * E;
            if (s >= 0.0) {
                if (t >= 0.0) {
                    double invDet = 1.0 / det;
                    s *= invDet;
                    t *= invDet;
                    if (ray0int != null) {
                        ray0int.scaleAdd(s, (Tuple3d)ray0dir, (Tuple3d)ray0orig);
                    }
                    if (ray1int != null) {
                        ray1int.scaleAdd(t, (Tuple3d)ray1dir, (Tuple3d)ray1orig);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(s * (A * s + B * t + 2.0 * D) + t * (B * s + C * t + 2.0 * E) + F);
                }
                t = 0.0;
                if (D >= 0.0) {
                    s = 0.0;
                    if (ray0int != null) {
                        ray0int.set((Tuple3d)ray0orig);
                    }
                    if (ray1int != null) {
                        ray1int.set((Tuple3d)ray1orig);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(F);
                }
                s = -D / A;
                if (ray0int != null) {
                    ray0int.scaleAdd(s, (Tuple3d)ray0dir, (Tuple3d)ray0orig);
                }
                if (ray1int != null) {
                    ray1int.set((Tuple3d)ray1orig);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(D * s + F);
            }
            if (t >= 0.0) {
                s = 0.0;
                if (E >= 0.0) {
                    t = 0.0;
                    if (ray0int != null) {
                        ray0int.set((Tuple3d)ray0orig);
                    }
                    if (ray1int != null) {
                        ray1int.set((Tuple3d)ray1orig);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(F);
                }
                t = -E / C;
                if (ray0int != null) {
                    ray0int.set((Tuple3d)ray0orig);
                }
                if (ray1int != null) {
                    ray1int.scaleAdd(t, (Tuple3d)ray1dir, (Tuple3d)ray1orig);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(E * t + F);
            }
            if (D < 0.0) {
                s = -D / A;
                t = 0.0;
                if (ray0int != null) {
                    ray0int.scaleAdd(s, (Tuple3d)ray0dir, (Tuple3d)ray0orig);
                }
                if (ray1int != null) {
                    ray1int.set((Tuple3d)ray1orig);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(D * s + F);
            }
            s = 0.0;
            if (E >= 0.0) {
                t = 0.0;
                if (ray0int != null) {
                    ray0int.set((Tuple3d)ray0orig);
                }
                if (ray1int != null) {
                    ray1int.set((Tuple3d)ray1orig);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(F);
            }
            t = -E / C;
            if (ray0int != null) {
                ray0int.set((Tuple3d)ray0orig);
            }
            if (ray1int != null) {
                ray1int.scaleAdd(t, (Tuple3d)ray1dir, (Tuple3d)ray1orig);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Distance.DIST(E * t + F);
        }
        if (B > 0.0) {
            double t = 0.0;
            if (D >= 0.0) {
                double s = 0.0;
                if (ray0int != null) {
                    ray0int.set((Tuple3d)ray0orig);
                }
                if (ray1int != null) {
                    ray1int.set((Tuple3d)ray1orig);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(F);
            }
            double s = -D / A;
            if (ray0int != null) {
                ray0int.scaleAdd(s, (Tuple3d)ray0dir, (Tuple3d)ray0orig);
            }
            if (ray1int != null) {
                ray1int.set((Tuple3d)ray1orig);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Distance.DIST(D * s + F);
        }
        if (D >= 0.0) {
            double E = ray1dir.dot(diff);
            double s = 0.0;
            double t = -E / C;
            if (ray0int != null) {
                ray0int.set((Tuple3d)ray0orig);
            }
            if (ray1int != null) {
                ray1int.scaleAdd(t, (Tuple3d)ray1dir, (Tuple3d)ray1orig);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Distance.DIST(E * t + F);
        }
        double s = -D / A;
        double t = 0.0;
        if (ray0int != null) {
            ray0int.scaleAdd(s, (Tuple3d)ray0dir, (Tuple3d)ray0orig);
        }
        if (ray1int != null) {
            ray1int.set((Tuple3d)ray1orig);
        }
        if (param != null) {
            param[0] = s;
            param[1] = t;
        }
        return Distance.DIST(D * s + F);
    }

    public static double pointToRay(Point3d pt, Point3d rayorig, Vector3d raydir) {
        return Distance.pointToRay(pt, rayorig, raydir, null, null);
    }

    public static double pointToRay(Point3d pt, Point3d rayorig, Vector3d raydir, Point3d rayint, double[] param) {
        Vector3d diff = new Vector3d();
        diff.sub((Tuple3d)pt, (Tuple3d)rayorig);
        double t = raydir.dot(diff);
        if (t <= 0.0) {
            t = 0.0;
            if (rayint != null) {
                rayint.set((Tuple3d)rayorig);
            }
            if (param != null) {
                param[0] = t;
            }
        } else {
            diff.scaleAdd(-(t /= raydir.dot(raydir)), (Tuple3d)raydir, (Tuple3d)diff);
            if (rayint != null) {
                rayint.scaleAdd(t, (Tuple3d)raydir, (Tuple3d)rayorig);
            }
            if (param != null) {
                param[0] = t;
            }
        }
        return diff.dot(diff);
    }

    public static double pointToSegment(Point3d pt, Point3d segstart, Point3d segend) {
        return Distance.pointToSegment(pt, segstart, segend, null, null);
    }

    public static double pointToSegment(Point3d pt, Point3d segstart, Point3d segend, Point3d segint, double[] param) {
        Vector3d segdir = new Vector3d();
        segdir.sub((Tuple3d)segend, (Tuple3d)segstart);
        Vector3d diff = new Vector3d();
        diff.sub((Tuple3d)pt, (Tuple3d)segstart);
        double t = segdir.dot(diff);
        if (t <= 0.0) {
            t = 0.0;
            if (segint != null) {
                segint.set((Tuple3d)segstart);
            }
            if (param != null) {
                param[0] = t;
            }
        } else {
            double mDotm = segdir.dot(segdir);
            if (t >= mDotm) {
                t = 1.0;
                diff.sub((Tuple3d)segdir);
                if (segint != null) {
                    segint.set((Tuple3d)segend);
                }
                if (param != null) {
                    param[0] = t;
                }
            } else {
                diff.scaleAdd(-(t /= mDotm), (Tuple3d)segdir, (Tuple3d)diff);
                if (segint != null) {
                    segint.scaleAdd(t, (Tuple3d)segdir, (Tuple3d)segstart);
                }
                if (param != null) {
                    param[0] = t;
                }
            }
        }
        return diff.dot(diff);
    }

    public static double segmentToSegment(Point3d seg0start, Point3d seg0end, Point3d seg1start, Point3d seg1end) {
        return Distance.segmentToSegment(seg0start, seg0end, seg1start, seg1end, null, null, null);
    }

    public static double segmentToSegment(Point3d seg0start, Point3d seg0end, Point3d seg1start, Point3d seg1end, Point3d seg0int, Point3d seg1int, double[] param) {
        Vector3d diff = new Vector3d();
        diff.sub((Tuple3d)seg0start, (Tuple3d)seg1start);
        Vector3d seg0dir = new Vector3d();
        seg0dir.sub((Tuple3d)seg0end, (Tuple3d)seg0start);
        Vector3d seg1dir = new Vector3d();
        seg1dir.sub((Tuple3d)seg1end, (Tuple3d)seg1start);
        double A = seg0dir.dot(seg0dir);
        double B = -seg0dir.dot(seg1dir);
        double C = seg1dir.dot(seg1dir);
        double D = seg0dir.dot(diff);
        double F = diff.dot(diff);
        double det = Math.abs(A * C - B * B);
        if (det >= 1.0E-5) {
            double E = -seg1dir.dot(diff);
            double s = B * E - C * D;
            double t = B * D - A * E;
            if (s >= 0.0) {
                if (s <= det) {
                    if (t >= 0.0) {
                        if (t <= det) {
                            double invDet = 1.0 / det;
                            s *= invDet;
                            t *= invDet;
                            if (seg0int != null) {
                                seg0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)seg0start);
                            }
                            if (seg1int != null) {
                                seg1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)seg1start);
                            }
                            if (param != null) {
                                param[0] = s;
                                param[1] = t;
                            }
                            return Distance.DIST(s * (A * s + B * t + 2.0 * D) + t * (B * s + C * t + 2.0 * E) + F);
                        }
                        t = 1.0;
                        double tmp = B + D;
                        if (tmp >= 0.0) {
                            s = 0.0;
                            if (seg0int != null) {
                                seg0int.set((Tuple3d)seg0start);
                            }
                            if (seg1int != null) {
                                seg1int.set((Tuple3d)seg1end);
                            }
                            if (param != null) {
                                param[0] = s;
                                param[1] = t;
                            }
                            return Distance.DIST(C + 2.0 * E + F);
                        }
                        if (-tmp >= A) {
                            s = 1.0;
                            if (seg0int != null) {
                                seg0int.set((Tuple3d)seg0end);
                            }
                            if (seg1int != null) {
                                seg1int.set((Tuple3d)seg1end);
                            }
                            if (param != null) {
                                param[0] = s;
                                param[1] = t;
                            }
                            return Distance.DIST(A + C + F + 2.0 * (E + tmp));
                        }
                        s = -tmp / A;
                        if (seg0int != null) {
                            seg0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)seg0start);
                        }
                        if (seg1int != null) {
                            seg1int.set((Tuple3d)seg1end);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Distance.DIST(tmp * s + C + 2.0 * E + F);
                    }
                    t = 0.0;
                    if (D >= 0.0) {
                        s = 0.0;
                        if (seg0int != null) {
                            seg0int.set((Tuple3d)seg0start);
                        }
                        if (seg1int != null) {
                            seg1int.set((Tuple3d)seg1start);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Distance.DIST(F);
                    }
                    if (-D >= A) {
                        s = 1.0;
                        if (seg0int != null) {
                            seg0int.set((Tuple3d)seg0end);
                        }
                        if (seg1int != null) {
                            seg1int.set((Tuple3d)seg1start);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Distance.DIST(A + 2.0 * D + F);
                    }
                    s = -D / A;
                    if (seg0int != null) {
                        seg0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)seg0start);
                    }
                    if (seg1int != null) {
                        seg1int.set((Tuple3d)seg1start);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(D * s + F);
                }
                if (t >= 0.0) {
                    if (t <= det) {
                        s = 1.0;
                        double tmp = B + E;
                        if (tmp >= 0.0) {
                            t = 0.0;
                            if (seg0int != null) {
                                seg0int.set((Tuple3d)seg0end);
                            }
                            if (seg1int != null) {
                                seg1int.set((Tuple3d)seg1start);
                            }
                            if (param != null) {
                                param[0] = s;
                                param[1] = t;
                            }
                            return Distance.DIST(A + 2.0 * D + F);
                        }
                        if (-tmp >= C) {
                            t = 1.0;
                            if (seg0int != null) {
                                seg0int.set((Tuple3d)seg0end);
                            }
                            if (seg1int != null) {
                                seg1int.set((Tuple3d)seg1end);
                            }
                            if (param != null) {
                                param[0] = s;
                                param[1] = t;
                            }
                            return Distance.DIST(A + C + F + 2.0 * (D + tmp));
                        }
                        t = -tmp / C;
                        if (seg0int != null) {
                            seg0int.set((Tuple3d)seg0end);
                        }
                        if (seg1int != null) {
                            seg1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)seg1start);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Distance.DIST(tmp * t + A + 2.0 * D + F);
                    }
                    double tmp = B + D;
                    if (-tmp <= A) {
                        t = 1.0;
                        if (tmp >= 0.0) {
                            s = 0.0;
                            if (seg0int != null) {
                                seg0int.set((Tuple3d)seg0start);
                            }
                            if (seg1int != null) {
                                seg1int.set((Tuple3d)seg1end);
                            }
                            if (param != null) {
                                param[0] = s;
                                param[1] = t;
                            }
                            return Distance.DIST(C + 2.0 * E + F);
                        }
                        s = -tmp / A;
                        if (seg0int != null) {
                            seg0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)seg0start);
                        }
                        if (seg1int != null) {
                            seg1int.set((Tuple3d)seg1end);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Distance.DIST(tmp * s + C + 2.0 * E + F);
                    }
                    s = 1.0;
                    tmp = B + E;
                    if (tmp >= 0.0) {
                        t = 0.0;
                        if (seg0int != null) {
                            seg0int.set((Tuple3d)seg0end);
                        }
                        if (seg1int != null) {
                            seg1int.set((Tuple3d)seg1start);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Distance.DIST(A + 2.0 * D + F);
                    }
                    if (-tmp >= C) {
                        t = 1.0;
                        if (seg0int != null) {
                            seg0int.set((Tuple3d)seg0end);
                        }
                        if (seg1int != null) {
                            seg1int.set((Tuple3d)seg1end);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Distance.DIST(A + C + F + 2.0 * (D + tmp));
                    }
                    t = -tmp / C;
                    if (seg0int != null) {
                        seg0int.set((Tuple3d)seg0end);
                    }
                    if (seg1int != null) {
                        seg1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)seg1start);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(tmp * t + A + 2.0 * D + F);
                }
                if (-D < A) {
                    t = 0.0;
                    if (D >= 0.0) {
                        s = 0.0;
                        if (seg0int != null) {
                            seg0int.set((Tuple3d)seg0start);
                        }
                        if (seg1int != null) {
                            seg1int.set((Tuple3d)seg1start);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Distance.DIST(F);
                    }
                    s = -D / A;
                    if (seg0int != null) {
                        seg0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)seg0start);
                    }
                    if (seg1int != null) {
                        seg1int.set((Tuple3d)seg1start);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(D * s + F);
                }
                s = 1.0;
                double tmp = B + E;
                if (tmp >= 0.0) {
                    t = 0.0;
                    if (seg0int != null) {
                        seg0int.set((Tuple3d)seg0end);
                    }
                    if (seg1int != null) {
                        seg1int.set((Tuple3d)seg1start);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(A + 2.0 * D + F);
                }
                if (-tmp >= C) {
                    t = 1.0;
                    if (seg0int != null) {
                        seg0int.set((Tuple3d)seg0end);
                    }
                    if (seg1int != null) {
                        seg1int.set((Tuple3d)seg1end);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(A + C + F + 2.0 * (D + tmp));
                }
                t = -tmp / C;
                if (seg0int != null) {
                    seg0int.set((Tuple3d)seg0end);
                }
                if (seg1int != null) {
                    seg1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)seg1start);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(tmp * t + A + 2.0 * D + F);
            }
            if (t >= 0.0) {
                if (t <= det) {
                    s = 0.0;
                    if (E >= 0.0) {
                        t = 0.0;
                        if (seg0int != null) {
                            seg0int.set((Tuple3d)seg0start);
                        }
                        if (seg1int != null) {
                            seg1int.set((Tuple3d)seg1start);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Distance.DIST(F);
                    }
                    if (-E >= C) {
                        t = 1.0;
                        if (seg0int != null) {
                            seg0int.set((Tuple3d)seg0start);
                        }
                        if (seg1int != null) {
                            seg1int.set((Tuple3d)seg1end);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Distance.DIST(C + 2.0 * E + F);
                    }
                    t = -E / C;
                    if (seg0int != null) {
                        seg0int.set((Tuple3d)seg0start);
                    }
                    if (seg1int != null) {
                        seg1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)seg1start);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(E * t + F);
                }
                double tmp = B + D;
                if (tmp < 0.0) {
                    t = 1.0;
                    if (-tmp >= A) {
                        s = 1.0;
                        if (seg0int != null) {
                            seg0int.set((Tuple3d)seg0end);
                        }
                        if (seg1int != null) {
                            seg1int.set((Tuple3d)seg1end);
                        }
                        if (param != null) {
                            param[0] = s;
                            param[1] = t;
                        }
                        return Distance.DIST(A + C + F + 2.0 * (E + tmp));
                    }
                    s = -tmp / A;
                    if (seg0int != null) {
                        seg0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)seg0start);
                    }
                    if (seg1int != null) {
                        seg1int.set((Tuple3d)seg1end);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(tmp * s + C + 2.0 * E + F);
                }
                s = 0.0;
                if (E >= 0.0) {
                    t = 0.0;
                    if (seg0int != null) {
                        seg0int.set((Tuple3d)seg0start);
                    }
                    if (seg1int != null) {
                        seg1int.set((Tuple3d)seg1start);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(F);
                }
                if (-E >= C) {
                    t = 1.0;
                    if (seg0int != null) {
                        seg0int.set((Tuple3d)seg0start);
                    }
                    if (seg1int != null) {
                        seg1int.set((Tuple3d)seg1end);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(C + 2.0 * E + F);
                }
                t = -E / C;
                if (seg0int != null) {
                    seg0int.set((Tuple3d)seg0start);
                }
                if (seg1int != null) {
                    seg1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)seg1start);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(E * t + F);
            }
            if (D < 0.0) {
                t = 0.0;
                if (-D >= A) {
                    s = 1.0;
                    if (seg0int != null) {
                        seg0int.set((Tuple3d)seg0end);
                    }
                    if (seg1int != null) {
                        seg1int.set((Tuple3d)seg1start);
                    }
                    if (param != null) {
                        param[0] = s;
                        param[1] = t;
                    }
                    return Distance.DIST(A + 2.0 * D + F);
                }
                s = -D / A;
                if (seg0int != null) {
                    seg0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)seg0start);
                }
                if (seg1int != null) {
                    seg1int.set((Tuple3d)seg1start);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(D * s + F);
            }
            s = 0.0;
            if (E >= 0.0) {
                t = 0.0;
                if (seg0int != null) {
                    seg0int.set((Tuple3d)seg0start);
                }
                if (seg1int != null) {
                    seg1int.set((Tuple3d)seg1start);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(F);
            }
            if (-E >= C) {
                t = 1.0;
                if (seg0int != null) {
                    seg0int.set((Tuple3d)seg0start);
                }
                if (seg1int != null) {
                    seg1int.set((Tuple3d)seg1end);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(C + 2.0 * E + F);
            }
            t = -E / C;
            if (seg0int != null) {
                seg0int.set((Tuple3d)seg0start);
            }
            if (seg1int != null) {
                seg1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)seg1start);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Distance.DIST(E * t + F);
        }
        if (B > 0.0) {
            if (D >= 0.0) {
                double s = 0.0;
                double t = 0.0;
                if (seg0int != null) {
                    seg0int.set((Tuple3d)seg0start);
                }
                if (seg1int != null) {
                    seg1int.set((Tuple3d)seg1start);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(F);
            }
            if (-D <= A) {
                double s = -D / A;
                double t = 0.0;
                if (seg0int != null) {
                    seg0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)seg0start);
                }
                if (seg1int != null) {
                    seg1int.set((Tuple3d)seg1start);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(D * s + F);
            }
            double E = -seg1dir.dot(diff);
            double s = 1.0;
            double tmp = A + D;
            if (-tmp >= B) {
                double t = 1.0;
                if (seg0int != null) {
                    seg0int.set((Tuple3d)seg0end);
                }
                if (seg1int != null) {
                    seg1int.set((Tuple3d)seg1end);
                }
                if (param != null) {
                    param[0] = s;
                    param[1] = t;
                }
                return Distance.DIST(A + C + F + 2.0 * (B + D + E));
            }
            double t = -tmp / B;
            if (seg0int != null) {
                seg0int.set((Tuple3d)seg0end);
            }
            if (seg1int != null) {
                seg1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)seg1start);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Distance.DIST(A + 2.0 * D + F + t * (C * t + 2.0 * (B + E)));
        }
        if (-D >= A) {
            double s = 1.0;
            double t = 0.0;
            if (seg0int != null) {
                seg0int.set((Tuple3d)seg0end);
            }
            if (seg1int != null) {
                seg1int.set((Tuple3d)seg1start);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Distance.DIST(A + 2.0 * D + F);
        }
        if (D <= 0.0) {
            double s = -D / A;
            double t = 0.0;
            if (seg0int != null) {
                seg0int.scaleAdd(s, (Tuple3d)seg0dir, (Tuple3d)seg0start);
            }
            if (seg1int != null) {
                seg1int.set((Tuple3d)seg1start);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Distance.DIST(D * s + F);
        }
        double E = -seg1dir.dot(diff);
        double s = 0.0;
        if (D >= -B) {
            double t = 1.0;
            if (seg0int != null) {
                seg0int.set((Tuple3d)seg0start);
            }
            if (seg1int != null) {
                seg1int.set((Tuple3d)seg1end);
            }
            if (param != null) {
                param[0] = s;
                param[1] = t;
            }
            return Distance.DIST(C + 2.0 * E + F);
        }
        double t = -D / B;
        if (seg0int != null) {
            seg0int.set((Tuple3d)seg0start);
        }
        if (seg1int != null) {
            seg1int.scaleAdd(t, (Tuple3d)seg1dir, (Tuple3d)seg1start);
        }
        if (param != null) {
            param[0] = s;
            param[1] = t;
        }
        return Distance.DIST(F + t * (2.0 * E + C * t));
    }
}

