/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.utils.image;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.ImageComponentState;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.utils.image.ImageComponent2DURL;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.utils.image.ImageComponent2DURLIOListener;

public class ImageComponent2DURLState
extends ImageComponentState {
    private static ImageComponent2DURLIOListener listener = new DefaultListener();
    private URL url;

    public ImageComponent2DURLState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        out.writeUTF(((ImageComponent2DURL)this.node).getURL().toExternalForm());
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        String urlString = in.readUTF();
        try {
            this.url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Bad URL in ImageComponent2DURL " + urlString);
        }
    }

    @Override
    protected SceneGraphObject createNode(Class j3dClass) {
        return listener.createImageComponent(this.format, this.width, this.height, this.byReference, this.yUp, this.url);
    }

    @Override
    protected SceneGraphObject createNode() {
        return listener.createImageComponent(this.format, this.width, this.height, this.byReference, this.yUp, this.url);
    }

    public static void setLoadListener(ImageComponent2DURLIOListener loadListener) {
        listener = loadListener;
    }

    static class DefaultListener
    implements ImageComponent2DURLIOListener {
        DefaultListener() {
        }

        @Override
        public ImageComponent2DURL createImageComponent(int format, int width, int height, boolean byReference, boolean yUp, URL url) {
            System.out.println("Default ImageComponent2DURL loader not implemented " + url);
            return new ImageComponent2DURL(format, width, height);
        }
    }
}

