/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.DOMOutput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavaxDOMOutput
implements DOMOutput {
    private String doctype;
    private HashMap<Object, String> objectids;
    private HashMap<String, Object> prototypes;
    private Document document;
    private Node current;
    private DOMFactory factory;

    public JavaxDOMOutput(DOMFactory factory) throws IOException {
        this.factory = factory;
    }

    protected void reset() throws IOException {
        try {
            this.objectids = new HashMap();
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.current = this.document;
        }
        catch (ParserConfigurationException e) {
            IOException error = new IOException(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    public void save(OutputStream out) throws IOException {
        this.reset();
        try {
            if (this.doctype != null) {
                OutputStreamWriter w = new OutputStreamWriter(out, "UTF8");
                w.write("<!DOCTYPE ");
                w.write(this.doctype);
                w.write(">\n");
                w.flush();
            }
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.transform(new DOMSource(this.document), new StreamResult(out));
        }
        catch (TransformerException e) {
            IOException error = new IOException(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    public void save(Writer out) throws IOException {
        this.reset();
        try {
            if (this.doctype != null) {
                out.write("<!DOCTYPE ");
                out.write(this.doctype);
                out.write(">\n");
            }
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.transform(new DOMSource(this.document), new StreamResult(out));
        }
        catch (TransformerException e) {
            IOException error = new IOException(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public void openElement(String tagName) {
        Element newElement = this.document.createElement(tagName);
        this.current.appendChild(newElement);
        this.current = newElement;
    }

    @Override
    public void closeElement() {
        this.current = this.current.getParentNode();
    }

    @Override
    public void addComment(String comment) {
        this.current.appendChild(this.document.createComment(comment));
    }

    @Override
    public void addText(String text) {
        this.current.appendChild(this.document.createTextNode(text));
    }

    @Override
    public void addAttribute(String name, String value) {
        if (value != null) {
            ((Element)this.current).setAttribute(name, value);
        }
    }

    @Override
    public void addAttribute(String name, int value) {
        ((Element)this.current).setAttribute(name, Integer.toString(value));
    }

    @Override
    public void addAttribute(String name, boolean value) {
        ((Element)this.current).setAttribute(name, Boolean.toString(value));
    }

    @Override
    public void addAttribute(String name, float value) {
        String str = Float.toString(value);
        if (str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        ((Element)this.current).setAttribute(name, str);
    }

    @Override
    public void addAttribute(String name, double value) {
        String str = Double.toString(value);
        if (str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        ((Element)this.current).setAttribute(name, str);
    }

    @Override
    public void writeObject(Object o) throws IOException {
        String tagName = this.factory.getName(o);
        if (tagName == null) {
            throw new IllegalArgumentException("no tag name for:" + o);
        }
        this.openElement(tagName);
        if (this.objectids.containsKey(o)) {
            this.addAttribute("ref", this.objectids.get(o));
        } else {
            String id = Integer.toString(this.objectids.size(), 16);
            this.objectids.put(o, id);
            this.addAttribute("id", id);
            this.factory.write(this, o);
        }
        this.closeElement();
    }

    @Override
    public void addAttribute(String name, float value, float defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    @Override
    public void addAttribute(String name, int value, int defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    @Override
    public void addAttribute(String name, double value, double defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    @Override
    public void addAttribute(String name, boolean value, boolean defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    @Override
    public void addAttribute(String name, String value, String defaultValue) {
        if (!value.equals(defaultValue)) {
            this.addAttribute(name, value);
        }
    }

    @Override
    public Object getPrototype() {
        if (this.prototypes == null) {
            this.prototypes = new HashMap();
        }
        if (!this.prototypes.containsKey(this.current.getNodeName())) {
            this.prototypes.put(this.current.getNodeName(), this.factory.create(this.current.getNodeName()));
        }
        return this.prototypes.get(this.current.getNodeName());
    }

    @Override
    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }
}

