/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.text.io;

import java.io.IOException;
import org.scijava.io.AbstractIOPlugin;
import org.scijava.io.IOPlugin;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.text.TextService;

@Plugin(type=IOPlugin.class, priority=-101.0)
public class TextIOPlugin
extends AbstractIOPlugin<String> {
    @Parameter(required=false)
    private TextService textService;

    @Override
    public Class<String> getDataType() {
        return String.class;
    }

    @Override
    public boolean supportsOpen(Location source) {
        if (this.textService == null) {
            return false;
        }
        if (!(source instanceof FileLocation)) {
            return false;
        }
        FileLocation loc = (FileLocation)source;
        return this.textService.supports(loc.getFile());
    }

    @Override
    public String open(Location source) throws IOException {
        if (this.textService == null) {
            return null;
        }
        if (!(source instanceof FileLocation)) {
            throw new IllegalArgumentException();
        }
        FileLocation loc = (FileLocation)source;
        return this.textService.asHTML(loc.getFile());
    }
}

