/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import process3d.Convolve3d;

public class Smooth {
    public static ImagePlus smooth(ImagePlus image, boolean useGaussian, float sigma, boolean useCalibration) {
        int type = image.getType();
        Calibration calib = image.getCalibration();
        float pixelW = !useCalibration ? 1.0f : (float)Math.abs(calib.pixelWidth);
        float[] H_x = Smooth.createKernel(sigma, pixelW, useGaussian);
        pixelW = !useCalibration ? 1.0f : (float)Math.abs(calib.pixelHeight);
        float[] H_y = Smooth.createKernel(sigma, pixelW, useGaussian);
        pixelW = !useCalibration ? 1.0f : (float)Math.abs(calib.pixelDepth);
        float[] H_z = Smooth.createKernel(sigma, pixelW, useGaussian);
        ImageStack stack = Convolve3d.convolve(image, H_x, H_y, H_z).getStack();
        if (image.getType() == 2) {
            ImagePlus result = new ImagePlus("Smoothed", stack);
            result.setCalibration(image.getCalibration());
            return result;
        }
        ImageStack stack2 = new ImageStack(stack.getWidth(), stack.getHeight());
        for (int z = 0; z < stack.getSize(); ++z) {
            int i;
            float[] f = (float[])stack.getProcessor(z + 1).getPixels();
            if (type == 0) {
                byte[] b = new byte[f.length];
                for (i = 0; i < b.length; ++i) {
                    b[i] = (byte)Math.round(f[i]);
                }
                stack2.addSlice("", (Object)b);
                continue;
            }
            if (type != 1) continue;
            short[] s = new short[f.length];
            for (i = 0; i < s.length; ++i) {
                s[i] = (short)Math.round(f[i]);
            }
            stack2.addSlice("", (Object)s);
        }
        ImagePlus result = new ImagePlus("Smoothed", stack2);
        result.setCalibration(image.getCalibration());
        return result;
    }

    public static float[] createKernel(float sigma, float pixelW, boolean useGaussian) {
        return useGaussian ? Smooth.createGaussianKernel(sigma, pixelW) : Smooth.createUniformKernel(sigma, pixelW);
    }

    public static float[] createUniformKernel(float radius, float pixelW) {
        int diameter = (int)Math.ceil(2.0f * (radius /= pixelW) + 1.0f);
        float[] H = new float[diameter];
        for (int i = 0; i < diameter; ++i) {
            H[i] = 1.0f / (float)diameter;
        }
        return H;
    }

    public static float[] createGaussianKernel(float sigma, float pixelW) {
        int diameter = (int)Math.ceil(5.0f * (sigma /= pixelW));
        diameter = diameter % 2 == 0 ? diameter + 1 : diameter;
        float[] kernel = new float[diameter];
        int radius = diameter / 2;
        float sum = 0.0f;
        kernel[radius] = Smooth.gauss(0.0f, sigma);
        sum += kernel[radius];
        for (int x = 1; x <= radius; ++x) {
            float f = Smooth.gauss(x, sigma);
            kernel[radius + x] = f;
            kernel[radius - x] = f;
            sum += 2.0f * kernel[radius - x];
        }
        int i = 0;
        while (i < diameter) {
            int n = i++;
            kernel[n] = kernel[n] / sum;
        }
        return kernel;
    }

    public static float gauss(float x, float sigma) {
        return (float)Math.exp(-x * x / (2.0f * sigma * sigma));
    }
}

