/*
 * Decompiled with CFR 0.152.
 */
package vib;

import distance.PixelPairs;
import ij.IJ;
import math3d.Bookstein;
import math3d.Point3d;
import vib.FastMatrix;
import vib.InterpolatedImage;

public class ElasticTransformedImage {
    InterpolatedImage orig;
    InterpolatedImage trans;
    FastMatrix fromOrig;
    FastMatrix toTrans;
    Point3d[] origPoints;
    Point3d[] transPoints;
    PixelPairs measure;
    Bookstein b;
    double x;
    double y;
    double z;

    public ElasticTransformedImage(InterpolatedImage orig, InterpolatedImage trans, Point3d[] origPoints, FastMatrix initialTransform) {
        this(orig, trans, origPoints, ElasticTransformedImage.transformPoints(origPoints, initialTransform));
    }

    public ElasticTransformedImage(InterpolatedImage orig, InterpolatedImage trans, Point3d[] origPoints, Point3d[] transPoints) {
        this.orig = orig;
        this.trans = trans;
        this.fromOrig = FastMatrix.fromCalibration(orig.image);
        this.toTrans = FastMatrix.fromCalibration(trans.image).inverse();
        this.origPoints = origPoints;
        this.transPoints = transPoints;
        this.b = new Bookstein(origPoints, transPoints);
    }

    public static Point3d[] transformPoints(Point3d[] origPoints, FastMatrix matrix) {
        Point3d[] transPoints = new Point3d[origPoints.length];
        for (int i = 0; i < origPoints.length; ++i) {
            matrix.apply(origPoints[i]);
            transPoints[i] = matrix.getResult();
        }
        return transPoints;
    }

    void apply(Point3d p) {
        this.b.apply(p);
        this.x = this.b.x;
        this.y = this.b.y;
        this.z = this.b.z;
    }

    void apply(int i, int j, int k) {
        this.fromOrig.apply(i, j, k);
        this.apply(this.fromOrig.getResult());
        this.toTrans.apply(this.x, this.y, this.z);
        this.x = this.toTrans.x;
        this.y = this.toTrans.y;
        this.z = this.toTrans.z;
    }

    InterpolatedImage getTransformed() {
        InterpolatedImage res = this.orig.cloneDimensionsOnly();
        for (int k = 0; k < res.d; ++k) {
            for (int j = 0; j < res.h; ++j) {
                for (int i = 0; i < res.w; ++i) {
                    this.apply(i, j, k);
                    double v = this.trans.interpol.get(this.x, this.y, this.z);
                    res.set(i, j, k, (byte)v);
                }
            }
            IJ.showProgress((int)(k + 1), (int)res.d);
        }
        return res;
    }

    double getDistance() {
        this.measure.reset();
        for (int k = 0; k < this.orig.d; ++k) {
            for (int j = 0; j < this.orig.h; ++j) {
                for (int i = 0; i < this.orig.w; ++i) {
                    double v0 = this.orig.getNoInterpol(i, j, k);
                    this.apply(i, j, k);
                    double v1 = this.trans.interpol.get(this.x, this.y, this.z);
                    this.measure.add((float)v0, (float)v1);
                }
            }
        }
        return this.measure.distance();
    }
}

