/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.datasetmanager;

import ij.ImagePlus;
import ij.io.Opener;
import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.TextFileAccess;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import spim.fiji.datasetmanager.DHM;

public class DHMMetaData {
    File directory;
    double calX;
    double calY;
    double calZ;
    String calUnit;
    boolean compareAllSizes;
    String stackDir = null;
    String ampDir = null;
    String phaseDir = null;
    String holoDir = null;
    String timestampFile = null;
    String extension = null;
    int ampChannelId = 0;
    int phaseChannelId = 1;
    int width = -1;
    int height = -1;
    List<String> zPlanes;
    List<String> timepoints;

    public DHMMetaData(File directory, double calX, double calY, double calZ, String calUnit, boolean compareAllSizes) {
        this.directory = directory;
        this.calX = calX;
        this.calY = calY;
        this.calZ = calZ;
        this.calUnit = calUnit;
        this.compareAllSizes = compareAllSizes;
    }

    public boolean loadMetaData() {
        if (!this.checkIntegrity(this.directory)) {
            return false;
        }
        IOFunctions.println("Stack directory: ./" + this.stackDir);
        IOFunctions.println("Amplitude directory: ./" + this.stackDir + "/" + this.ampDir);
        IOFunctions.println("Phase directory: ./" + this.stackDir + "/" + this.phaseDir);
        if (!this.parseTimestamps(this.directory, this.timestampFile)) {
            IOFunctions.println("Failed to parse timestamp file.");
        }
        if (!this.getTimestampsAndZPlanes(this.compareAllSizes)) {
            return false;
        }
        IOFunctions.println("Final timepoints available for all zPlanes in Phase & Amplitude:");
        for (String t : this.timepoints) {
            IOFunctions.println(t);
        }
        IOFunctions.println("Final zPlanes available in Phase & Amplitude:");
        for (String z : this.zPlanes) {
            IOFunctions.println(z);
        }
        IOFunctions.println("imgX: " + this.width + "px");
        IOFunctions.println("imgY: " + this.height + "px");
        IOFunctions.println("imgZ: " + this.getDepth() + "px");
        IOFunctions.println("calX: " + this.calX + " " + this.calUnit);
        IOFunctions.println("calY: " + this.calY + " " + this.calUnit);
        IOFunctions.println("calZ: " + this.calZ + " " + this.calUnit);
        IOFunctions.println("anisotropy: " + this.calZ / Math.min(this.calX, this.calY) + "X ");
        IOFunctions.println("image plane extension: " + this.extension);
        return true;
    }

    public File getDir() {
        return this.directory;
    }

    public String getStackDir() {
        return this.stackDir;
    }

    public String getAmplitudeDir() {
        return this.ampDir;
    }

    public String getPhaseDir() {
        return this.phaseDir;
    }

    public List<String> getZPlanes() {
        return this.zPlanes;
    }

    public List<String> getTimepoints() {
        return this.timepoints;
    }

    public int getAmpChannelId() {
        return this.ampChannelId;
    }

    public int getPhaseChannelId() {
        return this.phaseChannelId;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.zPlanes.size();
    }

    public String getExt() {
        return this.extension;
    }

    public boolean getTimestampsAndZPlanes(boolean compareAllSizes) {
        File ampDir = new File(new File(this.directory.getAbsolutePath(), this.stackDir).getAbsolutePath(), this.ampDir);
        File phaseDir = new File(new File(this.directory.getAbsolutePath(), this.stackDir).getAbsolutePath(), this.phaseDir);
        if (this.timepoints == null) {
            IOFunctions.println("timestamps not know, loading from amplitude directory at z=0.00");
            Pair<List<String>, String> tps = DHMMetaData.loadTimepoints(new File(ampDir.getAbsolutePath(), "0.00"));
            if (tps == null) {
                return false;
            }
            this.timepoints = (List)tps.getA();
            IOFunctions.println("Following timepoints found:");
            for (String t : this.timepoints) {
                IOFunctions.println(t);
            }
            IOFunctions.println("Extension: " + (String)tps.getB());
        }
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(ampDir);
        dirs.add(phaseDir);
        HashMap<String, Integer> zPlanes = new HashMap<String, Integer>();
        this.width = -1;
        this.height = -1;
        this.extension = null;
        Opener opener = new Opener();
        for (File dir : dirs) {
            for (String d : dir.list()) {
                File planeDir = new File(dir, d);
                if (!planeDir.exists() || !planeDir.isDirectory() || !d.matches("-?[0-9]+\\.[0-9]+")) continue;
                Pair<List<String>, String> tps = DHMMetaData.loadTimepoints(planeDir);
                if (tps == null) {
                    return false;
                }
                if (this.width == -1 && this.height == -1) {
                    File imgF = new File(planeDir.getAbsolutePath(), (String)((List)tps.getA()).get(0) + (String)tps.getB());
                    ImagePlus imp = opener.openImage(imgF.getAbsolutePath());
                    this.width = imp.getWidth();
                    this.height = imp.getHeight();
                    imp.close();
                    IOFunctions.println("Dimensions of plane image loaded from '" + imgF + "':" + this.width + "x" + this.height + "px.");
                }
                if (compareAllSizes) {
                    for (String imgN : (List)tps.getA()) {
                        File imgF = new File(planeDir.getAbsolutePath(), imgN + (String)tps.getB());
                        ImagePlus imp = opener.openImage(imgF.getAbsolutePath());
                        int w = imp.getWidth();
                        int h = imp.getHeight();
                        imp.close();
                        if (w == this.width && h == this.height) continue;
                        IOFunctions.println("Dimensions for image '" + imgF + "' do not match: " + w + "x" + h + "px, before was " + this.width + "x" + this.height + "px. Stopping.");
                        return false;
                    }
                }
                if (this.extension == null) {
                    this.extension = (String)tps.getB();
                }
                if (!this.extension.equals(tps.getB())) {
                    IOFunctions.println("Extension of filenames is not consistent. Was before '" + this.extension + "', now is '" + (String)tps.getB() + "'. Stopping");
                    return false;
                }
                if (((List)tps.getA()).size() != this.timepoints.size()) {
                    IOFunctions.println("Different amount of timepoints (" + ((List)tps.getA()).size() + ") for dir: " + planeDir);
                }
                int size = this.timepoints.size();
                this.timepoints = DHMMetaData.commonStrings(this.timepoints, (List)tps.getA());
                if (size != this.timepoints.size()) {
                    IOFunctions.println("Common amount of timepoints is now: " + this.timepoints.size());
                }
                if (zPlanes.containsKey(d)) {
                    int i = (Integer)zPlanes.get(d);
                    zPlanes.put(d, i + 1);
                    continue;
                }
                zPlanes.put(d, 1);
            }
        }
        this.zPlanes = new ArrayList<String>();
        for (String z : zPlanes.keySet()) {
            if ((Integer)zPlanes.get(z) != 2) {
                IOFunctions.println("zPlane '' exists " + zPlanes.get(z) + " times, this is wrong!");
                continue;
            }
            this.zPlanes.add(z);
        }
        Collections.sort(this.zPlanes, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                double d = Double.parseDouble(o1) - Double.parseDouble(o2);
                if (d < 0.0) {
                    return -1;
                }
                if (d > 0.0) {
                    return 1;
                }
                return 0;
            }
        });
        return true;
    }

    public static List<String> commonStrings(List<String> listA, List<String> listB) {
        HashSet<String> setA = new HashSet<String>();
        HashSet<String> setB = new HashSet<String>();
        HashSet<String> setC = new HashSet<String>();
        setA.addAll(listA);
        setB.addAll(listB);
        for (String a : listA) {
            if (!setB.contains(a)) continue;
            setC.add(a);
        }
        for (String b : listB) {
            if (!setA.contains(b)) continue;
            setC.add(b);
        }
        ArrayList<String> listC = new ArrayList<String>();
        listC.addAll(setC);
        Collections.sort(listC);
        return listC;
    }

    public static Pair<List<String>, String> loadTimepoints(File dataDir) {
        if (!dataDir.exists()) {
            IOFunctions.println(dataDir.getAbsolutePath() + " does not exist");
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String regex = "^[0-9]+\\.[tifTIF]+";
        Object[] files = dataDir.list();
        Arrays.sort(files);
        String extension = null;
        for (Object t : files) {
            if (!((String)t).matches("^[0-9]+\\.[tifTIF]+")) continue;
            list.add(((String)t).split("\\.")[0]);
            String ext = ((String)t).substring(((String)t).indexOf("."), ((String)t).length());
            if (extension == null) {
                extension = ext;
                continue;
            }
            if (ext.equals(extension)) continue;
            IOFunctions.println("Extension of filenames is not consistent. Was before '" + extension + "', now is '" + ext + "'. Stopping");
            return null;
        }
        return new ValuePair(list, extension);
    }

    public boolean parseTimestamps(File directory, String timestampFile) {
        if (timestampFile == null) {
            return false;
        }
        File t = new File(directory.getAbsolutePath(), timestampFile);
        if (!t.exists()) {
            return false;
        }
        BufferedReader in = TextFileAccess.openFileRead(t);
        try {
            this.timepoints = new ArrayList<String>();
            IOFunctions.println("Following timepoints specified in timestamps.txt:");
            while (in.ready()) {
                String s = in.readLine().trim();
                if (s.length() <= 0) continue;
                String[] entries = s.split(" ");
                this.timepoints.add(entries[0]);
                IOFunctions.println(this.timepoints.get(this.timepoints.size() - 1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.timepoints = null;
            return false;
        }
        return true;
    }

    public boolean checkIntegrity(File directory) {
        String[] files;
        if (!directory.exists()) {
            IOFunctions.println("File '" + directory.getAbsolutePath() + "' does not exist. Stopping");
            return false;
        }
        IOFunctions.println("Investigating directory '" + directory.getAbsolutePath() + "'.");
        for (String f : files = directory.list()) {
            if (f.toLowerCase().equals("stack")) {
                this.stackDir = f;
                continue;
            }
            if (f.toLowerCase().equals("holograms")) {
                this.holoDir = f;
                continue;
            }
            if (!f.toLowerCase().equals("timestamps.txt")) continue;
            this.timestampFile = f;
        }
        if (this.holoDir == null) {
            IOFunctions.println("WARNING: Holograms-Directory does not exist. Continuing.");
        }
        if (this.timestampFile == null) {
            IOFunctions.println("WARNING: Timestamps.txt file missing. Continuing.");
        }
        if (this.stackDir == null) {
            IOFunctions.println("Stack-Directory does not exist. Stopping");
            return false;
        }
        for (String f : files = new File(directory.getAbsolutePath(), this.stackDir).list()) {
            if (f.toLowerCase().equals("amplitude")) {
                this.ampDir = f;
                continue;
            }
            if (!f.toLowerCase().equals("phase")) continue;
            this.phaseDir = f;
        }
        if (this.ampDir == null) {
            IOFunctions.println("Amplitude-Stack-Directory does not exist. Stopping");
            return false;
        }
        if (this.phaseDir == null) {
            IOFunctions.println("Phase-Stack-Directory does not exist. Stopping");
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        new DHMMetaData(new File("/Users/preibischs/Downloads/2015.07.10 17-25_Ser_r"), DHM.defaulCalX, DHM.defaulCalY, DHM.defaulCalZ, DHM.defaulCalUnit, false).loadMetaData();
    }
}

