/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.weights;

import ij.ImageJ;
import ij.ImagePlus;
import net.imglib2.Cursor;
import net.imglib2.EuclideanSpace;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.algorithm.fft2.FFTConvolution;
import net.imglib2.converter.Converter;
import net.imglib2.converter.RealFloatConverter;
import net.imglib2.converter.read.ConvertedRandomAccessibleInterval;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import spim.process.fusion.FusionHelper;

public class ContentBased<T extends RealType<T>>
implements RealRandomAccessible<FloatType> {
    final Img<FloatType> contentBasedImg;
    final int n;

    public ContentBased(RandomAccessibleInterval<T> input, ImgFactory<ComplexFloatType> imgFactory, double[] sigma1, double[] sigma2) {
        this.n = input.numDimensions();
        this.contentBasedImg = this.approximateEntropy((RandomAccessibleInterval<FloatType>)new ConvertedRandomAccessibleInterval(input, (Converter)new RealFloatConverter(), FloatType::new), imgFactory, sigma1, sigma2);
    }

    public Img<FloatType> getContentBasedImg() {
        return this.contentBasedImg;
    }

    protected Img<FloatType> approximateEntropy(RandomAccessibleInterval<FloatType> input, ImgFactory<ComplexFloatType> imgFactory, double[] sigma1, double[] sigma2) {
        ImgFactory f;
        try {
            f = imgFactory.imgFactory((Object)new FloatType());
        }
        catch (IncompatibleTypeException e) {
            f = new ArrayImgFactory();
        }
        Img conv = f.create(input, (Object)new FloatType());
        FFTConvolution fftConv = new FFTConvolution(input, ContentBased.createGaussianKernel(sigma1), (RandomAccessibleInterval)conv, imgFactory);
        fftConv.convolve();
        Cursor c = conv.cursor();
        RandomAccess r = input.randomAccess();
        while (c.hasNext()) {
            c.fwd();
            r.setPosition((Localizable)c);
            float diff = ((FloatType)c.get()).get() - ((FloatType)r.get()).get();
            ((FloatType)c.get()).set(diff * diff);
        }
        fftConv = new FFTConvolution((RandomAccessibleInterval)conv, ContentBased.createGaussianKernel(sigma2), imgFactory);
        fftConv.convolve();
        FusionHelper.normalizeImage((RandomAccessibleInterval<FloatType>)conv);
        return conv;
    }

    public int numDimensions() {
        return this.contentBasedImg.numDimensions();
    }

    public RealRandomAccess<FloatType> realRandomAccess() {
        return Views.interpolate((EuclideanSpace)Views.extendZero(this.contentBasedImg), (InterpolatorFactory)new NLinearInterpolatorFactory()).realRandomAccess();
    }

    public RealRandomAccess<FloatType> realRandomAccess(RealInterval interval) {
        return Views.interpolate((EuclideanSpace)Views.extendZero(this.contentBasedImg), (InterpolatorFactory)new NLinearInterpolatorFactory()).realRandomAccess(interval);
    }

    public FloatType getType() {
        return new FloatType();
    }

    private static final Img<FloatType> createGaussianKernel(double[] sigmas) {
        int numDimensions = sigmas.length;
        long[] imageSize = new long[numDimensions];
        double[][] kernel = new double[numDimensions][];
        for (int d = 0; d < numDimensions; ++d) {
            kernel[d] = Util.createGaussianKernel1DDouble((double)sigmas[d], (boolean)true);
            imageSize[d] = kernel[d].length;
        }
        ArrayImg kernelImg = ArrayImgs.floats((long[])imageSize);
        Cursor cursor = kernelImg.localizingCursor();
        int[] position = new int[numDimensions];
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(position);
            double value = 1.0;
            for (int d = 0; d < numDimensions; ++d) {
                value *= kernel[d][position[d]];
            }
            ((FloatType)cursor.get()).set((float)value);
        }
        return kernelImg;
    }

    public static void main(String[] args) throws IncompatibleTypeException {
        new ImageJ();
        ImagePlus imp = new ImagePlus("/Users/preibischs/workspace/TestLucyRichardson/src/resources/dros-1.tif");
        Img img = ImageJFunctions.wrap((ImagePlus)imp);
        double[] sigma1 = new double[]{20.0, 20.0};
        double[] sigma2 = new double[]{30.0, 30.0};
        ContentBased cb = new ContentBased(img, (ImgFactory<ComplexFloatType>)img.factory().imgFactory((Object)new ComplexFloatType()), sigma1, sigma2);
        ImageJFunctions.show(cb.getContentBasedImg());
    }
}

