/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.DefaultImageMetadata;
import io.scif.FormatException;
import io.scif.HasColorTable;
import io.scif.Metadata;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.AbstractMetadataWrapper;
import io.scif.filters.ChannelFiller;
import io.scif.filters.Filter;
import io.scif.filters.ReaderFilter;
import io.scif.services.InitializeService;
import io.scif.util.FormatTools;
import java.io.IOException;
import net.imagej.axis.Axes;
import net.imglib2.display.ArrayColorTable;
import net.imglib2.display.ColorTable;
import org.scijava.plugin.Parameter;

public class ChannelFillerMetadata
extends AbstractMetadataWrapper {
    @Parameter
    private InitializeService initializeService;
    private int lutLength;

    public int getLutLength() {
        return this.lutLength;
    }

    @Override
    public void populateImageMetadata() {
        Metadata m = this.unwrap();
        this.createImageMetadata(0);
        for (int i = 0; i < m.getImageCount(); ++i) {
            DefaultImageMetadata iMeta = new DefaultImageMetadata(m.get(i));
            if (m.get(i).isIndexed()) {
                iMeta.setIndexed(false);
                ColorTable cTable = null;
                if (HasColorTable.class.isAssignableFrom(m.getClass())) {
                    cTable = ((HasColorTable)((Object)m)).getColorTable(i, 0L);
                } else {
                    ReaderFilter r = null;
                    try {
                        r = this.initializeService.initializeReader(m.getSourceLocation(), new SCIFIOConfig(this.getContext()).checkerSetOpen(true));
                        cTable = r.openPlane(0, 0L).getColorTable();
                        r.close();
                    }
                    catch (FormatException e) {
                        throw new IllegalArgumentException("ChannelFiller failed, could not open ColorTable for an indexed dataset", e);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("ChannelFiller failed, could not open ColorTable for an indexed dataset", e);
                    }
                }
                if (cTable == null) {
                    this.lutLength = 1;
                } else {
                    this.lutLength = cTable.getComponentCount();
                    if (ArrayColorTable.class.isAssignableFrom(cTable.getClass())) {
                        int bitsPerElement = ((ArrayColorTable)cTable).getBits();
                        boolean signed = FormatTools.isSigned(iMeta.getPixelType());
                        boolean floating = FormatTools.isFloatingPoint(iMeta.getPixelType());
                        try {
                            iMeta.setPixelType(FormatTools.pixelTypeFromBytes(bitsPerElement / 8, signed, floating));
                        }
                        catch (FormatException e) {
                            this.log().warn((Object)"Could not update pixel type of ChannelFiller metadata.");
                        }
                    }
                }
                if (!iMeta.isFalseColor()) {
                    int cIndex = iMeta.getAxisIndex(Axes.CHANNEL);
                    if (cIndex >= 0 && cIndex < iMeta.getPlanarAxisCount()) {
                        iMeta.setAxisLength(Axes.CHANNEL, iMeta.getAxisLength(Axes.CHANNEL) * (long)this.lutLength);
                    } else {
                        if (cIndex >= 0) {
                            iMeta.setAxisType(cIndex, Axes.unknown());
                        }
                        iMeta.addAxis(Axes.CHANNEL, (long)this.lutLength);
                        iMeta.setAxis(iMeta.getPlanarAxisCount(), iMeta.getAxis(Axes.CHANNEL));
                        iMeta.setPlanarAxisCount(iMeta.getPlanarAxisCount() + 1);
                    }
                }
            }
            this.add(iMeta, false);
        }
    }

    @Override
    public Class<? extends Filter> filterType() {
        return ChannelFiller.class;
    }
}

