/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell.loaders;

import io.scif.ImageMetadata;
import io.scif.Reader;
import io.scif.img.ImageRegion;
import io.scif.img.cell.loaders.AbstractArrayLoader;
import io.scif.util.FormatTools;
import java.util.function.IntFunction;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.type.numeric.integer.GenericByteType;

public class ByteAccessLoader
extends AbstractArrayLoader<ByteAccess> {
    private final IntFunction<ByteAccess> accessFactory;

    public ByteAccessLoader(Reader reader, ImageRegion subRegion, IntFunction<ByteAccess> accessFactory) {
        super(reader, subRegion);
        this.accessFactory = accessFactory;
    }

    @Override
    public void convertBytes(ByteAccess data, byte[] bytes, int planesRead) {
        if (this.isCompatible()) {
            int offset = planesRead * bytes.length;
            int i = 0;
            int k = offset;
            while (i < bytes.length) {
                data.setValue(k, bytes[i]);
                ++i;
                ++k;
            }
        } else {
            ImageMetadata iMeta = this.reader().getMetadata().get(0);
            int pixelType = iMeta.getPixelType();
            int bpp = FormatTools.getBytesPerPixel(pixelType);
            int offset = planesRead * (bytes.length / bpp);
            for (int index = 0; index < bytes.length / bpp; ++index) {
                byte value = (byte)this.utils().decodeWord(bytes, index * bpp, pixelType, iMeta.isLittleEndian());
                data.setValue(offset + index, value);
            }
        }
    }

    @Override
    public ByteAccess emptyArray(int entities) {
        return this.accessFactory.apply(entities);
    }

    @Override
    public int getBitsPerElement() {
        return 8;
    }

    @Override
    public Class<?> outputClass() {
        return GenericByteType.class;
    }
}

