/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import java.util.ArrayList;
import java.util.List;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Intervals;

class ScreenScales {
    private final double targetRenderNanos;
    private final List<ScreenScale> screenScales;
    private int screenW = 0;
    private int screenH = 0;

    public ScreenScales(double[] screenScaleFactors, double targetRenderNanos) {
        this.targetRenderNanos = targetRenderNanos;
        this.screenScales = new ArrayList<ScreenScale>();
        for (double scale : screenScaleFactors) {
            this.screenScales.add(new ScreenScale(scale));
        }
    }

    public boolean checkResize(int newScreenW, int newScreenH) {
        if (newScreenW != this.screenW || newScreenH != this.screenH) {
            this.screenW = newScreenW;
            this.screenH = newScreenH;
            this.screenScales.forEach(s -> s.resize(this.screenW, this.screenH));
            return true;
        }
        return false;
    }

    public ScreenScale get(int index) {
        return this.screenScales.get(index);
    }

    public int size() {
        return this.screenScales.size();
    }

    public int suggestScreenScale(double renderNanosPerPixel) {
        for (int i = 0; i < this.screenScales.size() - 1; ++i) {
            double renderTime = this.screenScales.get(i).estimateRenderNanos(renderNanosPerPixel);
            if (!(renderTime <= this.targetRenderNanos)) continue;
            return i;
        }
        return this.screenScales.size() - 1;
    }

    public int suggestIntervalScreenScale(double renderNanosPerPixel, int minScreenScaleIndex) {
        for (int i = minScreenScaleIndex; i < this.screenScales.size() - 1; ++i) {
            double renderTime = this.screenScales.get(i).estimateIntervalRenderNanos(renderNanosPerPixel);
            if (!(renderTime <= this.targetRenderNanos)) continue;
            return i;
        }
        return this.screenScales.size() - 1;
    }

    public Interval clipToScreen(Interval interval) {
        return Intervals.createMinMax(Math.max(0L, interval.min(0)), Math.max(0L, interval.min(1)), Math.min((long)(this.screenW - 1), interval.max(0)), Math.min((long)(this.screenH - 1), interval.max(1)));
    }

    public void requestInterval(Interval screenInterval) {
        this.screenScales.forEach(s -> s.requestInterval(screenInterval));
    }

    public void clearRequestedIntervals() {
        this.screenScales.forEach(ScreenScale::pullScreenInterval);
    }

    public IntervalRenderData pullIntervalRenderData(int intervalScaleIndex, int targetScaleIndex) {
        return new IntervalRenderData(intervalScaleIndex, targetScaleIndex);
    }

    class IntervalRenderData {
        private final int renderScaleIndex;
        private final Interval renderInterval;
        private final Interval targetInterval;
        private final double tx;
        private final double ty;
        private final Interval[] screenIntervals;

        public IntervalRenderData(int renderScaleIndex, int targetScaleIndex) {
            this.renderScaleIndex = renderScaleIndex;
            this.screenIntervals = new Interval[ScreenScales.this.size()];
            for (int i = renderScaleIndex; i < this.screenIntervals.length; ++i) {
                this.screenIntervals[i] = ScreenScales.this.get(i).pullScreenInterval();
            }
            Interval screenInterval = this.screenIntervals[renderScaleIndex];
            ScreenScale renderScale = ScreenScales.this.get(renderScaleIndex);
            this.renderInterval = renderScale.scaleScreenInterval(screenInterval);
            ScreenScale targetScale = ScreenScales.this.get(targetScaleIndex);
            this.targetInterval = targetScale.scaleScreenInterval(screenInterval);
            double relativeScale = targetScale.scale() / renderScale.scale();
            this.tx = (double)this.renderInterval.min(0) * relativeScale;
            this.ty = (double)this.renderInterval.min(1) * relativeScale;
        }

        public void reRequest() {
            for (int i = this.renderScaleIndex; i < this.screenIntervals.length; ++i) {
                Interval interval = this.screenIntervals[i];
                if (interval == null) continue;
                ScreenScales.this.get(i).requestInterval(interval);
            }
        }

        public int width() {
            return (int)this.renderInterval.dimension(0);
        }

        public int height() {
            return (int)this.renderInterval.dimension(1);
        }

        public int offsetX() {
            return (int)this.renderInterval.min(0);
        }

        public int offsetY() {
            return (int)this.renderInterval.min(1);
        }

        public double scale() {
            return ScreenScales.this.get(this.renderScaleIndex).scale();
        }

        public Interval targetInterval() {
            return this.targetInterval;
        }

        public double tx() {
            return this.tx;
        }

        public double ty() {
            return this.ty;
        }
    }

    static class ScreenScale {
        private final double scale;
        private int w = 0;
        private int h = 0;
        private final AffineTransform3D scaleTransform = new AffineTransform3D();
        private Interval requestedScreenInterval = null;

        ScreenScale(double scale) {
            this.scale = scale;
            this.scaleTransform.set(scale, 0, 0);
            this.scaleTransform.set(scale, 1, 1);
            this.scaleTransform.set(0.5 * scale - 0.5, 0, 3);
            this.scaleTransform.set(0.5 * scale - 0.5, 1, 3);
        }

        public void requestInterval(Interval screenInterval) {
            this.requestedScreenInterval = this.requestedScreenInterval == null ? screenInterval : Intervals.union(this.requestedScreenInterval, screenInterval);
        }

        public Interval pullScreenInterval() {
            Interval interval = this.requestedScreenInterval;
            this.requestedScreenInterval = null;
            return interval;
        }

        void resize(int screenW, int screenH) {
            this.w = (int)Math.ceil(this.scale * (double)screenW);
            this.h = (int)Math.ceil(this.scale * (double)screenH);
            this.requestedScreenInterval = null;
        }

        double estimateRenderNanos(double renderNanosPerPixel) {
            return renderNanosPerPixel * (double)this.w * (double)this.h;
        }

        double estimateIntervalRenderNanos(double renderNanosPerPixel) {
            return renderNanosPerPixel * (double)Intervals.numElements(this.scaleScreenInterval(this.requestedScreenInterval));
        }

        Interval scaleScreenInterval(Interval requestedScreenInterval) {
            return Intervals.createMinMax(Math.max(0, (int)Math.floor((double)requestedScreenInterval.min(0) * this.scale)), Math.max(0, (int)Math.floor((double)requestedScreenInterval.min(1) * this.scale)), Math.min(this.w - 1, (int)Math.ceil((double)requestedScreenInterval.max(0) * this.scale)), Math.min(this.h - 1, (int)Math.ceil((double)requestedScreenInterval.max(1) * this.scale)));
        }

        public int width() {
            return this.w;
        }

        public int height() {
            return this.h;
        }

        public double scale() {
            return this.scale;
        }

        public AffineTransform3D scaleTransform() {
            return this.scaleTransform;
        }
    }
}

