/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations;

import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AbstractParametrizedTransform;

public abstract class AbstractParametrizedRealFieldTransform<T extends RealTransform, P, V extends NumericType<V>>
extends AbstractParametrizedTransform<T, RealRandomAccessible<V>[]> {
    protected transient RealRandomAccessible<V>[] fields;
    protected int vectorAxisIndex;

    public AbstractParametrizedRealFieldTransform(String type, String name, String inputSpace, String outputSpace) {
        this(type, name, null, inputSpace, outputSpace);
    }

    public AbstractParametrizedRealFieldTransform(String type, String name, String parameterPath, String inputSpace, String outputSpace) {
        super(type, name, inputSpace, outputSpace);
    }

    public int getVectorAxisIndex() {
        return this.vectorAxisIndex;
    }

    public abstract int parseVectorAxisIndex(N5Reader var1);

    public RealRandomAccessible<V>[] getFields() {
        return this.fields;
    }

    @Override
    public RealRandomAccessible<V>[] getParameters(N5Reader n5) {
        this.vectorAxisIndex = this.parseVectorAxisIndex(n5);
        try {
            CachedCellImg fieldRaw = N5Utils.open((N5Reader)n5, (String)this.getParameterPath());
            int nv = (int)fieldRaw.dimension(this.getVectorAxisIndex());
            this.fields = new RealRandomAccessible[nv];
            for (int i = 0; i < nv; ++i) {
                this.fields[i] = Views.interpolate((EuclideanSpace)Views.extendBorder((RandomAccessibleInterval)fieldRaw), (InterpolatorFactory)new NLinearInterpolatorFactory());
            }
            return this.fields;
        }
        catch (N5Exception n5Exception) {
            return null;
        }
    }
}

