/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.vector;

public class Util {
    public static final double[] copy(double[] a, int new_length) {
        double[] b = new double[new_length];
        int len = a.length > new_length ? new_length : a.length;
        System.arraycopy(a, 0, b, 0, len);
        return b;
    }

    public static final double[] copy(double[] a, int first, int new_length) {
        double[] b = new double[new_length];
        int len = new_length < a.length - first ? new_length : a.length - first;
        System.arraycopy(a, first, b, 0, len);
        return b;
    }

    public static final double getAngle(double x, double y) {
        double a = Math.atan2(x, y);
        if (a > Math.PI * 2) {
            a -= Math.PI * 2;
        }
        if (a >= 0.0 && a <= 1.5707963267948966) {
            a = 1.5707963267948966 - a;
        } else if (a < 0.0 && a >= -Math.PI) {
            a = 1.5707963267948966 - a;
        } else if (a > 1.5707963267948966 && a <= Math.PI) {
            a = 7.853981633974483 - a;
        }
        return a;
    }

    public static final void reverse(double[] a) {
        int left = 0;
        for (int right = a.length - 1; left < right; ++left, --right) {
            double tmp = a[left];
            a[left] = a[right];
            a[right] = tmp;
        }
    }

    public static final void convolveGaussianSigma1(double[] in, double[] out, CircularSequence seq) {
        int i;
        double w2 = 0.05448869;
        double w1 = 0.24420134;
        double w0 = 0.40261994;
        for (int i2 = 0; i2 < 2; ++i2) {
            out[i2] = in[seq.setPosition(i2 - 2)] * 0.05448869 + in[seq.setPosition(i2 - 1)] * 0.24420134 + in[seq.setPosition(i2)] * 0.40261994 + in[seq.setPosition(i2 + 1)] * 0.24420134 + in[seq.setPosition(i2 + 2)] * 0.05448869;
        }
        int cut = out.length - 2;
        for (i = 2; i < cut; ++i) {
            out[i] = in[i - 2] * 0.05448869 + in[i - 1] * 0.24420134 + in[i] * 0.40261994 + in[i + 1] * 0.24420134 + in[i + 2] * 0.05448869;
        }
        for (i = cut; i < out.length; ++i) {
            out[i] = in[seq.setPosition(i - 2)] * 0.05448869 + in[seq.setPosition(i - 1)] * 0.24420134 + in[seq.setPosition(i)] * 0.40261994 + in[seq.setPosition(i + 1)] * 0.24420134 + in[seq.setPosition(i + 2)] * 0.05448869;
        }
    }

    public static final DoublePolygon createInterpolatedPolygon(DoublePolygon p, double interval, boolean isLine) {
        double length = p.computeLength(isLine);
        int npoints2 = (int)(length * 1.2 / interval);
        double[] xpoints2 = new double[npoints2];
        double[] ypoints2 = new double[npoints2];
        xpoints2[0] = p.xpoints[0];
        ypoints2[0] = p.ypoints[0];
        int n = 1;
        double inc = 0.01;
        double distance = 0.0;
        double distance2 = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        double x2 = p.xpoints[0];
        double y2 = p.ypoints[0];
        int npoints = p.npoints;
        if (!isLine) {
            ++npoints;
        }
        for (int i = 1; i < npoints; ++i) {
            double x1 = x2;
            double y1 = y2;
            double x = x1;
            double y = y1;
            if (i < p.npoints) {
                x2 = p.xpoints[i];
                y2 = p.ypoints[i];
            } else {
                x2 = p.xpoints[0];
                y2 = p.ypoints[0];
            }
            dx = x2 - x1;
            dy = y2 - y1;
            distance = Math.sqrt(dx * dx + dy * dy);
            double xinc = dx * inc / distance;
            double yinc = dy * inc / distance;
            double lastx = xpoints2[n - 1];
            double lasty = ypoints2[n - 1];
            int n2 = (int)(distance / inc);
            if (npoints == 2) {
                ++n2;
            }
            do {
                if ((distance2 = Math.sqrt((dx = x - lastx) * dx + (dy = y - lasty) * dy)) >= interval - inc / 2.0 && n < xpoints2.length - 1) {
                    xpoints2[n] = (float)x;
                    ypoints2[n] = (float)y;
                    ++n;
                    lastx = x;
                    lasty = y;
                }
                x += xinc;
                y += yinc;
            } while (--n2 > 0);
        }
        return new DoublePolygon(xpoints2, ypoints2, n);
    }

    static final class DoublePolygon {
        final double[] xpoints;
        final double[] ypoints;
        final int npoints;

        public DoublePolygon(double[] xpoints, double[] ypoints, int npoints) {
            this.xpoints = xpoints;
            this.ypoints = ypoints;
            this.npoints = npoints;
        }

        public double computeLength(boolean isLine) {
            double dy;
            double dx;
            double length = 0.0;
            for (int i = 0; i < this.npoints - 1; ++i) {
                dx = this.xpoints[i + 1] - this.xpoints[i];
                dy = this.ypoints[i + 1] - this.ypoints[i];
                length += Math.sqrt(dx * dx + dy * dy);
            }
            if (!isLine) {
                dx = this.xpoints[0] - this.xpoints[this.npoints - 1];
                dy = this.ypoints[0] - this.ypoints[this.npoints - 1];
                length += Math.sqrt(dx * dx + dy * dy);
            }
            return length;
        }
    }

    public static final class CircularSequence {
        int i;
        private final int size;

        public CircularSequence(int size) {
            this.size = size;
            this.i = size - 1;
        }

        public final int next() {
            ++this.i;
            this.i %= this.size;
            return this.i;
        }

        public final int previous() {
            --this.i;
            this.i %= this.size;
            return this.i;
        }

        public final int setPosition(int k) {
            this.i = k;
            this.i = this.i < 0 ? this.size - -this.i % this.size : (this.i %= this.size);
            return this.i;
        }

        public final int move(int inc) {
            return this.setPosition(this.i + inc);
        }
    }
}

