/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import vib.MaxEntHistogram;
import vib.ShowHistogram;

public class MaxEntQuantization_
implements PlugInFilter {
    ImagePlus image;

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 1;
    }

    public void run(ImageProcessor ip) {
        ImageStack stack = this.image.getStack();
        GenericDialog gd = new GenericDialog("Maximum Entropy Parameters");
        gd.addNumericField("numberOfBins", 16.0, 0);
        gd.addCheckbox("showIndex", false);
        gd.addCheckbox("useNaive", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int numberOfBins = (int)gd.getNextNumber();
        boolean showIndex = gd.getNextBoolean();
        boolean useNaive = gd.getNextBoolean();
        MaxEntHistogram histogram = new MaxEntHistogram(this.image);
        if (numberOfBins == -7) {
            this.calculateEntropyHistogram(histogram);
            return;
        }
        if (useNaive) {
            histogram.quantizeNaive(numberOfBins);
        } else {
            histogram.quantize(numberOfBins);
        }
        byte[] mapping = histogram.getMapping(showIndex);
        ImageStack res = new ImageStack(stack.getWidth(), stack.getHeight());
        for (int s = 1; s <= stack.getSize(); ++s) {
            res.addSlice("", (ImageProcessor)this.doit(stack.getProcessor(s), mapping));
            IJ.showProgress((double)((double)s / (double)stack.getSize()));
        }
        ImagePlus result = new ImagePlus("Maximum entropy quantized " + this.image.getTitle() + " " + numberOfBins + " bins", res);
        result.setCalibration(this.image.getCalibration());
        result.show();
    }

    private ByteProcessor doit(ImageProcessor ip, byte[] mapping) {
        byte[] pixels = (byte[])ip.getPixels();
        int w = ip.getWidth();
        int h = ip.getHeight();
        byte[] result = new byte[w * h];
        for (int i = 0; i < w * h; ++i) {
            int value = pixels[i];
            if (value < 0) {
                value += 256;
            }
            result[i] = mapping[value];
        }
        return new ByteProcessor(w, h, result, null);
    }

    private void calculateEntropyHistogram(MaxEntHistogram histogram) {
        double[] entropyHistogram = new double[255];
        for (int i = 1; i < 256; ++i) {
            entropyHistogram[i - 1] = histogram.quantize(i);
            System.err.println("Entropy for " + i + ": " + entropyHistogram[i - 1]);
            IJ.showProgress((int)i, (int)255);
        }
        new ShowHistogram(entropyHistogram, 1.0, 1.0);
    }
}

