/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.IJ;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import ini.trakem2.utils.IJError;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class YesNoDialog
extends Dialog
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private Button yesB;
    private Button noB;
    private boolean yesPressed;
    private boolean firstPaint = true;
    private Runnable closing_task = null;

    public YesNoDialog(String title, String msg) {
        this((Frame)IJ.getInstance(), title, msg);
    }

    public YesNoDialog(Frame parent, String title, String msg) {
        this(parent, title, msg, true);
    }

    public YesNoDialog(Frame parent, String title, String msg, boolean show) {
        super(parent, title, true);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 10, 10));
        MultiLineLabel message = new MultiLineLabel(msg);
        message.setFont(new Font("Dialog", 0, 12));
        panel.add((Component)message);
        this.add("North", panel);
        panel = new Panel();
        panel.setLayout(new FlowLayout(2, 15, 8));
        if (IJ.isMacintosh() && msg.startsWith("Save")) {
            this.yesB = new Button("  Save  ");
            this.noB = new Button("Don't Save");
        } else {
            this.yesB = new Button("  Yes  ");
            this.noB = new Button("  No  ");
        }
        this.yesB.addActionListener(this);
        this.noB.addActionListener(this);
        this.yesB.addKeyListener(this);
        this.noB.addKeyListener(this);
        if (IJ.isMacintosh()) {
            panel.add(this.noB);
            panel.add(this.yesB);
            this.setResizable(false);
        } else {
            panel.add(this.yesB);
            panel.add(this.noB);
        }
        this.add("South", panel);
        this.pack();
        GUI.scale((Component)this);
        GUI.center((Window)this);
        if (show) {
            this.setVisible(true);
        }
    }

    public void setClosingTask(Runnable r) {
        this.closing_task = r;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.yesB) {
            this.yesPressed = true;
        }
        this.closeDialog();
    }

    public boolean yesPressed() {
        return this.yesPressed;
    }

    void closeDialog() {
        if (null != this.closing_task) {
            try {
                this.closing_task.run();
            }
            catch (Throwable t) {
                IJError.print(t);
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyDown((int)keyCode);
        if (keyCode != 10 && keyCode != 89 && keyCode != 83 && (keyCode == 78 || keyCode == 68)) {
            this.closeDialog();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        IJ.setKeyUp((int)keyCode);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.firstPaint) {
            this.yesB.requestFocus();
            this.firstPaint = false;
        }
    }
}

