/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging;

import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.MedianCut;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import ini.trakem2.persistence.Loader;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.HashSet;
import java.util.Properties;

public class PatchStack
extends ImagePlus {
    private Patch[] patch;
    private VirtualStack stack;
    private boolean[] called;

    public PatchStack(Patch[] patch, int currentSlice) {
        this.patch = patch;
        this.setSlice(currentSlice);
        Rectangle b = patch[0].getBoundingBox(null);
        this.width = b.width;
        this.height = b.height;
        this.stack = new VirtualStack(this.width, this.height);
        this.ip = null;
        this.changes = false;
        this.called = new boolean[patch.length];
        for (int i = 0; i < patch.length; ++i) {
            this.called[i] = false;
        }
        super.setCalibration(patch[0].getLayer().getParent().getCalibrationCopy());
    }

    public Rectangle getBounds() {
        return this.patch[0].getBoundingBox();
    }

    public boolean contains(Patch p) {
        for (int i = 0; i < this.patch.length; ++i) {
            if (this.patch[i].getId() != p.getId()) continue;
            return true;
        }
        return false;
    }

    public Patch getPatch(Layer layer, Patch p) {
        if (!this.contains(p)) {
            return null;
        }
        long layer_id = layer.getId();
        for (int i = 0; i < this.patch.length; ++i) {
            if (this.patch[i].getLayer().getId() != layer_id) continue;
            return this.patch[i];
        }
        return null;
    }

    public Patch getPatch(int i) {
        if (i < 0 || i > this.patch.length) {
            return null;
        }
        return this.patch[i];
    }

    public Patch getCurrentPatch() {
        return this.patch[this.currentSlice - 1];
    }

    public void setCurrentSlice(Patch p) {
        for (int i = 0; i < this.patch.length; ++i) {
            if (this.patch[i].getId() != p.getId()) continue;
            this.currentSlice = i + 1;
            break;
        }
    }

    public void revert(Patch p) {
        for (int i = 0; i < this.patch.length; ++i) {
            if (this.patch[i].getId() != p.getId()) continue;
            this.revert2(p);
            Display.repaint(p.getLayer(), (Displayable)p, 0);
            break;
        }
    }

    public void revertAll() {
        Utils.showProgress(0.0);
        for (int i = 0; i < this.patch.length; ++i) {
            this.revert2(this.patch[i]);
            Utils.showProgress(((double)i + 1.0) / (double)this.patch.length);
        }
        Utils.showProgress(0.0);
    }

    private void revert2(Patch p) {
    }

    public void resetNonActive() {
        Utils.log2("PatchStack: calling reset");
        Loader loader = this.patch[this.currentSlice - 1].getProject().getLoader();
        for (int i = 0; i < this.patch.length; ++i) {
            if (this.currentSlice - 1 == i || !this.called[i]) continue;
            this.called[i] = false;
            ImagePlus imp = loader.fetchImagePlus(this.patch[i]);
            ImageProcessor ip = imp.getProcessor();
            switch (imp.getType()) {
                case 4: {
                    ip.reset();
                    break;
                }
                case 1: 
                case 2: {
                    ip.resetMinAndMax();
                }
            }
            this.patch[i].setMinAndMax(ip.getMin(), ip.getMax());
            this.patch[i].getProject().getLoader().decacheAWT(this.patch[i].getId());
            Display.repaint(this.patch[i].getLayer(), (Displayable)this.patch[i], null, 0, true);
        }
    }

    public void saveImages() {
        Utils.log2("PatchStack: calling saveImages");
        if (!this.changes) {
            Utils.log2("PatchStack.saveImages: nothing changed.");
            return;
        }
        Loader loader = this.patch[this.currentSlice - 1].getProject().getLoader();
        Utils.showProgress(0.0);
        for (int i = 0; i < this.patch.length; ++i) {
            ImagePlus imp = loader.fetchImagePlus(this.patch[i]);
            Utils.log2("PatchStack.saveImages: patch imp " + i + " has the imp.changes=" + imp.changes + " and the called[i]=" + this.called[i]);
            if (imp.changes || this.called[i]) {
                this.patch[i].updateInDatabase("tiff_working");
                this.patch[i].getProject().getLoader().decache(imp);
                Display.repaint(this.patch[i].getLayer(), (Displayable)this.patch[i], 0);
                imp.changes = false;
                this.called[i] = false;
            }
            Utils.showProgress(((double)i + 1.0) / (double)this.patch.length);
        }
        this.changes = false;
        Utils.showProgress(1.0);
    }

    public void draw() {
        Display.repaint(this.patch[this.currentSlice - 1].getLayer().getParent());
    }

    public void draw(int x, int y, int width, int height) {
        Rectangle r = new Rectangle(x, y, width, height);
        Display.repaint(this.patch[this.currentSlice - 1].getLayer(), r, 0);
    }

    public void updateAndDraw() {
        Utils.log2("PatchStack: calling updateAndDraw");
        if (this.changes) {
            this.saveImages();
            this.changes = false;
        } else {
            Utils.log2("PatchStack.updateAndDraw 'else'");
            this.patch[this.currentSlice - 1].getProject().getLoader().decacheAWT(this.patch[this.currentSlice - 1].getId());
            Display.repaint(this.patch[this.currentSlice - 1].getLayer(), (Displayable)this.patch[this.currentSlice - 1], null, 0, true);
        }
    }

    public void repaintWindow() {
        Display.repaint(this.patch[this.currentSlice - 1].getLayer(), (Displayable)this.patch[this.currentSlice - 1], 0);
    }

    public void updateAndRepaintWindow() {
        Display.repaint(this.patch[this.currentSlice - 1].getLayer(), (Displayable)this.patch[this.currentSlice - 1], 0);
    }

    public void updateImage() {
        Utils.log2("PS: Update image");
        this.patch[this.currentSlice - 1].createImage();
        Display.repaint(this.patch[this.currentSlice - 1].getLayer(), (Displayable)this.patch[this.currentSlice - 1], 0);
    }

    public void hide() {
        Utils.log("PatchStack: can't hide.");
    }

    public void close() {
        Utils.log("PatchStack: can't close.");
    }

    public void show() {
        Utils.log("PatchStack: can't show.");
    }

    public void show(String statusMessage) {
        this.show();
    }

    public void invertLookupTable() {
        Loader loader = this.patch[this.currentSlice - 1].getProject().getLoader();
        ImagePlus imp = loader.fetchImagePlus(this.patch[this.currentSlice - 1]);
        imp.getProcessor().invert();
        Display.repaint(this.patch[this.currentSlice - 1].getLayer(), (Displayable)this.patch[this.currentSlice - 1], 0);
        this.patch[this.currentSlice - 1].updateInDatabase("tiff_working");
        imp.changes = false;
    }

    public Image getImage() {
        return this.patch[this.currentSlice - 1].getProject().getLoader().fetchImage((Patch)this.patch[this.currentSlice - 1]).image;
    }

    public void setImage(Image img) {
        Utils.log("PatchStack: can't setImage");
    }

    public void setProcessor(String title, ImageProcessor ip) {
        if (1 != this.patch.length) {
            return;
        }
        Loader loader = this.patch[this.currentSlice - 1].getProject().getLoader();
        ImagePlus imp = loader.fetchImagePlus(this.patch[this.currentSlice - 1]);
        if (ip.getWidth() != imp.getWidth() || ip.getHeight() != imp.getHeight()) {
            throw new IllegalArgumentException("PatchStack: ip wrong size");
        }
        imp.setProcessor(null, ip);
        this.patch[this.currentSlice - 1].updateInDatabase("tiff_working");
    }

    public void setStack(String title, ImageStack stack) {
        Utils.log("PatchStack: can't setStack");
    }

    public void setFileInfo(FileInfo fi) {
        Utils.log("PatchStack: can't setFileInfo");
    }

    public void setWindow(Window win) {
        Utils.log("PatchStack: can't setWindow");
    }

    public void setColor(Color c) {
        ImagePlus imp = this.patch[this.currentSlice - 1].getProject().getLoader().fetchImagePlus(this.patch[this.currentSlice - 1]);
        imp.getProcessor().setColor(c);
    }

    public boolean isProcessor() {
        return true;
    }

    public ImageProcessor getProcessor() {
        ImagePlus imp = this.patch[this.currentSlice - 1].getProject().getLoader().fetchImagePlus(this.patch[this.currentSlice - 1]);
        ImageProcessor ip = imp.getProcessor();
        if (null != this.roi) {
            imp.setRoi(this.roi);
        }
        this.called[this.currentSlice - 1] = true;
        return ip;
    }

    public synchronized void trimProcessor() {
        if (!this.locked) {
            try {
                ImagePlus imp = this.patch[this.currentSlice - 1].getProject().getLoader().fetchImagePlus(this.patch[this.currentSlice - 1]);
                imp.trimProcessor();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ImageProcessor getMask() {
        ImagePlus imp = this.patch[this.currentSlice - 1].getProject().getLoader().fetchImagePlus(this.patch[this.currentSlice - 1]);
        ImageProcessor ip = imp.getProcessor();
        Roi roi = this.getRoi();
        if (null == roi) {
            ip.resetRoi();
            return null;
        }
        ImageProcessor mask = roi.getMask();
        if (null == mask) {
            return null;
        }
        ip.setMask(mask);
        ip.setRoi(roi.getBounds());
        return mask;
    }

    public ImageStatistics getStatistics(int nOptions, int nBins, double histMin, double histMax) {
        ImagePlus imp = this.patch[this.currentSlice - 1].getProject().getLoader().fetchImagePlus(this.patch[this.currentSlice - 1]);
        if (null != this.roi) {
            imp.setRoi(this.roi);
        }
        return imp.getStatistics(nOptions, nBins, histMin, histMax);
    }

    public String getTitle() {
        return this.patch[this.currentSlice - 1].getTitle();
    }

    public void setTitle(String title) {
        this.patch[this.currentSlice - 1].setTitle(title);
    }

    public int getStackSize() {
        return this.patch.length;
    }

    public void setDimensions(int nChannels, int nSlices, int nFrames) {
        Utils.log("PatchStack: Can't setDimensions.");
    }

    public int getNChannels() {
        return 1;
    }

    public int getNSlices() {
        return this.patch.length;
    }

    public int getNFrames() {
        return 1;
    }

    public int[] getDimensions() {
        return new int[]{this.width, this.height, 1, this.patch.length, 1};
    }

    public int getType() {
        return this.patch[this.currentSlice - 1].getType();
    }

    public int getBitDepth() {
        int type = this.getType();
        switch (type) {
            case 0: 
            case 3: {
                return 8;
            }
            case 1: {
                return 16;
            }
            case 2: {
                return 32;
            }
            case 4: {
                return 24;
            }
        }
        return 8;
    }

    protected void setType(int type) {
        Utils.log("PatchStack: Can't set type");
    }

    public void setProperty(String key, Object value) {
        ImagePlus imp = this.patch[this.currentSlice - 1].getProject().getLoader().fetchImagePlus(this.patch[this.currentSlice - 1]);
        imp.setProperty(key, value);
        this.patch[this.currentSlice - 1].updateInDatabase("tiff_working");
    }

    public Object getProperty(String key) {
        ImagePlus imp = this.patch[this.currentSlice - 1].getProject().getLoader().fetchImagePlus(this.patch[this.currentSlice - 1]);
        return imp.getProperty(key);
    }

    public Properties getProperties() {
        ImagePlus imp = this.patch[this.currentSlice - 1].getProject().getLoader().fetchImagePlus(this.patch[this.currentSlice - 1]);
        return imp.getProperties();
    }

    public LookUpTable createLut() {
        Image awt = this.patch[this.currentSlice - 1].getProject().getLoader().fetchImage((Patch)this.patch[this.currentSlice - 1]).image;
        return new LookUpTable(awt);
    }

    public boolean isInvertedLut() {
        ImagePlus imp = this.patch[this.currentSlice - 1].getProject().getLoader().fetchImagePlus(this.patch[this.currentSlice - 1]);
        return imp.getProcessor().isInvertedLut();
    }

    public int[] getPixel(int x, int y) {
        try {
            double mag = Display.getFront().getCanvas().getMagnification();
            return this.patch[this.currentSlice - 1].getPixel(x, y, mag);
        }
        catch (Exception e) {
            IJError.print(e);
            return new int[4];
        }
    }

    public ImageStack createEmptyStack() {
        Utils.log("PatchStack: can't createEmptyStack");
        return null;
    }

    public ImageStack getStack() {
        return this.stack;
    }

    public ImageStack getImageStack() {
        return this.stack;
    }

    public int getCurrentSlice() {
        return this.currentSlice;
    }

    public synchronized void setSlice(int index) {
        if (index == this.currentSlice) {
            return;
        }
        if (index >= 1 && index <= this.patch.length) {
            Roi roi = this.getRoi();
            if (null != roi) {
                roi.endPaste();
            }
            this.currentSlice = index;
        }
    }

    public Roi getRoi() {
        return this.roi;
    }

    private Roi getImpRoi() {
        return this.roi;
    }

    public void setRoi(Roi roi) {
        this.killRoi();
        if (null == roi) {
            this.roi = null;
            return;
        }
        Rectangle b = this.getBounds();
        Roi roi2 = (Roi)roi.clone();
        Rectangle r = roi2.getBounds();
        roi2.setLocation(r.x - b.x, r.y - b.y);
        roi = roi2;
        if (roi.isVisible()) {
            roi = (Roi)roi.clone();
        }
        Rectangle bounds = roi.getBounds();
        if (0 == bounds.width && 0 == bounds.height) {
            return;
        }
        this.roi = roi;
        ImagePlus imp = this.patch[this.currentSlice - 1].getProject().getLoader().fetchImagePlus(this.patch[this.currentSlice - 1]);
        imp.setRoi(roi);
        ImageProcessor ip = imp.getProcessor();
        if (null != ip) {
            ip.setMask(null);
            ip.setRoi(bounds);
        }
        this.roi.setImage((ImagePlus)this);
    }

    public void setRoi(Rectangle r) {
        if (null == r) {
            this.killRoi();
            return;
        }
        this.killRoi();
        this.roi = new Roi(r.x, r.y, r.width, r.height);
        this.roi.setImage((ImagePlus)this);
        ImagePlus imp = this.patch[this.currentSlice - 1].getProject().getLoader().fetchImagePlus(this.patch[this.currentSlice - 1]);
        ImageProcessor ip = imp.getProcessor();
        if (null != ip) {
            ip.setMask(null);
            ip.setRoi(r);
        }
    }

    public void createNewRoi(int sx, int sy) {
        super.createNewRoi(sx, sy);
        this.roi = this.getRoi();
    }

    public void killRoi() {
        ImagePlus imp;
        if (null != this.roi) {
            this.saveRoi();
            this.roi = null;
        }
        if (null != (imp = this.patch[this.currentSlice - 1].getProject().getLoader().getCachedImagePlus(this.patch[this.currentSlice - 1].getId()))) {
            imp.killRoi();
        }
    }

    public void saveRoi() {
        if (null != this.roi) {
            this.roi.endPaste();
            Rectangle r = this.roi.getBounds();
            if (r.width > 0 && r.height > 0) {
                Roi.previousRoi = (Roi)this.roi.clone();
            }
        }
    }

    public FileInfo getFileInfo() {
        ImagePlus imp = this.patch[this.currentSlice - 1].getProject().getLoader().fetchImagePlus(this.patch[this.currentSlice - 1]);
        return imp.getFileInfo();
    }

    public synchronized void flush() {
    }

    public Calibration getCalibration() {
        return this.getLocalCalibration();
    }

    public void setCalibration(Calibration cal) {
        this.patch[0].getLayer().getParent().setCalibration(cal);
        super.setCalibration(cal);
        for (int i = 0; i < this.patch.length; ++i) {
            ImagePlus imp = this.patch[i].getProject().getLoader().fetchImagePlus(this.patch[i]);
            imp.setCalibration(cal);
            if (imp.getStackSize() <= 1) continue;
            return;
        }
    }

    public Calibration getLocalCalibration() {
        return this.patch[this.currentSlice - 1].getLayer().getParent().getCalibrationCopy();
    }

    public void copy(boolean cut) {
        super.copy(cut);
    }

    public void paste() {
        super.paste();
        ImagePlus imp = this.patch[this.currentSlice - 1].getProject().getLoader().fetchImagePlus(this.patch[this.currentSlice - 1]);
        imp.changes = true;
        this.patch[this.currentSlice - 1].updateInDatabase("tiff_working");
    }

    public void decacheAll() {
        HashSet<ImagePlus> hs = new HashSet<ImagePlus>();
        Loader loader = this.patch[this.currentSlice - 1].getProject().getLoader();
        for (int i = 0; i < this.patch.length; ++i) {
            ImagePlus imp = loader.fetchImagePlus(this.patch[i]);
            if (hs.contains(imp)) continue;
            if (null != imp) {
                hs.add(imp);
            }
            loader.decache(imp);
            loader.flushMipMaps(this.patch[i].getId());
            Display.repaint(this.patch[i].getLayer(), (Displayable)this.patch[i], 0);
        }
    }

    public void setPosition(int channel, int slice, int frame) {
        if (slice >= 1 && slice <= this.patch.length) {
            this.currentSlice = slice;
        }
    }

    public int getStackIndex(int channel, int slice, int frame) {
        return slice;
    }

    public ImagePlus createGray8Copy() {
        Rectangle box = this.patch[0].getBoundingBox();
        int width = box.width;
        int height = box.height;
        ImageStack st = new ImageStack(width, height);
        Loader loader = this.patch[0].getProject().getLoader();
        for (int i = 1; i < this.patch.length; ++i) {
            loader.releaseToFit(width * height);
            st.addSlice(Integer.toString(i), this.stack.getProcessor(i).convertToByte(true));
        }
        ImagePlus imp = new ImagePlus("byte", st);
        imp.setCalibration(this.patch[0].getLayer().getParent().getCalibrationCopy());
        return imp;
    }

    public ImagePlus createColor256Copy() {
        Rectangle box = this.patch[0].getBoundingBox();
        int width = box.width;
        int height = box.height;
        Loader loader = this.patch[0].getProject().getLoader();
        this.patch[0].getProject().getLoader().releaseToFit(4 * this.patch.length * width * height);
        ColorProcessor montage = new ColorProcessor(width * this.patch.length, height);
        for (int i = 0; i < this.patch.length; ++i) {
            montage.insert(this.stack.getProcessor(i + 1), i * width, 0);
        }
        MedianCut mc = new MedianCut(montage);
        loader.releaseToFit(this.patch.length * width * height);
        ImageProcessor m2 = mc.convertToByte(256);
        ImageStack st = new ImageStack(width, height);
        for (int i = 0; i < this.patch.length; ++i) {
            m2.setRoi(i * width, 0, width, height);
            loader.releaseToFit(width * height);
            st.addSlice(null, m2.crop());
        }
        ImagePlus imp = new ImagePlus("color256", st);
        imp.setCalibration(this.patch[0].getLayer().getParent().getCalibrationCopy());
        return imp;
    }

    final class VirtualStack
    extends ImageStack {
        VirtualStack(int width, int height) {
            super(width, height);
        }

        public void addSlice(String label, ImageProcessor ip) {
            Utils.log("PatchStack: Can't add a slice.");
        }

        public void addSlice(String label, Object pixels) {
            Utils.log("PatchStack: Can't add a slice.");
        }

        public void addSlice(String label, Object pixels, int n) {
            Utils.log("PatchStack: Can't add a slice.");
        }

        public void addUInsignedShortSlice(String label, Object pixels) {
            Utils.log("PatchStack: Can't add a slice.");
        }

        public void deleteSlice(int n) {
            Utils.log("PatchStack: Can't delete a slice.");
        }

        public void deleteLastSlice() {
            Utils.log("PatchStack: Can't delete last slice.");
        }

        public int getWidth() {
            return PatchStack.this.width;
        }

        public int getHeight() {
            return PatchStack.this.height;
        }

        public Object getPixels(int n) {
            if (n < 1 || n > PatchStack.this.patch.length) {
                throw new IllegalArgumentException("PatchStack: out of range " + n);
            }
            ImagePlus imp = PatchStack.this.patch[n - 1].getProject().getLoader().fetchImagePlus(PatchStack.this.patch[n - 1]);
            return imp.getProcessor().getPixels();
        }

        public void setPixels(Object pixels, int n) {
            if (n < 1 || n > PatchStack.this.patch.length) {
                throw new IllegalArgumentException("PatchStack: out of range " + n);
            }
            if (null == pixels) {
                throw new IllegalArgumentException("PatchStack: 'pixels' is null!");
            }
            ImagePlus imp = PatchStack.this.patch[n - 1].getProject().getLoader().fetchImagePlus(PatchStack.this.patch[n - 1]);
            imp.getProcessor().setPixels(pixels);
            PatchStack.this.patch[n - 1].updateInDatabase("tiff_working");
        }

        public Object[] getImageArray() {
            Object[] ob = new Object[PatchStack.this.patch.length];
            for (int i = 0; i < ob.length; ++i) {
                ImagePlus imp = PatchStack.this.patch[i].getProject().getLoader().fetchImagePlus(PatchStack.this.patch[i]);
                ob[i] = imp.getProcessor().getPixels();
            }
            return ob;
        }

        public int getSize() {
            return PatchStack.this.patch.length;
        }

        public String[] getSliceLabels() {
            String[] labels = new String[PatchStack.this.patch.length];
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = PatchStack.this.patch[i].getTitle();
            }
            return labels;
        }

        public String getSliceLabel(int n) {
            if (n < 1 || n > PatchStack.this.patch.length) {
                throw new IllegalArgumentException("PatchStack: out of range " + n);
            }
            return PatchStack.this.patch[n - 1].getTitle();
        }

        public String getShortSliceLabel(int n) {
            int len;
            String shortLabel = this.getSliceLabel(n);
            if (shortLabel == null) {
                return null;
            }
            int newline = shortLabel.indexOf(10);
            if (0 == newline) {
                return null;
            }
            if (newline > 0) {
                shortLabel = shortLabel.substring(0, newline);
            }
            if ((len = shortLabel.length()) > 4 && '.' == shortLabel.charAt(len - 4) && Character.isDigit(shortLabel.charAt(len - 1))) {
                shortLabel = shortLabel.substring(0, len - 4);
            }
            if (shortLabel.length() > 60) {
                shortLabel = shortLabel.substring(0, 60);
            }
            return shortLabel;
        }

        public void setSliceLabel(String label, int n) {
            if (n < 1 || n > PatchStack.this.patch.length) {
                throw new IllegalArgumentException("PatchStack: out of range " + n);
            }
            if (null != label) {
                PatchStack.this.patch[n - 1].setTitle(label);
            }
        }

        public ImageProcessor getProcessor(int n) {
            if (n < 1 || n > PatchStack.this.patch.length) {
                throw new IllegalArgumentException("PatchStack: out of range " + n);
            }
            ImagePlus imp = PatchStack.this.patch[n - 1].getProject().getLoader().fetchImagePlus(PatchStack.this.patch[n - 1]);
            ImageProcessor ip = imp.getProcessor();
            Roi roi = PatchStack.this.getImpRoi();
            if (null != roi) {
                imp.setRoi(roi);
            }
            ((PatchStack)PatchStack.this).called[n - 1] = true;
            return ip;
        }

        public boolean isRGB() {
            return PatchStack.this.getType() == 4;
        }

        public boolean isHSB() {
            return false;
        }

        public boolean isVirtual() {
            return true;
        }

        public void trim() {
            Utils.log("PatchStack.VirtualStack: can't trim");
        }

        public String toString() {
            return "Virtual Patch Stack: width=" + PatchStack.this.width + ", height=" + PatchStack.this.height + ", nSlices: " + PatchStack.this.patch.length;
        }
    }
}

